/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.Disposable;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.util.IOExceptionSupport;

public class ActiveMQOutputStream
extends OutputStream
implements Disposable {
    final byte[] buffer = new byte[65536];
    protected int count;
    private final ActiveMQConnection connection;
    private final HashMap properties;
    private final ProducerInfo info;
    private long messageSequence;
    private boolean closed;
    private final int deliveryMode;
    private final int priority;
    private final long timeToLive;

    public ActiveMQOutputStream(ActiveMQConnection connection, ProducerId producerId, ActiveMQDestination destination, Map properties, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.connection = connection;
        this.deliveryMode = deliveryMode;
        this.priority = priority;
        this.timeToLive = timeToLive;
        HashMap hashMap = this.properties = properties == null ? null : new HashMap(properties);
        if (destination == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        this.info = new ProducerInfo(producerId);
        this.info.setDestination(destination);
        this.connection.addOutputStream(this);
        this.connection.asyncSendPacket(this.info);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.flushBuffer();
            try {
                this.send(new ActiveMQMessage(), true);
                this.dispose();
                this.connection.asyncSendPacket(this.info.createRemoveCommand());
            }
            catch (JMSException e) {
                IOExceptionSupport.create((Exception)((Object)e));
            }
        }
    }

    public void dispose() {
        if (!this.closed) {
            this.connection.removeOutputStream(this);
            this.closed = true;
        }
    }

    public synchronized void write(int b) throws IOException {
        this.buffer[this.count++] = (byte)b;
        if (this.count == this.buffer.length) {
            this.flushBuffer();
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int max = Math.min(len, this.buffer.length - this.count);
            System.arraycopy(b, off, this.buffer, this.count, max);
            len -= max;
            this.count += max;
            off += max;
            if (this.count != this.buffer.length) continue;
            this.flushBuffer();
        }
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
            msg.writeBytes(this.buffer, 0, this.count);
            this.send(msg, false);
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create((Exception)((Object)e));
        }
        this.count = 0;
    }

    private void send(ActiveMQMessage msg, boolean eosMessage) throws JMSException {
        if (this.properties != null) {
            Iterator iter = this.properties.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = this.properties.get(key);
                msg.setObjectProperty(key, value);
            }
        }
        msg.setType("org.apache.activemq.Stream");
        msg.setGroupID(this.info.getProducerId().toString());
        if (eosMessage) {
            msg.setGroupSequence(-1);
        } else {
            msg.setGroupSequence((int)this.messageSequence);
        }
        MessageId id = new MessageId(this.info.getProducerId(), this.messageSequence++);
        this.connection.send(this.info.getDestination(), msg, id, this.deliveryMode, this.priority, this.timeToLive, !eosMessage);
    }

    public String toString() {
        return "ActiveMQOutputStream { producerId=" + this.info.getProducerId() + " }";
    }
}

