/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import org.apache.activemq.ActiveMQConnectionConsumer;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQConnectionMetaData;
import org.apache.activemq.ActiveMQDispatcher;
import org.apache.activemq.ActiveMQInputStream;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.ActiveMQOutputStream;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.ActiveMQQueueSession;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicSession;
import org.apache.activemq.AdvisoryConsumer;
import org.apache.activemq.Closeable;
import org.apache.activemq.ConnectionClosedException;
import org.apache.activemq.ConnectionFailedException;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.StreamConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ControlCommand;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.management.JMSConnectionStatsImpl;
import org.apache.activemq.management.JMSStatsImpl;
import org.apache.activemq.management.StatsCapable;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQConnection
implements Connection,
TopicConnection,
QueueConnection,
StatsCapable,
Closeable,
StreamConnection,
TransportListener {
    private TaskRunnerFactory sessionTaskRunner = new TaskRunnerFactory("ActiveMQ Session Task", 7, true, 1000);
    private final ThreadPoolExecutor asyncConnectionThread;
    private static final Log log = LogFactory.getLog((Class)ActiveMQConnection.class);
    private static final IdGenerator connectionIdGenerator = new IdGenerator();
    public static final String DEFAULT_USER = ActiveMQConnectionFactory.DEFAULT_USER;
    public static final String DEFAULT_PASSWORD = ActiveMQConnectionFactory.DEFAULT_PASSWORD;
    public static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    private final ConnectionInfo info;
    private ExceptionListener exceptionListener;
    private boolean clientIDSet;
    private boolean isConnectionInfoSentToBroker;
    private boolean userSpecifiedClientID;
    private ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
    private RedeliveryPolicy redeliveryPolicy;
    private boolean disableTimeStampsByDefault = false;
    private boolean optimizedMessageDispatch = true;
    private boolean copyMessageOnSend = true;
    private boolean useCompression = false;
    private boolean objectMessageSerializationDefered = false;
    protected boolean dispatchAsync = false;
    protected boolean alwaysSessionAsync = true;
    private boolean useAsyncSend = false;
    private boolean optimizeAcknowledge = false;
    private boolean nestedMapAndListEnabled = true;
    private boolean useRetroactiveConsumer;
    private int closeTimeout = 15000;
    private final Transport transport;
    private final IdGenerator clientIdGenerator;
    private final JMSStatsImpl factoryStats;
    private final JMSConnectionStatsImpl stats;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean transportFailed = new AtomicBoolean(false);
    private final CopyOnWriteArrayList sessions = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList connectionConsumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList inputStreams = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList outputStreams = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList transportListeners = new CopyOnWriteArrayList();
    private final ConcurrentHashMap dispatchers = new ConcurrentHashMap();
    private final LongSequenceGenerator sessionIdGenerator = new LongSequenceGenerator();
    private final SessionId connectionSessionId;
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator tempDestinationIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator localTransactionIdGenerator = new LongSequenceGenerator();
    final ConcurrentHashMap activeTempDestinations = new ConcurrentHashMap();
    private AdvisoryConsumer advisoryConsumer;
    private final CountDownLatch brokerInfoReceived = new CountDownLatch(1);
    private BrokerInfo brokerInfo;
    private IOException firstFailureError;

    protected ActiveMQConnection(final Transport transport, IdGenerator clientIdGenerator, JMSStatsImpl factoryStats) throws Exception {
        this.transport = transport;
        this.clientIdGenerator = clientIdGenerator;
        this.factoryStats = factoryStats;
        this.asyncConnectionThread = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "AcitveMQ Connection Worker: " + transport);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.asyncConnectionThread.allowCoreThreadTimeOut(true);
        this.info = new ConnectionInfo(new ConnectionId(connectionIdGenerator.generateId()));
        this.info.setManageable(true);
        this.connectionSessionId = new SessionId(this.info.getConnectionId(), -1L);
        this.transport.setTransportListener(this);
        this.stats = new JMSConnectionStatsImpl((List)this.sessions, this instanceof XAConnection);
        this.factoryStats.addConnection(this);
    }

    protected void setUserName(String userName) {
        this.info.setUserName(userName);
    }

    protected void setPassword(String password) {
        this.info.setPassword(password);
    }

    public static ActiveMQConnection makeConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String uri) throws JMSException, URISyntaxException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String user, String password, String uri) throws JMSException, URISyntaxException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(user, password, new URI(uri));
        return (ActiveMQConnection)factory.createConnection();
    }

    public JMSConnectionStatsImpl getConnectionStats() {
        return this.stats;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        boolean doSessionAsync = this.alwaysSessionAsync || this.sessions.size() > 0 || transacted || acknowledgeMode == 2;
        return new ActiveMQSession(this, this.getNextSessionId(), transacted ? 0 : (acknowledgeMode == 0 ? 1 : acknowledgeMode), this.dispatchAsync, this.alwaysSessionAsync);
    }

    protected SessionId getNextSessionId() {
        return new SessionId(this.info.getConnectionId(), this.sessionIdGenerator.getNextSequenceId());
    }

    public String getClientID() throws JMSException {
        this.checkClosedOrFailed();
        return this.info.getClientId();
    }

    public void setClientID(String newClientID) throws JMSException {
        this.checkClosedOrFailed();
        if (this.clientIDSet) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("Setting clientID on a used Connection is not allowed");
        }
        this.info.setClientId(newClientID);
        this.userSpecifiedClientID = true;
        this.ensureConnectionInfoSent();
    }

    public void setDefaultClientID(String clientID) throws JMSException {
        this.info.setClientId(clientID);
        this.userSpecifiedClientID = true;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosedOrFailed();
        return ActiveMQConnectionMetaData.INSTANCE;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosedOrFailed();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosedOrFailed();
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        if (this.started.compareAndSet(false, true)) {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession session = (ActiveMQSession)i.next();
                session.start();
            }
        }
    }

    public void stop() throws JMSException {
        this.checkClosedOrFailed();
        if (this.started.compareAndSet(true, false)) {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.checkClosed();
        try {
            this.stop();
            ActiveMQConnection activeMQConnection = this;
            synchronized (activeMQConnection) {
                if (!this.closed.get()) {
                    Object c;
                    this.closing.set(true);
                    if (this.advisoryConsumer != null) {
                        this.advisoryConsumer.dispose();
                        this.advisoryConsumer = null;
                    }
                    Iterator i = this.sessions.iterator();
                    while (i.hasNext()) {
                        ActiveMQSession s = (ActiveMQSession)i.next();
                        s.dispose();
                    }
                    i = this.connectionConsumers.iterator();
                    while (i.hasNext()) {
                        c = (ActiveMQConnectionConsumer)i.next();
                        ((ActiveMQConnectionConsumer)c).dispose();
                    }
                    i = this.inputStreams.iterator();
                    while (i.hasNext()) {
                        c = (ActiveMQInputStream)i.next();
                        ((ActiveMQInputStream)c).dispose();
                    }
                    i = this.outputStreams.iterator();
                    while (i.hasNext()) {
                        c = (ActiveMQOutputStream)i.next();
                        ((ActiveMQOutputStream)c).dispose();
                    }
                    if (this.isConnectionInfoSentToBroker) {
                        this.syncSendPacket(this.info.createRemoveCommand(), this.closeTimeout);
                    }
                    this.asyncSendPacket(new ShutdownInfo());
                    ServiceSupport.dispose(this.transport);
                    this.started.set(false);
                    this.sessionTaskRunner.shutdown();
                    this.closed.set(true);
                    this.closing.set(false);
                }
            }
        }
        finally {
            this.factoryStats.removeConnection(this);
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        SessionId sessionId = new SessionId(this.info.getConnectionId(), -1L);
        ConsumerInfo info = new ConsumerInfo(new ConsumerId(sessionId, this.consumerIdGenerator.getNextSequenceId()));
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)topic));
        info.setSubscriptionName(subscriptionName);
        info.setSelector(messageSelector);
        info.setPrefetchSize(maxMessages);
        info.setDispatchAsync(this.dispatchAsync);
        if (info.getDestination().getOptions() != null) {
            HashMap options = new HashMap(info.getDestination().getOptions());
            IntrospectionSupport.setProperties(this.info, options, "consumer.");
        }
        return new ActiveMQConnectionConsumer(this, sessionPool, info);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public boolean isTransportFailed() {
        return this.transportFailed.get();
    }

    public ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(ActiveMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public Transport getTransportChannel() {
        return this.transport;
    }

    public String getInitializedClientID() throws JMSException {
        this.ensureConnectionInfoSent();
        return this.info.getClientId();
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean timeStampsDisableByDefault) {
        this.disableTimeStampsByDefault = timeStampsDisableByDefault;
    }

    public boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    public void setOptimizedMessageDispatch(boolean dispatchOptimizedMessage) {
        this.optimizedMessageDispatch = dispatchOptimizedMessage;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.info;
    }

    public boolean isUseRetroactiveConsumer() {
        return this.useRetroactiveConsumer;
    }

    public void setUseRetroactiveConsumer(boolean useRetroactiveConsumer) {
        this.useRetroactiveConsumer = useRetroactiveConsumer;
    }

    public boolean isNestedMapAndListEnabled() {
        return this.nestedMapAndListEnabled;
    }

    public void setNestedMapAndListEnabled(boolean structuredMapsEnabled) {
        this.nestedMapAndListEnabled = structuredMapsEnabled;
    }

    public void addTransportListener(TransportListener transportListener) {
        this.transportListeners.add((Object)transportListener);
    }

    public void removeTransportListener(TransportListener transportListener) {
        this.transportListeners.remove((Object)transportListener);
    }

    public TaskRunnerFactory getSessionTaskRunner() {
        return this.sessionTaskRunner;
    }

    public void setSessionTaskRunner(TaskRunnerFactory sessionTaskRunner) {
        this.sessionTaskRunner = sessionTaskRunner;
    }

    public boolean isStatsEnabled() {
        return this.stats.isEnabled();
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.stats.setEnabled(statsEnabled);
    }

    protected void addSession(ActiveMQSession session) throws JMSException {
        this.sessions.add((Object)session);
        if (this.sessions.size() > 1 || session.isTransacted()) {
            this.optimizedMessageDispatch = false;
        }
    }

    protected void removeSession(ActiveMQSession session) {
        this.sessions.remove((Object)session);
    }

    protected void addConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) throws JMSException {
        this.connectionConsumers.add((Object)connectionConsumer);
    }

    protected void removeConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) {
        this.connectionConsumers.remove((Object)connectionConsumer);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQTopicSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)queue, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        ConsumerId consumerId = this.createConsumerId();
        ConsumerInfo info = new ConsumerInfo(consumerId);
        info.setDestination(ActiveMQMessageTransformation.transformDestination(destination));
        info.setSelector(messageSelector);
        info.setPrefetchSize(maxMessages);
        info.setNoLocal(noLocal);
        info.setDispatchAsync(this.dispatchAsync);
        if (info.getDestination().getOptions() != null) {
            HashMap options = new HashMap(info.getDestination().getOptions());
            IntrospectionSupport.setProperties(this.info, options, "consumer.");
        }
        return new ActiveMQConnectionConsumer(this, sessionPool, info);
    }

    private ConsumerId createConsumerId() {
        return new ConsumerId(this.connectionSessionId, this.consumerIdGenerator.getNextSequenceId());
    }

    private ProducerId createProducerId() {
        return new ProducerId(this.connectionSessionId, this.producerIdGenerator.getNextSequenceId());
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQQueueSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public void checkClientIDWasManuallySpecified() throws JMSException {
        if (!this.userSpecifiedClientID) {
            throw new JMSException("You cannot create a durable subscriber without specifying a unique clientID on a Connection");
        }
    }

    public void asyncSendPacket(Command command) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        try {
            this.transport.oneway(command);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Response syncSendPacket(Command command) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        try {
            Response response = (Response)this.transport.request(command);
            if (response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                if (er.getException() instanceof JMSException) {
                    throw (JMSException)er.getException();
                }
                throw JMSExceptionSupport.create(er.getException());
            }
            return response;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Response syncSendPacket(Command command, int timeout) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        try {
            Response response = (Response)this.transport.request(command, timeout);
            if (response != null && response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                if (er.getException() instanceof JMSException) {
                    throw (JMSException)er.getException();
                }
                throw JMSExceptionSupport.create(er.getException());
            }
            return response;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    protected synchronized void checkClosedOrFailed() throws JMSException {
        this.checkClosed();
        if (this.transportFailed.get()) {
            throw new ConnectionFailedException(this.firstFailureError);
        }
    }

    protected synchronized void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw new ConnectionClosedException();
        }
    }

    protected synchronized void ensureConnectionInfoSent() throws JMSException {
        if (this.isConnectionInfoSentToBroker || this.closed.get()) {
            return;
        }
        if (this.info.getClientId() == null || this.info.getClientId().trim().length() == 0) {
            this.info.setClientId(this.clientIdGenerator.generateId());
        }
        this.syncSendPacket(this.info);
        this.isConnectionInfoSentToBroker = true;
        ConsumerId consumerId = new ConsumerId(new SessionId(this.info.getConnectionId(), -1L), this.consumerIdGenerator.getNextSequenceId());
        this.advisoryConsumer = new AdvisoryConsumer(this, consumerId);
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public void cleanup() throws JMSException {
        Object c;
        if (this.advisoryConsumer != null) {
            this.advisoryConsumer.dispose();
            this.advisoryConsumer = null;
        }
        Iterator i = this.sessions.iterator();
        while (i.hasNext()) {
            ActiveMQSession s = (ActiveMQSession)i.next();
            s.dispose();
        }
        i = this.connectionConsumers.iterator();
        while (i.hasNext()) {
            c = (ActiveMQConnectionConsumer)i.next();
            ((ActiveMQConnectionConsumer)c).dispose();
        }
        i = this.inputStreams.iterator();
        while (i.hasNext()) {
            c = (ActiveMQInputStream)i.next();
            ((ActiveMQInputStream)c).dispose();
        }
        i = this.outputStreams.iterator();
        while (i.hasNext()) {
            c = (ActiveMQOutputStream)i.next();
            ((ActiveMQOutputStream)c).dispose();
        }
        if (this.isConnectionInfoSentToBroker) {
            if (!this.transportFailed.get() && !this.closing.get()) {
                this.asyncSendPacket(this.info.createRemoveCommand());
            }
            this.isConnectionInfoSentToBroker = false;
        }
        if (this.userSpecifiedClientID) {
            this.info.setClientId(null);
            this.userSpecifiedClientID = false;
        }
        this.clientIDSet = false;
        this.started.set(false);
    }

    public void changeUserInfo(String userName, String password) throws JMSException {
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("changeUserInfo used Connection is not allowed");
        }
        this.info.setUserName(userName);
        this.info.setPassword(password);
    }

    public String getResourceManagerId() throws JMSException {
        this.waitForBrokerInfo();
        if (this.brokerInfo == null) {
            throw new JMSException("Connection failed before Broker info was received.");
        }
        return this.brokerInfo.getBrokerId().getValue();
    }

    public String getBrokerName() {
        if (this.brokerInfo == null) {
            return null;
        }
        return this.brokerInfo.getBrokerName();
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public RedeliveryPolicy getRedeliveryPolicy() throws JMSException {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public boolean isAlwaysSessionAsync() {
        return this.alwaysSessionAsync;
    }

    public void setAlwaysSessionAsync(boolean alwaysSessionAsync) {
        this.alwaysSessionAsync = alwaysSessionAsync;
    }

    public boolean isOptimizeAcknowledge() {
        return this.optimizeAcknowledge;
    }

    public void setOptimizeAcknowledge(boolean optimizeAcknowledge) {
        this.optimizeAcknowledge = optimizeAcknowledge;
    }

    private void waitForBrokerInfo() throws JMSException {
        try {
            this.brokerInfoReceived.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JMSExceptionSupport.create(e);
        }
    }

    Transport getTransport() {
        return this.transport;
    }

    public void addDispatcher(ConsumerId consumerId, ActiveMQDispatcher dispatcher) {
        this.dispatchers.put((Object)consumerId, (Object)dispatcher);
    }

    public void removeDispatcher(ConsumerId consumerId) {
        this.dispatchers.remove((Object)consumerId);
    }

    public void onCommand(Object o) {
        final Command command = (Command)o;
        if (!this.closed.get() && command != null) {
            if (command.isMessageDispatch()) {
                MessageDispatch md = (MessageDispatch)command;
                ActiveMQDispatcher dispatcher = (ActiveMQDispatcher)this.dispatchers.get((Object)md.getConsumerId());
                if (dispatcher != null) {
                    Message msg = md.getMessage();
                    if (msg != null) {
                        msg = msg.copy();
                        msg.setReadOnlyBody(true);
                        msg.setReadOnlyProperties(true);
                        msg.setRedeliveryCounter(md.getRedeliveryCounter());
                        msg.setConnection(this);
                        md.setMessage(msg);
                    }
                    dispatcher.dispatch(md);
                }
            } else if (command.isBrokerInfo()) {
                this.brokerInfo = (BrokerInfo)command;
                this.brokerInfoReceived.countDown();
                this.optimizeAcknowledge &= !this.brokerInfo.isFaultTolerantConfiguration();
            } else if (command instanceof ControlCommand) {
                this.onControlCommand((ControlCommand)command);
            } else if (command.getDataStructureType() == 16) {
                this.asyncConnectionThread.execute(new Runnable(){

                    public void run() {
                        ActiveMQConnection.this.onAsyncException(((ConnectionError)command).getException());
                    }
                });
                new Thread("Async error worker"){}.start();
            } else if (command instanceof ConnectionControl) {
                this.onConnectionControl((ConnectionControl)command);
            } else if (command instanceof ConsumerControl) {
                this.onConsumerControl((ConsumerControl)command);
            }
        }
        Iterator iter = this.transportListeners.iterator();
        while (iter.hasNext()) {
            TransportListener listener = (TransportListener)iter.next();
            listener.onCommand(command);
        }
    }

    public void onAsyncException(Throwable error) {
        if (!this.closed.get() && !this.closing.get()) {
            if (this.exceptionListener != null) {
                if (!(error instanceof JMSException)) {
                    error = JMSExceptionSupport.create(error);
                }
                final JMSException e = (JMSException)error;
                this.asyncConnectionThread.execute(new Runnable(){

                    public void run() {
                        ActiveMQConnection.this.exceptionListener.onException(e);
                    }
                });
            } else {
                log.warn((Object)("Async exception with no exception listener: " + error), error);
            }
        }
    }

    public void onException(final IOException error) {
        this.onAsyncException(error);
        this.asyncConnectionThread.execute(new Runnable(){

            public void run() {
                ActiveMQConnection.this.transportFailed(error);
                ServiceSupport.dispose(ActiveMQConnection.this.transport);
                ActiveMQConnection.this.brokerInfoReceived.countDown();
                Iterator iter = ActiveMQConnection.this.transportListeners.iterator();
                while (iter.hasNext()) {
                    TransportListener listener = (TransportListener)iter.next();
                    listener.onException(error);
                }
            }
        });
    }

    public void transportInterupted() {
        Iterator i = this.sessions.iterator();
        while (i.hasNext()) {
            ActiveMQSession s = (ActiveMQSession)i.next();
            s.clearMessagesInProgress();
        }
        Iterator iter = this.transportListeners.iterator();
        while (iter.hasNext()) {
            TransportListener listener = (TransportListener)iter.next();
            listener.transportInterupted();
        }
    }

    public void transportResumed() {
        Iterator iter = this.transportListeners.iterator();
        while (iter.hasNext()) {
            TransportListener listener = (TransportListener)iter.next();
            listener.transportResumed();
        }
        Iterator i = this.sessions.iterator();
        while (i.hasNext()) {
            ActiveMQSession s = (ActiveMQSession)i.next();
            s.deliverAcks();
        }
    }

    protected ActiveMQTempDestination createTempDestination(boolean topic) throws JMSException {
        ActiveMQTempDestination dest = topic ? new ActiveMQTempTopic(this.info.getConnectionId(), this.tempDestinationIdGenerator.getNextSequenceId()) : new ActiveMQTempQueue(this.info.getConnectionId(), this.tempDestinationIdGenerator.getNextSequenceId());
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)0);
        info.setDestination(dest);
        this.syncSendPacket(info);
        dest.setConnection(this);
        this.activeTempDestinations.put((Object)dest, (Object)dest);
        return dest;
    }

    public void deleteTempDestination(ActiveMQTempDestination destination) throws JMSException {
        this.checkClosedOrFailed();
        this.activeTempDestinations.remove((Object)destination);
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)1);
        info.setDestination(destination);
        info.setTimeout(0L);
        this.syncSendPacket(info);
    }

    public boolean isDeleted(ActiveMQDestination dest) {
        return !this.activeTempDestinations.contains((Object)dest);
    }

    public boolean isCopyMessageOnSend() {
        return this.copyMessageOnSend;
    }

    public LongSequenceGenerator getLocalTransactionIdGenerator() {
        return this.localTransactionIdGenerator;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public void destroyDestination(ActiveMQDestination destination) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)1);
        info.setDestination(destination);
        info.setTimeout(0L);
        this.syncSendPacket(info);
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean asyncDispatch) {
        this.dispatchAsync = asyncDispatch;
    }

    public boolean isObjectMessageSerializationDefered() {
        return this.objectMessageSerializationDefered;
    }

    public void setObjectMessageSerializationDefered(boolean objectMessageSerializationDefered) {
        this.objectMessageSerializationDefered = objectMessageSerializationDefered;
    }

    public InputStream createInputStream(Destination dest) throws JMSException {
        return this.createInputStream(dest, null);
    }

    public InputStream createInputStream(Destination dest, String messageSelector) throws JMSException {
        return this.createInputStream(dest, messageSelector, false);
    }

    public InputStream createInputStream(Destination dest, String messageSelector, boolean noLocal) throws JMSException {
        return this.doCreateInputStream(dest, messageSelector, noLocal, null);
    }

    public InputStream createDurableInputStream(Topic dest, String name) throws JMSException {
        return this.createInputStream((Destination)dest, null, false);
    }

    public InputStream createDurableInputStream(Topic dest, String name, String messageSelector) throws JMSException {
        return this.createDurableInputStream(dest, name, messageSelector, false);
    }

    public InputStream createDurableInputStream(Topic dest, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.doCreateInputStream((Destination)dest, messageSelector, noLocal, name);
    }

    private InputStream doCreateInputStream(Destination dest, String messageSelector, boolean noLocal, String subName) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        return new ActiveMQInputStream(this, this.createConsumerId(), ActiveMQDestination.transform(dest), messageSelector, noLocal, subName, this.prefetchPolicy.getInputStreamPrefetch());
    }

    public OutputStream createOutputStream(Destination dest) throws JMSException {
        return this.createOutputStream(dest, null, 2, 4, 0L);
    }

    public OutputStream createNonPersistentOutputStream(Destination dest) throws JMSException {
        return this.createOutputStream(dest, null, 1, 4, 0L);
    }

    public OutputStream createOutputStream(Destination dest, Map streamProperties, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        return new ActiveMQOutputStream(this, this.createProducerId(), ActiveMQDestination.transform(dest), streamProperties, deliveryMode, priority, timeToLive);
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosedOrFailed();
        RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
        rsi.setConnectionId(this.getConnectionInfo().getConnectionId());
        rsi.setSubcriptionName(name);
        rsi.setClientId(this.getConnectionInfo().getClientId());
        this.syncSendPacket(rsi);
    }

    void send(ActiveMQDestination destination, ActiveMQMessage msg, MessageId messageId, int deliveryMode, int priority, long timeToLive, boolean async) throws JMSException {
        this.checkClosedOrFailed();
        if (destination.isTemporary() && this.isDeleted(destination)) {
            throw new JMSException("Cannot publish to a deleted Destination: " + destination);
        }
        msg.setJMSDestination(destination);
        msg.setJMSDeliveryMode(deliveryMode);
        long expiration = 0L;
        if (!this.isDisableTimeStampsByDefault()) {
            long timeStamp = System.currentTimeMillis();
            msg.setJMSTimestamp(timeStamp);
            if (timeToLive > 0L) {
                expiration = timeToLive + timeStamp;
            }
        }
        msg.setJMSExpiration(expiration);
        msg.setJMSPriority(priority);
        msg.setJMSRedelivered(false);
        msg.setMessageId(messageId);
        msg.onSend();
        msg.setProducerId(msg.getMessageId().getProducerId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending message: " + msg));
        }
        if (async) {
            this.asyncSendPacket(msg);
        } else {
            this.syncSendPacket(msg);
        }
    }

    public void addOutputStream(ActiveMQOutputStream stream) {
        this.outputStreams.add((Object)stream);
    }

    public void removeOutputStream(ActiveMQOutputStream stream) {
        this.outputStreams.remove((Object)stream);
    }

    public void addInputStream(ActiveMQInputStream stream) {
        this.inputStreams.add((Object)stream);
    }

    public void removeInputStream(ActiveMQInputStream stream) {
        this.inputStreams.remove((Object)stream);
    }

    protected void onControlCommand(ControlCommand command) {
        String text = command.getCommand();
        if (text != null && text.equals("shutdown")) {
            log.info((Object)"JVM told to shutdown");
            System.exit(0);
        }
    }

    protected void onConnectionControl(ConnectionControl command) {
        if (command.isFaultTolerant()) {
            this.optimizeAcknowledge = false;
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.setOptimizeAcknowledge(false);
            }
        }
    }

    protected void onConsumerControl(ConsumerControl command) {
        if (command.isClose()) {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.close(command.getConsumerId());
            }
        } else {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.setPrefetchSize(command.getConsumerId(), command.getPrefetch());
            }
        }
    }

    protected void transportFailed(IOException error) {
        this.transportFailed.set(true);
        if (this.firstFailureError == null) {
            this.firstFailureError = error;
        }
        if (!this.closed.get() && !this.closing.get()) {
            try {
                this.cleanup();
            }
            catch (JMSException e) {
                log.warn((Object)"Cleanup failed", (Throwable)e);
            }
        }
    }

    public void setCopyMessageOnSend(boolean copyMessageOnSend) {
        this.copyMessageOnSend = copyMessageOnSend;
    }

    public String toString() {
        return "ActiveMQConnection {id=" + this.info.getConnectionId() + ",clientId=" + this.info.getClientId() + ",started=" + this.started.get() + "}";
    }
}

