/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.asm;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.ExecutableAccessor;
import org.mvel.ExecutableLiteral;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.PropertyAccessException;
import org.mvel.SetAccessor;
import org.mvel.asm.ClassWriter;
import org.mvel.asm.FieldVisitor;
import org.mvel.asm.Label;
import org.mvel.asm.MethodVisitor;
import org.mvel.asm.Type;
import org.mvel.ast.LiteralNode;
import org.mvel.ast.PropertyASTNode;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizationNotSupported;
import org.mvel.optimizers.impl.refl.Union;
import org.mvel.util.ArrayTools;
import org.mvel.util.CollectionParser;
import org.mvel.util.MethodStub;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private static final String MAP_IMPL = "java/util/HashMap";
    private static final String LIST_IMPL = "org/mvel/util/FastList";
    private static final int OPCODES_VERSION;
    private Object ctx;
    private Object thisRef;
    private VariableResolverFactory variableFactory;
    private static final Object[] EMPTYARG;
    private static final Class[] EMPTYCLS;
    private boolean first = true;
    private boolean deferFinish = false;
    private String className;
    private ClassWriter cw;
    private MethodVisitor mv;
    private Object val;
    private int stacksize = 1;
    private long time;
    private ArrayList<ExecutableStatement> compiledInputs;
    private Class returnType;
    private StringAppender buildLog;
    private static final ClassLoader classLoader;
    private static final Method defineClass;
    private int cnum = 3;
    private int lastCnum = 0;
    private static final int ARRAY = 0;
    private static final int LIST = 1;
    private static final int MAP = 2;
    private static final int VAL = 3;

    public ASMAccessorOptimizer() {
        new ClassWriter(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initJIT() {
        if (MVEL.isAdvancedDebugging()) {
            this.buildLog = new StringAppender();
        }
        this.cw = new ClassWriter(3);
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            int r = (int)Math.random() * 100;
            this.className = "ASMAccessorImpl_" + String.valueOf(this.cw.hashCode()).replaceAll("\\-", "_") + System.currentTimeMillis() / 10L + r;
            this.cw.visit(OPCODES_VERSION, 33, this.className, null, "java/lang/Object", new String[]{"org/mvel/Accessor"});
        }
        MethodVisitor m = this.cw.visitMethod(1, "<init>", "()V", null, null);
        m.visitCode();
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        m.visitInsn(177);
        m.visitMaxs(1, 1);
        m.visitEnd();
        this.mv = this.cw.visitMethod(1, "getValue", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
    }

    @Override
    public Accessor optimizeAccessor(char[] property, Object staticContext, Object thisRef, VariableResolverFactory factory, boolean root) {
        this.time = System.currentTimeMillis();
        this.compiledInputs = new ArrayList();
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.val = null;
        this.length = property.length;
        this.expr = property;
        this.ctx = staticContext;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this._initJIT();
        return this.compileAccessor();
    }

    @Override
    public SetAccessor optimizeSetAccessor(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value) {
        throw new RuntimeException("not implemented");
    }

    private void _finishJIT() {
        if (!this.deferFinish) {
            if (this.returnType != null && this.returnType.isPrimitive()) {
                this.wrapPrimitive(this.returnType);
            }
            if (this.returnType == Void.TYPE) {
                this.debug("ACONST_NULL");
                this.mv.visitInsn(1);
            }
            this.debug("ARETURN");
            this.mv.visitInsn(176);
        }
        this.debug("\n{METHOD STATS (maxstack=" + this.stacksize + ")}\n");
        this.mv.visitMaxs(this.stacksize, 1);
        this.mv.visitEnd();
        this.buildInputs();
        this.cw.visitEnd();
        this.dumpAdvancedDebugging();
    }

    private Accessor _initializeAccessor() throws Exception {
        Object o;
        Class cls = this.loadClass(this.className, this.cw.toByteArray());
        this.debug("[MVEL JIT Completed Optimization <<" + new String(this.expr) + ">>]::" + cls + " (time: " + (System.currentTimeMillis() - this.time) + "ms)");
        try {
            if (this.compiledInputs.size() == 0) {
                o = cls.newInstance();
            } else {
                Class[] parms = new Class[this.compiledInputs.size()];
                for (int i = 0; i < this.compiledInputs.size(); ++i) {
                    parms[i] = ExecutableStatement.class;
                }
                o = cls.getConstructor(parms).newInstance(this.compiledInputs.toArray(new ExecutableStatement[this.compiledInputs.size()]));
            }
        }
        catch (VerifyError e) {
            System.out.println("**** COMPILER BUG! REPORT THIS IMMEDIATELY AT http://jira.codehaus.org/browse/mvel");
            System.out.println("Expression: " + new String(this.expr));
            throw e;
        }
        if (!(o instanceof Accessor)) {
            this.dumpAdvancedDebugging();
            throw new RuntimeException("Classloader problem detected. JIT Class is not subclass of org.mvel.Accessor.");
        }
        return (Accessor)o;
    }

    private Accessor compileAccessor() {
        this.debug("<<INITIATE COMPILE>>");
        Object curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextSubToken()) {
                    case 0: {
                        curr = this.getBeanProperty(curr, this.capture());
                        break;
                    }
                    case 1: {
                        curr = this.getMethod(curr, this.capture());
                        break;
                    }
                    case 2: {
                        curr = this.getCollectionProperty(curr, this.capture());
                    }
                }
                this.first = false;
            }
            this.val = curr;
            this._finishJIT();
            return this._initializeAccessor();
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (PropertyAccessException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (OptimizationNotSupported e) {
            throw e;
        }
        catch (Exception e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
    }

    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Member member;
        this.debug("\n  **  ENTER -> {bean: " + property + "; ctx=" + ctx + "}");
        if (this.returnType != null && this.returnType.isPrimitive()) {
            this.wrapPrimitive(this.returnType);
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : (ctx != null ? ctx.getClass() : null);
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (this.first) {
            if (this.variableFactory != null && this.variableFactory.isResolveable(property)) {
                try {
                    this.debug("ALOAD 3");
                    this.mv.visitVarInsn(25, 3);
                    this.debug("LDC :" + property);
                    this.mv.visitLdcInsn(property);
                    this.debug("INVOKEINTERFACE org/mvel/integration/VariableResolverFactory.getVariableResolver");
                    this.mv.visitMethodInsn(185, "org/mvel/integration/VariableResolverFactory", "getVariableResolver", "(Ljava/lang/String;)Lorg/mvel/integration/VariableResolver;");
                    this.debug("INVOKEINTERFACE org/mvel/integration/VariableResolver.getValue");
                    this.mv.visitMethodInsn(185, "org/mvel/integration/VariableResolver", "getValue", "()Ljava/lang/Object;");
                    this.returnType = Object.class;
                }
                catch (Exception e) {
                    throw new OptimizationFailure("critical error in JIT", e);
                }
                return this.variableFactory.getVariableResolver(property).getValue();
            }
            this.mv.visitVarInsn(25, 1);
        }
        if (member instanceof Field) {
            Object o = ((Field)member).get(ctx);
            if (this.first) {
                this.debug("ALOAD 1 (A)");
                this.mv.visitVarInsn(25, 1);
            }
            if ((member.getModifiers() & 8) != 0) {
                this.debug("GETSTATIC " + Type.getDescriptor(member.getDeclaringClass()) + "." + member.getName() + "::" + Type.getDescriptor(((Field)member).getType()));
                this.returnType = ((Field)member).getType();
                this.mv.visitFieldInsn(178, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getDescriptor(this.returnType));
            } else {
                this.debug("CHECKCAST " + Type.getInternalName(cls));
                this.mv.visitTypeInsn(192, Type.getInternalName(cls));
                this.debug("GETFIELD " + property + ":" + Type.getDescriptor(((Field)member).getType()));
                this.returnType = ((Field)member).getType();
                this.mv.visitFieldInsn(180, Type.getInternalName(cls), property, Type.getDescriptor(this.returnType));
            }
            this.returnType = ((Field)member).getType();
            return o;
        }
        if (member != null) {
            Object o;
            if (this.first) {
                this.debug("ALOAD 1 (B)");
                this.mv.visitVarInsn(25, 1);
            }
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                if (this.returnType != member.getDeclaringClass()) {
                    this.debug("CHECKCAST " + Type.getInternalName(member.getDeclaringClass()));
                    this.mv.visitTypeInsn(192, Type.getInternalName(member.getDeclaringClass()));
                }
                this.returnType = ((Method)member).getReturnType();
                this.debug("INVOKEVIRTUAL " + member.getName() + ":" + this.returnType);
                this.mv.visitMethodInsn(182, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                this.debug("CHECKCAST " + Type.getInternalName(iFaceMeth.getDeclaringClass()));
                this.mv.visitTypeInsn(192, Type.getInternalName(iFaceMeth.getDeclaringClass()));
                this.returnType = iFaceMeth.getReturnType();
                this.debug("INVOKEINTERFACE " + member.getName() + ":" + this.returnType);
                this.mv.visitMethodInsn(185, Type.getInternalName(iFaceMeth.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            return o;
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            this.debug("CHECKCAST java/util/Map");
            this.mv.visitTypeInsn(192, "java/util/Map");
            this.debug("LDC: \"" + property + "\"");
            this.mv.visitLdcInsn(property);
            this.debug("INVOKEINTERFACE: get");
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(property);
        }
        if ("this".equals(property)) {
            this.debug("ALOAD 2");
            this.mv.visitVarInsn(25, 2);
            return this.thisRef;
        }
        if (LITERALS.containsKey(property)) {
            Object lit = LITERALS.get(property);
            if (lit instanceof Class) {
                this.ldcClassConstant((Class)lit);
            }
            return LITERALS.get(property);
        }
        Object ts = this.tryStaticAccess();
        if (ts != null) {
            if (ts instanceof Class) {
                this.ldcClassConstant((Class)ts);
                return ts;
            }
            this.debug("GETSTATIC " + Type.getDescriptor(((Field)ts).getDeclaringClass()) + "." + ((Field)ts).getName() + "::" + Type.getDescriptor(((Field)ts).getType()));
            this.returnType = ((Field)ts).getType();
            this.mv.visitFieldInsn(178, Type.getDescriptor(((Field)ts).getDeclaringClass()), ((Field)ts).getName(), Type.getDescriptor(this.returnType));
            return ((Field)ts).get(null);
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            for (Method m : c.getMethods()) {
                if (!property.equals(m.getName())) continue;
                this.ldcClassConstant(c);
                this.mv.visitMethodInsn(182, "java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;");
                this.mv.visitVarInsn(58, 7);
                this.mv.visitInsn(3);
                this.mv.visitVarInsn(54, 5);
                this.mv.visitVarInsn(25, 7);
                this.mv.visitInsn(190);
                this.mv.visitVarInsn(54, 6);
                Label l1 = new Label();
                this.mv.visitJumpInsn(167, l1);
                Label l2 = new Label();
                this.mv.visitLabel(l2);
                this.mv.visitVarInsn(25, 7);
                this.mv.visitVarInsn(21, 5);
                this.mv.visitInsn(50);
                this.mv.visitVarInsn(58, 4);
                Label l3 = new Label();
                this.mv.visitLabel(l3);
                this.mv.visitLdcInsn(m.getName());
                this.mv.visitVarInsn(25, 4);
                this.mv.visitMethodInsn(182, "java/lang/reflect/Method", "getName", "()Ljava/lang/String;");
                this.mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                Label l4 = new Label();
                this.mv.visitJumpInsn(153, l4);
                Label l5 = new Label();
                this.mv.visitLabel(l5);
                this.mv.visitVarInsn(25, 4);
                this.mv.visitInsn(176);
                this.mv.visitLabel(l4);
                this.mv.visitIincInsn(5, 1);
                this.mv.visitLabel(l1);
                this.mv.visitVarInsn(21, 5);
                this.mv.visitVarInsn(21, 6);
                this.mv.visitJumpInsn(161, l2);
                Label l6 = new Label();
                this.mv.visitLabel(l6);
                this.mv.visitInsn(1);
                this.mv.visitInsn(176);
                this.deferFinish = true;
                return m;
            }
        }
        throw new PropertyAccessException(property);
    }

    private Object getCollectionProperty(Object ctx, String prop) throws IllegalAccessException, InvocationTargetException {
        Object item;
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        this.debug("\n  **  ENTER -> {collections: " + prop + "; ctx=" + ctx + "}");
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new CompileException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            throw new CompileException("unterminated '['");
        }
        String tk = new String(this.expr, start, this.cursor - start);
        this.debug("{collection token:<<" + tk + ">>}");
        boolean literal = false;
        ExecutableStatement compiled = (ExecutableStatement)ParseTools.subCompileExpression(tk);
        if (compiled instanceof ExecutableLiteral) {
            literal = true;
            item = ((ExecutableLiteral)compiled).getLiteral();
        } else {
            item = compiled.getValue(ctx, this.variableFactory);
            this.compiledInputs.add(compiled);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            this.debug("CHECKCAST java/util/Map");
            this.mv.visitTypeInsn(192, "java/util/Map");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.wrapPrimitive(Integer.TYPE);
                this.debug("INVOKEINTERFACE: get");
                this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
                return ((Map)ctx).get(item);
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            this.debug("INVOKEINTERFACE: get");
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(item);
        }
        if (ctx instanceof List) {
            this.debug("CHECKCAST java/util/List");
            this.mv.visitTypeInsn(192, "java/util/List");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.debug("INVOKEINTERFACE: java/util/List.get");
                this.mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
                return ((List)ctx).get((Integer)item);
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            this.debug("INVOKEINTERFACE: java/util/List.get");
            this.mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            this.dataConversion(Integer.class);
            this.unwrapPrimitive(Integer.TYPE);
            return ((List)ctx).get(DataConversion.convert(item, Integer.class));
        }
        if (ctx instanceof Object[]) {
            this.debug("CHECKCAST [Ljava/lang/Object;");
            this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.debug("AALOAD");
                this.mv.visitInsn(50);
                return ((Object[])ctx)[(Integer)item];
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            this.dataConversion(Integer.class);
            this.unwrapPrimitive(Integer.TYPE);
            this.debug("AALOAD");
            this.mv.visitInsn(50);
            return ((Object[])ctx)[DataConversion.convert(item, Integer.class)];
        }
        if (ctx instanceof CharSequence) {
            this.debug("CHECKCAST java/lang/CharSequence");
            this.mv.visitTypeInsn(192, "java/lang/CharSequence");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt");
                this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
                this.wrapPrimitive(Character.TYPE);
                return Character.valueOf(((CharSequence)ctx).charAt((Integer)item));
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            this.dataConversion(Integer.class);
            this.unwrapPrimitive(Integer.TYPE);
            this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt");
            this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
            this.wrapPrimitive(Character.TYPE);
            return Character.valueOf(((CharSequence)ctx).charAt(DataConversion.convert(item, Integer.class)));
        }
        throw new CompileException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()));
    }

    private Object getMethod(Object ctx, String name) throws IllegalAccessException, InvocationTargetException {
        int i;
        ExecutableStatement[] es;
        Object[] preConvArgs;
        Object[] args;
        this.debug("\n  **  {method: " + name + "}");
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
            Object ptr = this.variableFactory.getVariableResolver(name).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name = ((MethodStub)ptr).getMethodName();
            } else {
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        } else if (this.returnType != null && this.returnType.isPrimitive()) {
            this.wrapPrimitive(this.returnType);
        }
        int st = this.cursor;
        this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(');
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = new Object[]{};
            preConvArgs = new Object[]{};
            es = null;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.length];
            args = new Object[subtokens.length];
            preConvArgs = new Object[es.length];
            for (i = 0; i < subtokens.length; ++i) {
                es[i] = (ExecutableStatement)ParseTools.subCompileExpression(subtokens[i]);
                preConvArgs[i] = args[i] = es[i].getValue(this.ctx, this.thisRef, this.variableFactory);
            }
        }
        int inputsOffset = this.compiledInputs.size();
        if (es != null) {
            for (i = 0; i < es.length; ++i) {
                ExecutableStatement e = es[i];
                if (e instanceof ExecutableLiteral) continue;
                if (e instanceof ExecutableAccessor && ((ExecutableAccessor)e).getNode() instanceof PropertyASTNode && ((PropertyASTNode)((ExecutableAccessor)e).getNode()).getWrappedNode() instanceof LiteralNode) {
                    es[i] = new ExecutableLiteral(((PropertyASTNode)((ExecutableAccessor)e).getNode()).getWrappedNode().getLiteralValue());
                    continue;
                }
                this.compiledInputs.add(e);
            }
        }
        if (this.first) {
            this.debug("ALOAD 1 (D) ");
            this.mv.visitVarInsn(25, 1);
        }
        Class<?> cls = ctx instanceof Class ? ctx : ctx.getClass();
        Class<?>[] parameterTypes = null;
        Method m = ParseTools.getBestCandidate(args, name, cls.getMethods());
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && (m = ParseTools.getBestCandidate(args, name, cls.getClass().getDeclaredMethods())) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            if (parameterTypes != null) {
                for (int i2 = 0; i2 < args.length; ++i2) {
                    errorBuild.append(parameterTypes[i2] != null ? parameterTypes[i2].getClass().getName() : null);
                    if (i2 >= args.length - 1) continue;
                    errorBuild.append(", ");
                }
            }
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                this.anyArrayCheck(cls);
                this.debug("ARRAYLENGTH");
                this.mv.visitInsn(190);
                this.wrapPrimitive(Integer.TYPE);
                return Array.getLength(ctx);
            }
            throw new CompileException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]");
        }
        m = ParseTools.getWidenedTarget(m);
        if (es != null) {
            for (int i3 = 0; i3 < es.length; ++i3) {
                ExecutableStatement cExpr = es[i3];
                if (cExpr.getKnownIngressType() == null) {
                    cExpr.setKnownIngressType(parameterTypes[i3]);
                    cExpr.computeTypeConversionRule();
                }
                if (cExpr.isConvertableIngressEgress()) continue;
                args[i3] = DataConversion.convert(args[i3], parameterTypes[i3]);
            }
        } else {
            for (int i4 = 0; i4 < args.length; ++i4) {
                args[i4] = DataConversion.convert(args[i4], parameterTypes[i4]);
            }
        }
        if (m.getParameterTypes().length == 0) {
            if ((m.getModifiers() & 8) != 0) {
                this.debug("INVOKESTATIC " + m.getName());
                this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
            } else {
                this.debug("CHECKCAST " + Type.getInternalName(m.getDeclaringClass()));
                this.mv.visitTypeInsn(192, Type.getInternalName(m.getDeclaringClass()));
                if (m.getDeclaringClass().isInterface()) {
                    this.debug("INVOKEINTERFACE " + m.getName());
                    this.mv.visitMethodInsn(185, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                } else {
                    this.debug("INVOKEVIRTUAL " + m.getName());
                    this.mv.visitMethodInsn(182, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                }
            }
            this.returnType = m.getReturnType();
            ++this.stacksize;
        } else {
            if ((m.getModifiers() & 8) == 0) {
                this.debug("CHECKCAST " + Type.getInternalName(cls));
                this.mv.visitTypeInsn(192, Type.getInternalName(cls));
            }
            for (int i5 = 0; i5 < es.length; ++i5) {
                if (es[i5] instanceof ExecutableLiteral) {
                    ExecutableLiteral literal = (ExecutableLiteral)es[i5];
                    if (literal.getLiteral() == null) {
                        this.debug("ICONST_NULL");
                        this.mv.visitInsn(1);
                        continue;
                    }
                    if (parameterTypes[i5] == Integer.TYPE && literal.intOptimized()) {
                        this.intPush(literal.getInteger32());
                        continue;
                    }
                    if (parameterTypes[i5] == Integer.TYPE && preConvArgs[i5] instanceof Integer) {
                        this.intPush((Integer)preConvArgs[i5]);
                        continue;
                    }
                    if (parameterTypes[i5] == Boolean.TYPE) {
                        boolean bool = DataConversion.convert(literal.getLiteral(), Boolean.class);
                        this.debug(bool ? "ICONST_1" : "ICONST_0");
                        this.mv.visitInsn(bool ? 4 : 3);
                        continue;
                    }
                    Object lit = literal.getLiteral();
                    if (parameterTypes[i5] == Object.class) {
                        if (ParseTools.isPrimitiveWrapper(lit.getClass())) {
                            if (lit.getClass() == Integer.class) {
                                this.intPush((Integer)lit);
                            } else {
                                this.debug("LDC " + lit);
                                this.mv.visitLdcInsn(lit);
                            }
                            this.wrapPrimitive(lit.getClass());
                            continue;
                        }
                        if (!(lit instanceof String)) continue;
                        this.mv.visitLdcInsn(lit);
                        this.checkcast(Object.class);
                        continue;
                    }
                    if (DataConversion.canConvert(parameterTypes[i5], lit.getClass())) {
                        this.debug("LDC " + lit + " (" + lit.getClass().getName() + ")");
                        this.mv.visitLdcInsn(DataConversion.convert(lit, parameterTypes[i5]));
                        continue;
                    }
                }
                this.debug("ALOAD 0");
                this.mv.visitVarInsn(25, 0);
                this.debug("GETFIELD p" + inputsOffset);
                this.mv.visitFieldInsn(180, this.className, "p" + inputsOffset, "Lorg/mvel/ExecutableStatement;");
                ++inputsOffset;
                this.debug("ALOAD 2");
                this.mv.visitVarInsn(25, 2);
                this.debug("ALOAD 3");
                this.mv.visitVarInsn(25, 3);
                this.debug("INVOKEINTERFACE ExecutableStatement.getValue");
                this.mv.visitMethodInsn(185, Type.getInternalName(ExecutableStatement.class), "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
                if (parameterTypes[i5].isPrimitive()) {
                    if (preConvArgs[i5] == null || parameterTypes[i5] != String.class && !parameterTypes[i5].isAssignableFrom(preConvArgs[i5].getClass())) {
                        this.ldcClassConstant(this.getWrapperClass(parameterTypes[i5]));
                        this.debug("INVOKESTATIC DataConversion.convert");
                        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                        this.unwrapPrimitive(parameterTypes[i5]);
                        continue;
                    }
                    this.unwrapPrimitive(parameterTypes[i5]);
                    continue;
                }
                if (preConvArgs[i5] == null || parameterTypes[i5] != String.class && !parameterTypes[i5].isAssignableFrom(preConvArgs[i5].getClass())) {
                    this.ldcClassConstant(parameterTypes[i5]);
                    this.debug("INVOKESTATIC DataConversion.convert");
                    this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                    this.debug("CHECKCAST " + Type.getInternalName(parameterTypes[i5]));
                    this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i5]));
                    continue;
                }
                if (parameterTypes[i5] == String.class) {
                    this.debug("<<<DYNAMIC TYPE OPTIMIZATION STRING>>");
                    this.mv.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
                    continue;
                }
                this.debug("<<<DYNAMIC TYPING BYPASS>>>");
                this.debug("<<<OPT. JUSTIFICATION " + parameterTypes[i5] + "=" + preConvArgs[i5].getClass() + ">>>");
                this.debug("CHECKCAST " + Type.getInternalName(parameterTypes[i5]));
                this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i5]));
            }
            if ((m.getModifiers() & 8) != 0) {
                this.debug("INVOKESTATIC: " + m.getName());
                this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
            } else if (m.getDeclaringClass() != cls && m.getDeclaringClass().isInterface()) {
                this.debug("INVOKEINTERFACE: " + Type.getInternalName(m.getDeclaringClass()) + "." + m.getName());
                this.mv.visitMethodInsn(185, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
            } else {
                this.debug("INVOKEVIRTUAL: " + Type.getInternalName(cls) + "." + m.getName());
                this.mv.visitMethodInsn(182, Type.getInternalName(cls), m.getName(), Type.getMethodDescriptor(m));
            }
            this.returnType = m.getReturnType();
            ++this.stacksize;
        }
        return m.invoke(ctx, args);
    }

    private void valueFromSubExpression() {
        this.debug("ALOAD 0");
        this.mv.visitVarInsn(25, 0);
        this.debug("GETFIELD p" + (this.compiledInputs.size() - 1));
        this.mv.visitFieldInsn(180, this.className, "p" + (this.compiledInputs.size() - 1), "Lorg/mvel/ExecutableStatement;");
        this.debug("ALOAD 1");
        this.mv.visitVarInsn(25, 1);
        this.debug("ALOAD 3");
        this.mv.visitVarInsn(25, 3);
        this.debug("INVOKEINTERFACE org/mvel/ExecutableStatement.getValue");
        this.mv.visitMethodInsn(185, "org/mvel/ExecutableStatement", "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
    }

    private void dataConversion(Class target) {
        this.ldcClassConstant(target);
        this.debug("INVOKESTATIC org/mvel/DataConversion.convert");
        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class loadClass(String className, byte[] b) throws Exception {
        Method method = defineClass;
        synchronized (method) {
            defineClass.setAccessible(true);
            try {
                Class clazz = (Class)defineClass.invoke((Object)classLoader, className, b, 0, b.length);
                return clazz;
            }
            catch (Exception t) {
                this.dumpAdvancedDebugging();
                throw t;
            }
            finally {
                defineClass.setAccessible(false);
            }
        }
    }

    private void debug(String instruction) {
        if (this.buildLog != null) {
            this.buildLog.append(instruction).append("\n");
        }
    }

    public String getName() {
        return "ASM";
    }

    @Override
    public Object getResultOptPass() {
        return this.val;
    }

    private Class getWrapperClass(Class cls) {
        if (cls == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cls == Integer.TYPE) {
            return Integer.class;
        }
        if (cls == Float.TYPE) {
            return Float.class;
        }
        if (cls == Double.TYPE) {
            return Double.class;
        }
        if (cls == Short.TYPE) {
            return Short.class;
        }
        if (cls == Long.TYPE) {
            return Long.class;
        }
        if (cls == Byte.TYPE) {
            return Byte.class;
        }
        if (cls == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    private void unwrapPrimitive(Class cls) {
        if (cls == Boolean.TYPE) {
            this.debug("CHECKCAST java/lang/Boolean");
            this.mv.visitTypeInsn(192, "java/lang/Boolean");
            this.debug("INVOKEVIRTUAL java/lang/Boolean.booleanValue");
            this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (cls == Integer.TYPE) {
            this.debug("CHECKCAST java/lang/Integer");
            this.mv.visitTypeInsn(192, "java/lang/Integer");
            this.debug("INVOKEVIRTUAL java/lang/Integer.intValue");
            this.mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (cls == Float.TYPE) {
            this.debug("CHECKCAST java/lang/Float");
            this.mv.visitTypeInsn(192, "java/lang/Float");
            this.debug("INVOKEVIRTUAL java/lang/Float.floatValue");
            this.mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (cls == Double.TYPE) {
            this.debug("CHECKCAST java/lang/Double");
            this.mv.visitTypeInsn(192, "java/lang/Double");
            this.debug("INVOKEVIRTUAL java/lang/Double.doubleValue");
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else if (cls == Short.TYPE) {
            this.debug("CHECKCAST java/lang/Short");
            this.mv.visitTypeInsn(192, "java/lang/Short");
            this.debug("INVOKEVIRTUAL java/lang/Short.shortValue");
            this.mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (cls == Long.TYPE) {
            this.debug("CHECKCAST java/lang/Long");
            this.mv.visitTypeInsn(192, "java/lang/Long");
            this.debug("INVOKEVIRTUAL java/lang/Long.longValue");
            this.mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (cls == Byte.TYPE) {
            this.debug("CHECKCAST java/lang/Byte");
            this.mv.visitTypeInsn(192, "java/lang/Byte");
            this.debug("INVOKEVIRTUAL java/lang/Byte.byteValue");
            this.mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (cls == Character.TYPE) {
            this.debug("CHECKCAST java/lang/Character");
            this.mv.visitTypeInsn(192, "java/lang/Character");
            this.debug("INVOKEVIRTUAL java/lang/Character.charValue");
            this.mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        }
    }

    private void wrapPrimitive(Class<? extends Object> cls) {
        if (OPCODES_VERSION == 48) {
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                this.debug("NEW java/lang/Boolean");
                this.mv.visitTypeInsn(187, "java/lang/Boolean");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Boolan.<init>::(Z)V");
                this.mv.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                this.returnType = Boolean.class;
            } else if (cls == Integer.TYPE || cls == Integer.class) {
                this.debug("NEW java/lang/Integer");
                this.mv.visitTypeInsn(187, "java/lang/Integer");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Integer.<init>::(I)V");
                this.mv.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                this.returnType = Integer.class;
            } else if (cls == Float.TYPE || cls == Float.class) {
                this.debug("NEW java/lang/Float");
                this.mv.visitTypeInsn(187, "java/lang/Float");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Float.<init>::(F)V");
                this.mv.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                this.returnType = Float.class;
            } else if (cls == Double.TYPE || cls == Double.class) {
                this.debug("NEW java/lang/Double");
                this.mv.visitTypeInsn(187, "java/lang/Double");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Double.<init>::(D)V");
                this.mv.visitMethodInsn(183, "java/lang/Doble", "<init>", "(D)V");
                this.returnType = Double.class;
            } else if (cls == Short.TYPE || cls == Short.class) {
                this.debug("NEW java/lang/Short");
                this.mv.visitTypeInsn(187, "java/lang/Short");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Short.<init>::(S)V");
                this.mv.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                this.returnType = Short.class;
            } else if (cls == Long.TYPE || cls == Long.class) {
                this.debug("NEW java/lang/Long");
                this.mv.visitTypeInsn(187, "java/lang/Long");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Long.<init>::(L)V");
                this.mv.visitMethodInsn(183, "java/lang/Float", "<init>", "(L)V");
                this.returnType = Long.class;
            } else if (cls == Byte.TYPE || cls == Byte.class) {
                this.debug("NEW java/lang/Byte");
                this.mv.visitTypeInsn(187, "java/lang/Byte");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Byte.<init>::(B)V");
                this.mv.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                this.returnType = Byte.class;
            } else if (cls == Character.TYPE || cls == Character.class) {
                this.debug("NEW java/lang/Character");
                this.mv.visitTypeInsn(187, "java/lang/Character");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Character.<init>::(C)V");
                this.mv.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                this.returnType = Character.class;
            }
        } else if (cls == Boolean.TYPE || cls == Boolean.class) {
            this.debug("INVOKESTATIC java/lang/Boolean.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            this.returnType = Boolean.class;
        } else if (cls == Integer.TYPE || cls == Integer.class) {
            this.debug("INVOKESTATIC java/lang/Integer.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            this.returnType = Integer.class;
        } else if (cls == Float.TYPE || cls == Float.class) {
            this.debug("INVOKESTATIC java/lang/Float.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            this.returnType = Float.class;
        } else if (cls == Double.TYPE || cls == Double.class) {
            this.debug("INVOKESTATIC java/lang/Double.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            this.returnType = Double.class;
        } else if (cls == Short.TYPE || cls == Short.class) {
            this.debug("INVOKESTATIC java/lang/Short.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            this.returnType = Short.class;
        } else if (cls == Long.TYPE || cls == Long.class) {
            this.debug("INVOKESTATIC java/lang/Long.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            this.returnType = Long.class;
        } else if (cls == Byte.TYPE || cls == Byte.class) {
            this.debug("INVOKESTATIC java/lang/Byte.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            this.returnType = Byte.class;
        } else if (cls == Character.TYPE || cls == Character.class) {
            this.debug("INVOKESTATIC java/lang/Character.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            this.returnType = Character.class;
        }
    }

    private void anyArrayCheck(Class<? extends Object> cls) {
        if (cls == boolean[].class) {
            this.debug("CHECKCAST [Z");
            this.mv.visitTypeInsn(192, "[Z");
        } else if (cls == int[].class) {
            this.debug("CHECKCAST [I");
            this.mv.visitTypeInsn(192, "[I");
        } else if (cls == float[].class) {
            this.debug("CHECKCAST [F");
            this.mv.visitTypeInsn(192, "[F");
        } else if (cls == double[].class) {
            this.debug("CHECKCAST [D");
            this.mv.visitTypeInsn(192, "[D");
        } else if (cls == short[].class) {
            this.debug("CHECKCAST [S");
            this.mv.visitTypeInsn(192, "[S");
        } else if (cls == long[].class) {
            this.debug("CHECKCAST [J");
            this.mv.visitTypeInsn(192, "[J");
        } else if (cls == byte[].class) {
            this.debug("CHECKCAST [B");
            this.mv.visitTypeInsn(192, "[B");
        } else if (cls == char[].class) {
            this.debug("CHECKCAST [C");
            this.mv.visitTypeInsn(192, "[C");
        } else {
            this.debug("CHECKCAST [Ljava/lang/Object;");
            this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
        }
    }

    private void writeOutLiteralWrapped(Object lit) {
        if (lit instanceof Integer) {
            this.intPush((Integer)lit);
            this.wrapPrimitive(Integer.TYPE);
            return;
        }
        this.debug("LDC " + lit);
        if (lit instanceof String) {
            this.mv.visitLdcInsn(lit);
        } else if (lit instanceof Long) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Long.TYPE);
        } else if (lit instanceof Float) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Float.TYPE);
        } else if (lit instanceof Double) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Double.TYPE);
        } else if (lit instanceof Short) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Short.TYPE);
        } else if (lit instanceof Character) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Character.TYPE);
        } else if (lit instanceof Boolean) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Boolean.TYPE);
        } else if (lit instanceof Byte) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Byte.TYPE);
        }
    }

    private void ldcClassConstant(Class cls) {
        if (OPCODES_VERSION == 48) {
            this.debug("LDC \"" + cls.getName() + "\"");
            this.mv.visitLdcInsn(cls.getName());
            this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            Label l4 = new Label();
            this.mv.visitJumpInsn(167, l4);
            this.mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
            this.mv.visitInsn(90);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, "java/lang/Throwable", "getMessage", "()Ljava/lang/String;");
            this.mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
            this.mv.visitInsn(191);
            this.mv.visitLabel(l4);
        } else {
            this.debug("LDC " + Type.getType(cls));
            this.mv.visitLdcInsn(Type.getType(cls));
        }
    }

    private void buildInputs() {
        if (this.compiledInputs.size() == 0) {
            return;
        }
        this.debug("\n{SETTING UP MEMBERS...}\n");
        StringAppender constSig = new StringAppender("(");
        int size = this.compiledInputs.size();
        for (int i = 0; i < size; ++i) {
            this.debug("ACC_PRIVATE p" + i);
            FieldVisitor fv = this.cw.visitField(2, "p" + i, "Lorg/mvel/ExecutableStatement;", null, null);
            fv.visitEnd();
            constSig.append("Lorg/mvel/ExecutableStatement;");
        }
        constSig.append(")V");
        this.debug("\n{CREATING INJECTION CONSTRUCTOR}\n");
        MethodVisitor cv = this.cw.visitMethod(1, "<init>", constSig.toString(), null, null);
        cv.visitCode();
        this.debug("ALOAD 0");
        cv.visitVarInsn(25, 0);
        this.debug("INVOKESPECIAL java/lang/Object.<init>");
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        for (int i = 0; i < size; ++i) {
            this.debug("ALOAD 0");
            cv.visitVarInsn(25, 0);
            this.debug("ALOAD " + (i + 1));
            cv.visitVarInsn(25, i + 1);
            this.debug("PUTFIELD p" + i);
            cv.visitFieldInsn(181, this.className, "p" + i, "Lorg/mvel/ExecutableStatement;");
        }
        this.debug("RETURN");
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
        cv.visitEnd();
        this.debug("}");
    }

    private int _getAccessor(Object o, int type, int register, int index) {
        if (o instanceof List) {
            this.debug("NEW org/mvel/util/FastList");
            this.mv.visitTypeInsn(187, LIST_IMPL);
            this.debug("DUP");
            this.mv.visitInsn(89);
            this.intPush(((List)o).size());
            this.debug("INVOKESPECIAL org/mvel/util/FastList.<init>");
            this.mv.visitMethodInsn(183, LIST_IMPL, "<init>", "(I)V");
            this.debug("ASTORE " + (this.cnum + 1));
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            for (Object item : (List)o) {
                if (this._getAccessor(item, 1, c, 0) != 3) {
                    this.debug("ALOAD " + c);
                    this.mv.visitVarInsn(25, c);
                    this.debug("ALOAD " + this.lastCnum);
                    this.mv.visitVarInsn(25, this.lastCnum);
                }
                this.debug("INVOKEINTERFACE java/util/List.add");
                this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                this.debug("POP");
                this.mv.visitInsn(87);
            }
            this.lastCnum = c;
            return 1;
        }
        if (o instanceof Map) {
            this.debug("NEW java/util/HashMap");
            this.mv.visitTypeInsn(187, MAP_IMPL);
            this.debug("DUP");
            this.mv.visitInsn(89);
            this.intPush(((Map)o).size());
            this.debug("INVOKESPECIAL java/util/HashMap.<init>");
            this.mv.visitMethodInsn(183, MAP_IMPL, "<init>", "(I)V");
            this.debug("ASTORE " + (this.cnum + 1));
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            for (Object item : ((Map)o).keySet()) {
                this._getAccessor(item, 2, c, 0);
                int firstParm = this.lastCnum;
                this._getAccessor(((Map)o).get(item), 2, c, 0);
                this.debug("ALOAD " + c);
                this.mv.visitVarInsn(25, c);
                this.debug("ALOAD " + firstParm + " (" + ((Map)o).get(item) + ")");
                this.mv.visitVarInsn(25, firstParm);
                this.debug("ALOAD " + this.lastCnum + " (" + item + ")");
                this.mv.visitVarInsn(25, this.lastCnum);
                this.debug("INVOKEINTERFACE java/util/Map.put");
                this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.debug("POP");
                this.mv.visitInsn(87);
            }
            this.lastCnum = c;
            return 2;
        }
        if (o instanceof Object[]) {
            this.intPush(((Object[])o).length);
            this.debug("ANEWARRAY (" + o.hashCode() + ")");
            this.mv.visitTypeInsn(189, "java/lang/Object");
            this.debug("ASTORE " + (this.cnum + 1));
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            int i = 0;
            for (Object item : (Object[])o) {
                if (this._getAccessor(item, 0, c, i) != 3) {
                    this.debug("ALOAD " + c);
                    this.mv.visitVarInsn(25, c);
                    this.intPush(i);
                    this.debug("ALOAD + " + this.lastCnum);
                    this.mv.visitVarInsn(25, this.lastCnum);
                }
                this.debug("AASTORE (" + o.hashCode() + ")");
                this.mv.visitInsn(83);
                ++i;
            }
            this.lastCnum = c;
            return 0;
        }
        this.compiledInputs.add((ExecutableStatement)ParseTools.subCompileExpression((String)o));
        switch (type) {
            case 0: {
                this.debug("ALOAD " + register);
                this.mv.visitVarInsn(25, register);
                this.intPush(index);
                break;
            }
            case 1: {
                this.debug("ALOAD " + register);
                this.mv.visitVarInsn(25, register);
            }
        }
        this.debug("ALOAD 0");
        this.mv.visitVarInsn(25, 0);
        this.debug("GETFIELD p" + (this.compiledInputs.size() - 1));
        this.mv.visitFieldInsn(180, this.className, "p" + (this.compiledInputs.size() - 1), "Lorg/mvel/ExecutableStatement;");
        this.debug("ALOAD 2");
        this.mv.visitVarInsn(25, 2);
        this.debug("ALOAD 3");
        this.mv.visitVarInsn(25, 3);
        this.debug("INVOKEINTERFACE ExecutableStatement.getValue");
        this.mv.visitMethodInsn(185, Type.getInternalName(ExecutableStatement.class), "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
        switch (type) {
            case 2: {
                this.debug("ASTORE " + (this.cnum + 1) + "(" + o + ")");
                this.lastCnum = ++this.cnum;
                this.mv.visitVarInsn(58, this.cnum);
            }
        }
        return 3;
    }

    @Override
    public Accessor optimizeCollection(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.cursor = 0;
        this.expr = property;
        this.length = property.length;
        this.compiledInputs = new ArrayList();
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        CollectionParser parser = new CollectionParser();
        Object o = ((List)parser.parseCollection(property)).get(0);
        this._initJIT();
        this._getAccessor(o, 1, 0, 0);
        this.debug("ALOAD 4");
        this.mv.visitVarInsn(25, 4);
        this._finishJIT();
        int end = parser.getCursor() + 2;
        try {
            Accessor compiledAccessor = this._initializeAccessor();
            if (end < property.length) {
                return new Union(compiledAccessor, ParseTools.subset(property, end));
            }
            return compiledAccessor;
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not optimize collection", e);
        }
    }

    private void checkcast(Class cls) {
        this.mv.visitTypeInsn(192, Type.getInternalName(cls));
    }

    private void intPush(int index) {
        if (index < 6) {
            switch (index) {
                case 0: {
                    this.debug("ICONST_0");
                    this.mv.visitInsn(3);
                    break;
                }
                case 1: {
                    this.debug("ICONST_1");
                    this.mv.visitInsn(4);
                    break;
                }
                case 2: {
                    this.debug("ICONST_2");
                    this.mv.visitInsn(5);
                    break;
                }
                case 3: {
                    this.debug("ICONST_3");
                    this.mv.visitInsn(6);
                    break;
                }
                case 4: {
                    this.debug("ICONST_4");
                    this.mv.visitInsn(7);
                    break;
                }
                case 5: {
                    this.debug("ICONST_5");
                    this.mv.visitInsn(8);
                }
            }
        } else {
            this.debug("BIPUSH " + index);
            this.mv.visitIntInsn(16, index);
        }
    }

    @Override
    public Accessor optimizeObjectCreation(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this._initJIT();
        this.compiledInputs = new ArrayList();
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        String[] cnsRes = ParseTools.captureContructorAndResidual(property);
        String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        try {
            if (constructorParms != null) {
                for (String constructorParm : constructorParms) {
                    this.compiledInputs.add((ExecutableStatement)ParseTools.subCompileExpression(constructorParm));
                }
                String s = new String(ParseTools.subset(property, 0, ArrayTools.findFirst('(', property)));
                Class cls = ParseTools.findClass(factory, s);
                this.debug("NEW " + Type.getInternalName(cls));
                this.mv.visitTypeInsn(187, Type.getInternalName(cls));
                this.debug("DUP");
                this.mv.visitInsn(89);
                Object[] parms = new Object[constructorParms.length];
                int i = 0;
                for (ExecutableStatement es : this.compiledInputs) {
                    parms[i++] = es.getValue(ctx, factory);
                }
                Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
                if (cns == null) {
                    throw new CompileException("unable to find constructor for: " + cls.getName());
                }
                for (i = 0; i < constructorParms.length; ++i) {
                    Class tg;
                    this.debug("ALOAD 0");
                    this.mv.visitVarInsn(25, 0);
                    this.debug("GETFIELD p" + i);
                    this.mv.visitFieldInsn(180, this.className, "p" + i, "Lorg/mvel/ExecutableStatement;");
                    this.debug("ALOAD 2");
                    this.mv.visitVarInsn(25, 2);
                    this.debug("ALOAD 3");
                    this.mv.visitVarInsn(25, 3);
                    this.debug("INVOKEINTERFACE org/mvel/ExecutableStatement.getValue");
                    this.mv.visitMethodInsn(185, "org/mvel/ExecutableStatement", "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
                    Class clazz = tg = cns.getParameterTypes()[i].isPrimitive() ? this.getWrapperClass(cns.getParameterTypes()[i]) : cns.getParameterTypes()[i];
                    if (!parms[i].getClass().isAssignableFrom(cns.getParameterTypes()[i])) {
                        this.ldcClassConstant(tg);
                        this.debug("INVOKESTATIC org/mvel/DataConversion.convert");
                        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                        if (cns.getParameterTypes()[i].isPrimitive()) {
                            this.unwrapPrimitive(cns.getParameterTypes()[i]);
                            continue;
                        }
                        this.debug("CHECKCAST " + Type.getInternalName(tg));
                        this.mv.visitTypeInsn(192, Type.getInternalName(tg));
                        continue;
                    }
                    this.debug("CHECKCAST " + Type.getInternalName(cns.getParameterTypes()[i]));
                    this.mv.visitTypeInsn(192, Type.getInternalName(cns.getParameterTypes()[i]));
                }
                this.debug("INVOKESPECIAL " + Type.getInternalName(cls) + ".<init> : " + Type.getConstructorDescriptor(cns));
                this.mv.visitMethodInsn(183, Type.getInternalName(cls), "<init>", Type.getConstructorDescriptor(cns));
                this._finishJIT();
                Accessor acc = this._initializeAccessor();
                if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                    return new Union(acc, cnsRes[1].toCharArray());
                }
                return acc;
            }
            Class cls = ParseTools.findClass(factory, new String(property));
            this.debug("NEW " + Type.getInternalName(cls));
            this.mv.visitTypeInsn(187, Type.getInternalName(cls));
            this.debug("DUP");
            this.mv.visitInsn(89);
            Constructor cns = cls.getConstructor(EMPTYCLS);
            this.debug("INVOKESPECIAL <init>");
            this.mv.visitMethodInsn(183, Type.getInternalName(cls), "<init>", Type.getConstructorDescriptor(cns));
            this._finishJIT();
            Accessor acc = this._initializeAccessor();
            if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                return new Union(acc, cnsRes[1].toCharArray());
            }
            return acc;
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("class or class reference not found: " + new String(property));
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not optimize construtor: " + new String(property), e);
        }
    }

    @Override
    public Accessor optimizeFold(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        throw new OptimizationNotSupported("JIT does not yet support fold operations.");
    }

    @Override
    public Class getEgressType() {
        return this.returnType;
    }

    private void dumpAdvancedDebugging() {
        if (this.buildLog == null) {
            return;
        }
        System.out.println("JIT Compiler Dump for: <<" + new String(this.expr) + ">>\n-------------------------------\n");
        System.out.println(this.buildLog.toString());
        System.out.println("\n<END OF DUMP>\n");
        if (MVEL.isFileDebugging()) {
            try {
                FileWriter writer = ParseTools.getDebugFileWriter();
                writer.write(this.buildLog.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        String javaVersion = System.getProperty("java.version");
        OPCODES_VERSION = javaVersion.startsWith("1.4") ? 48 : (javaVersion.startsWith("1.5") ? 49 : (javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7") ? 50 : 46));
        EMPTYARG = new Object[0];
        EMPTYCLS = new Class[0];
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

