/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.CompileException;
import org.mvel.ConversionException;
import org.mvel.DataConversion;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.PropertyAccessException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.MethodStub;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

public class PropertyAccessor {
    private int start = 0;
    private int cursor = 0;
    private char[] property;
    private int length;
    private Object thisReference;
    private Object ctx;
    private Object curr;
    private boolean first = true;
    private VariableResolverFactory variableFactory;
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private static final Object[] EMPTYARG = new Object[0];
    private static Map<Class, Map<Integer, Member>> READ_PROPERTY_RESOLVER_CACHE;
    private static Map<Class, Map<Integer, Member>> WRITE_PROPERTY_RESOLVER_CACHE;
    private static Map<Class, Map<Integer, Object[]>> METHOD_RESOLVER_CACHE;

    static void configureFactory() {
        if (MVEL.THREAD_SAFE) {
            READ_PROPERTY_RESOLVER_CACHE = Collections.synchronizedMap(new WeakHashMap(10));
            WRITE_PROPERTY_RESOLVER_CACHE = Collections.synchronizedMap(new WeakHashMap(10));
            METHOD_RESOLVER_CACHE = Collections.synchronizedMap(new WeakHashMap(10));
        } else {
            READ_PROPERTY_RESOLVER_CACHE = new WeakHashMap<Class, Map<Integer, Member>>(10);
            WRITE_PROPERTY_RESOLVER_CACHE = new WeakHashMap<Class, Map<Integer, Member>>(10);
            METHOD_RESOLVER_CACHE = new WeakHashMap<Class, Map<Integer, Object[]>>(10);
        }
    }

    public PropertyAccessor(char[] property, Object ctx) {
        this.property = property;
        this.length = property.length;
        this.ctx = ctx;
    }

    public PropertyAccessor(char[] property, Object ctx, VariableResolverFactory resolver, Object thisReference) {
        this.property = property;
        this.length = property.length;
        this.ctx = ctx;
        this.variableFactory = resolver;
        this.thisReference = thisReference;
    }

    public PropertyAccessor(char[] property, Object ctx, Object thisRef, VariableResolverFactory resolver, Object thisReference) {
        this.property = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisReference = thisRef;
        this.variableFactory = resolver;
        this.thisReference = thisReference;
    }

    public PropertyAccessor(VariableResolverFactory resolver, Object thisReference) {
        this.variableFactory = resolver;
        this.thisReference = thisReference;
    }

    public PropertyAccessor(char[] property, int offset, int end, Object ctx, VariableResolverFactory resolver) {
        this.property = property;
        this.cursor = offset;
        this.length = end;
        this.ctx = ctx;
        this.variableFactory = resolver;
    }

    public PropertyAccessor(String property, Object ctx) {
        this.property = property.toCharArray();
        this.length = this.property.length;
        this.ctx = ctx;
    }

    public static Object get(String property, Object ctx) {
        return new PropertyAccessor(property, ctx).get();
    }

    public static Object get(char[] property, Object ctx, VariableResolverFactory resolver, Object thisReference) {
        return new PropertyAccessor(property, ctx, resolver, thisReference).get();
    }

    public static Object get(char[] property, int offset, int end, Object ctx, VariableResolverFactory resolver) {
        return new PropertyAccessor(property, offset, end, ctx, resolver).get();
    }

    public static Object get(String property, Object ctx, VariableResolverFactory resolver, Object thisReference) {
        return new PropertyAccessor(property.toCharArray(), ctx, resolver, thisReference).get();
    }

    public static void set(Object ctx, String property, Object value) {
        new PropertyAccessor(property, ctx).set(value);
    }

    public static void set(Object ctx, VariableResolverFactory resolver, String property, Object value) {
        new PropertyAccessor(property.toCharArray(), ctx, resolver, null).set(value);
    }

    private Object get() {
        this.curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextToken()) {
                    case 0: {
                        this.curr = this.getBeanProperty(this.curr, this.capture());
                        break;
                    }
                    case 1: {
                        this.curr = this.getMethod(this.curr, this.capture());
                        break;
                    }
                    case 2: {
                        this.curr = this.getCollectionProperty(this.curr, this.capture());
                        break;
                    }
                }
                this.first = false;
            }
            return this.curr;
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException("array or collections index out of bounds (property: " + new String(this.property) + ")", e);
        }
        catch (PropertyAccessException e) {
            throw new PropertyAccessException("failed to access property: <<" + new String(this.property) + ">> in: " + (this.ctx != null ? this.ctx.getClass() : null), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException("null pointer exception in property: " + new String(this.property), e);
        }
        catch (Exception e) {
            throw new PropertyAccessException("unknown exception in expression: " + new String(this.property), e);
        }
    }

    private void set(Object value) {
        block23: {
            this.curr = this.ctx;
            try {
                int oLength = this.length;
                this.length = PropertyTools.findAbsoluteLast(this.property);
                this.curr = this.get();
                if (this.curr == null) {
                    throw new PropertyAccessException("cannot bind to null context: " + new String(this.property));
                }
                this.length = oLength;
                if (this.nextToken() == 2) {
                    int start = ++this.cursor;
                    this.whiteSpaceSkip();
                    if (this.cursor == this.length) {
                        throw new PropertyAccessException("unterminated '['");
                    }
                    if (!this.scanTo(']')) {
                        throw new PropertyAccessException("unterminated '['");
                    }
                    String ex = new String(this.property, start, this.cursor - start);
                    if (this.curr instanceof Map) {
                        ((Map)this.curr).put(MVEL.eval(ex, this.ctx, this.variableFactory), value);
                    } else if (this.curr instanceof List) {
                        ((List)this.curr).set(MVEL.eval(ex, this.ctx, this.variableFactory, Integer.class), value);
                    } else if (this.curr instanceof Object[]) {
                        ((Object[])this.curr)[MVEL.eval((String)ex, (Object)this.ctx, (VariableResolverFactory)this.variableFactory, Integer.class).intValue()] = DataConversion.convert(value, this.ctx.getClass().getComponentType());
                    } else {
                        throw new PropertyAccessException("cannot bind to collection property: " + new String(this.property) + ": not a recognized collection type: " + this.ctx.getClass());
                    }
                    return;
                }
                String tk = this.capture();
                Member member = PropertyAccessor.checkWriteCache(this.curr.getClass(), tk == null ? 0 : tk.hashCode());
                if (member == null) {
                    member = PropertyTools.getFieldOrWriteAccessor(this.curr.getClass(), tk);
                    PropertyAccessor.addWriteCache(this.curr.getClass(), tk == null ? 0 : tk.hashCode(), member);
                }
                if (member instanceof Field) {
                    Field fld = (Field)member;
                    if (value != null && !fld.getType().isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(fld.getType(), value.getClass())) {
                            throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + fld.getType());
                        }
                        fld.set(this.curr, DataConversion.convert(value, fld.getType()));
                    } else {
                        fld.set(this.curr, value);
                    }
                    break block23;
                }
                if (member != null) {
                    Method meth = (Method)member;
                    if (value != null && !meth.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(meth.getParameterTypes()[0], value.getClass())) {
                            throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + meth.getParameterTypes()[0]);
                        }
                        meth.invoke(this.curr, DataConversion.convert(value, meth.getParameterTypes()[0]));
                    } else {
                        meth.invoke(this.curr, value);
                    }
                    break block23;
                }
                if (this.curr instanceof Map) {
                    ((Map)this.curr).put(MVEL.eval(tk, this.ctx, this.variableFactory), value);
                    break block23;
                }
                throw new PropertyAccessException("could not access property (" + tk + ") in: " + this.ctx.getClass().getName());
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException("could not access property", e);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException("could not access property", e);
            }
        }
    }

    private int nextToken() {
        this.start = this.cursor;
        switch (this.property[this.start]) {
            case '[': {
                return 2;
            }
            case '.': {
                this.cursor = ++this.start;
            }
        }
        while (++this.cursor < this.length && Character.isJavaIdentifierPart(this.property[this.cursor])) {
        }
        if (this.cursor < this.length) {
            while (Character.isWhitespace(this.property[this.cursor])) {
                ++this.cursor;
            }
            switch (this.property[this.cursor]) {
                case '[': {
                    return 2;
                }
                case '(': {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    private String capture() {
        return new String(this.property, this.start, this.trimLeft(this.cursor) - this.start);
    }

    protected int trimLeft(int pos) {
        while (pos > 0 && Character.isWhitespace(this.property[pos - 1])) {
            --pos;
        }
        return pos;
    }

    public static void clearPropertyResolverCache() {
        READ_PROPERTY_RESOLVER_CACHE.clear();
        WRITE_PROPERTY_RESOLVER_CACHE.clear();
        METHOD_RESOLVER_CACHE.clear();
    }

    public static void reportCacheSizes() {
        System.out.println("read property cache: " + READ_PROPERTY_RESOLVER_CACHE.size());
        for (Class cls : READ_PROPERTY_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + READ_PROPERTY_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
        System.out.println("write property cache: " + WRITE_PROPERTY_RESOLVER_CACHE.size());
        for (Class cls : WRITE_PROPERTY_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + WRITE_PROPERTY_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
        System.out.println("method cache: " + METHOD_RESOLVER_CACHE.size());
        for (Class cls : METHOD_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + METHOD_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
    }

    private static void addReadCache(Class cls, Integer property, Member member) {
        if (!READ_PROPERTY_RESOLVER_CACHE.containsKey(cls)) {
            READ_PROPERTY_RESOLVER_CACHE.put(cls, new WeakHashMap());
        }
        READ_PROPERTY_RESOLVER_CACHE.get(cls).put(property, member);
    }

    private static Member checkReadCache(Class cls, Integer property) {
        if (READ_PROPERTY_RESOLVER_CACHE.containsKey(cls)) {
            return READ_PROPERTY_RESOLVER_CACHE.get(cls).get(property);
        }
        return null;
    }

    private static void addWriteCache(Class cls, Integer property, Member member) {
        if (!WRITE_PROPERTY_RESOLVER_CACHE.containsKey(cls)) {
            WRITE_PROPERTY_RESOLVER_CACHE.put(cls, new WeakHashMap());
        }
        WRITE_PROPERTY_RESOLVER_CACHE.get(cls).put(property, member);
    }

    private static Member checkWriteCache(Class cls, Integer property) {
        if (WRITE_PROPERTY_RESOLVER_CACHE.containsKey(cls)) {
            return WRITE_PROPERTY_RESOLVER_CACHE.get(cls).get(property);
        }
        return null;
    }

    private static void addMethodCache(Class cls, Integer property, Method member) {
        if (!METHOD_RESOLVER_CACHE.containsKey(cls)) {
            METHOD_RESOLVER_CACHE.put(cls, new WeakHashMap());
        }
        METHOD_RESOLVER_CACHE.get(cls).put(property, new Object[]{member, member.getParameterTypes()});
    }

    private static Object[] checkMethodCache(Class cls, Integer property) {
        if (METHOD_RESOLVER_CACHE.containsKey(cls)) {
            return METHOD_RESOLVER_CACHE.get(cls).get(property);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(property)) {
            return this.variableFactory.getVariableResolver(property).getValue();
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : ctx.getClass();
        Member member = PropertyAccessor.checkReadCache(cls, property.hashCode());
        if (member == null) {
            member = PropertyTools.getFieldOrAccessor(cls, property);
            PropertyAccessor.addReadCache(cls, property.hashCode(), member);
        }
        if (member instanceof Field) {
            return ((Field)member).get(ctx);
        }
        if (member != null) {
            try {
                return ((Method)member).invoke(ctx, EMPTYARG);
            }
            catch (IllegalAccessException e) {
                Member member2 = member;
                synchronized (member2) {
                    Object object;
                    try {
                        ((Method)member).setAccessible(true);
                        object = ((Method)member).invoke(ctx, EMPTYARG);
                        ((Method)member).setAccessible(false);
                    }
                    catch (Throwable throwable) {
                        ((Method)member).setAccessible(false);
                        throw throwable;
                    }
                    return object;
                }
            }
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            return ((Map)ctx).get(property);
        }
        if ("this".equals(property)) {
            return this.thisReference;
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            for (Method m : c.getMethods()) {
                if (!property.equals(m.getName())) continue;
                return m;
            }
        }
        throw new PropertyAccessException("could not access property (" + property + ")");
    }

    private void whiteSpaceSkip() {
        if (this.cursor < this.length) {
            while (Character.isWhitespace(this.property[this.cursor]) && ++this.cursor < this.length) {
            }
        }
    }

    private boolean scanTo(char c) {
        while (this.cursor < this.length) {
            if (this.property[this.cursor] == c) {
                return true;
            }
            ++this.cursor;
        }
        return false;
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        if (prop.length() != 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            throw new PropertyAccessException("unterminated '['");
        }
        String ex = new String(this.property, start, this.cursor++ - start);
        Object item = MVEL.eval(ex, ctx, this.variableFactory);
        if (ctx instanceof Map) {
            return ((Map)ctx).get(item);
        }
        if (ctx instanceof List) {
            return ((List)ctx).get((Integer)item);
        }
        if (ctx instanceof Collection) {
            int count = (Integer)item;
            if (count > ((Collection)ctx).size()) {
                throw new PropertyAccessException("index [" + count + "] out of bounds on collections");
            }
            Iterator iter = ((Collection)ctx).iterator();
            for (int i = 0; i < count; ++i) {
                iter.next();
            }
            return iter.next();
        }
        if (ctx instanceof Object[]) {
            return ((Object[])ctx)[(Integer)item];
        }
        if (ctx instanceof CharSequence) {
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)item));
        }
        throw new PropertyAccessException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()));
    }

    private Object getMethod(Object ctx, String name) throws Exception {
        Class[] parameterTypes;
        Method m;
        Object[] args;
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
            Object ptr = this.variableFactory.getVariableResolver(name).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name = ((MethodStub)ptr).getMethodName();
            } else {
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        }
        int st = this.cursor;
        this.cursor = ParseTools.balancedCapture(this.property, this.cursor, '(');
        String tk = this.cursor - st > 1 ? new String(this.property, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            args = new Object[subtokens.length];
            for (int i = 0; i < subtokens.length; ++i) {
                args[i] = MVEL.eval(subtokens[i], this.thisReference, this.variableFactory);
            }
        }
        Class<?> cls = ctx instanceof Class ? ctx : ctx.getClass();
        Object[] cache = PropertyAccessor.checkMethodCache(cls, PropertyAccessor.createSignature(name, tk));
        if (cache != null) {
            m = (Method)cache[0];
            parameterTypes = (Class[])cache[1];
        } else {
            m = null;
            parameterTypes = null;
        }
        if (m == null) {
            m = ParseTools.getBestCandidate(args, name, cls.getMethods());
            if (m != null) {
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name, tk), m);
                parameterTypes = m.getParameterTypes();
            }
            if (m == null && (m = ParseTools.getBestCandidate(args, name, cls.getClass().getDeclaredMethods())) != null) {
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name, tk), m);
                parameterTypes = m.getParameterTypes();
            }
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                return Array.getLength(ctx);
            }
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]");
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = DataConversion.convert(args[i], parameterTypes[i]);
        }
        return m.invoke(ctx, args);
    }

    private static int createSignature(String name, String args) {
        return name.hashCode() + args.hashCode();
    }

    static {
        PropertyAccessor.configureFactory();
    }
}

