/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ExpandableContentDeliveryUnit;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.dom.VisitPhase;
import org.milyn.javabean.BeanAccessor;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPopulator
implements DOMElementVisitor,
ExpandableContentDeliveryUnit {
    private static Log logger = LogFactory.getLog(BeanPopulator.class);
    private SmooksResourceConfiguration config;
    private String beanId;
    private Class beanClass;
    private boolean addToList = false;
    private String property;
    private Method beanSetterMethod;
    private String setOn;
    private String setOnProperty;
    private Method setOnBeanSetterMethod;
    private boolean isAttribute = true;
    private String attributeName;
    private String typeAlias;
    private DataDecoder decoder;

    public void setConfiguration(SmooksResourceConfiguration config) throws SmooksConfigurationException {
        this.config = config;
        String beanClassName = config.getStringParameter("beanClass", "").trim();
        this.beanId = config.getStringParameter("beanId", "").trim();
        if (this.beanId.equals("") && beanClassName.equals("")) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Both 'beanId' and 'beanClass' params are unspecified.");
        }
        if (!beanClassName.equals("")) {
            this.beanClass = this.createBeanRuntime(beanClassName);
            this.addToList = config.getBoolParameter("addToList", false);
        }
        if (this.beanId.equals("")) {
            this.beanId = this.toBeanId(this.beanClass);
            logger.debug((Object)("No 'beanId' specified for beanClass '" + beanClassName + "'.  Defaulting beanId to '" + this.beanId + "'."));
        }
        this.attributeName = config.getStringParameter("attributeName");
        if (this.attributeName != null) {
            this.attributeName = this.attributeName.trim();
            if (this.attributeName.equals("")) {
                throw new SmooksConfigurationException("Invalid Smooks bean configuration.  'attributeName' param specified but blank.");
            }
            this.isAttribute = true;
        } else {
            this.isAttribute = false;
        }
        this.property = config.getStringParameter("setterName");
        this.property = this.property != null ? this.toPropertyName(this.property) : config.getStringParameter("property");
        if ((this.property == null || (this.property = this.property.trim()).equals("")) && this.isAttribute) {
            this.property = this.attributeName;
        }
        this.setOn = config.getStringParameter("setOn");
        if (this.setOn != null) {
            this.setOnProperty = config.getStringParameter("setOnProperty", this.beanId);
        }
        this.typeAlias = config.getStringParameter("type", "String");
        logger.debug((Object)("Bean Populator created for [" + this.beanId + ":" + beanClassName + "].  Add to list=" + this.addToList + ", attributeName=" + this.attributeName + ", property=" + this.property));
    }

    public List<SmooksResourceConfiguration> getExpansionConfigurations() throws SmooksConfigurationException {
        ArrayList<SmooksResourceConfiguration> resources = new ArrayList<SmooksResourceConfiguration>();
        Parameter bindingsParam = this.config.getParameter("bindings");
        if (bindingsParam != null) {
            Element bindingsParamElement = bindingsParam.getXml();
            if (bindingsParamElement != null) {
                NodeList bindings = bindingsParamElement.getElementsByTagName("binding");
                try {
                    for (int i = 0; bindings != null && i < bindings.getLength(); ++i) {
                        resources.add(this.buildConfig((Element)bindings.item(i)));
                    }
                }
                catch (IOException e) {
                    throw new SmooksConfigurationException("Failed to read binding configuration for " + this.config, (Throwable)e);
                }
            } else {
                logger.error((Object)"Sorry, the Javabean populator bindings must be available as XML DOM.  Please configure using XML.");
            }
        }
        return resources;
    }

    private SmooksResourceConfiguration buildConfig(Element bindingConfig) throws IOException, SmooksConfigurationException {
        String type;
        SmooksResourceConfiguration resourceConfig = null;
        String selector = DomUtils.getAttributeValue((Element)bindingConfig, (String)"selector");
        if (selector == null) {
            throw new SmooksConfigurationException("Binding configuration must contain a 'selector' key: " + bindingConfig);
        }
        String property = DomUtils.getAttributeValue((Element)bindingConfig, (String)"property");
        if (property == null) {
            throw new SmooksConfigurationException("Binding configuration must contain a 'property' key: " + bindingConfig);
        }
        String attributeNameProperty = this.getAttributeNameProperty(selector);
        String selectorProperty = this.getSelectorProperty(selector);
        resourceConfig = new SmooksResourceConfiguration(selectorProperty, this.getClass().getName());
        resourceConfig.setParameter(VisitPhase.class.getSimpleName(), VisitPhase.PROCESSING.name());
        resourceConfig.setParameter("beanId", this.beanId);
        resourceConfig.setParameter("property", property);
        if (attributeNameProperty != null && !attributeNameProperty.trim().equals("")) {
            resourceConfig.setParameter("attributeName", attributeNameProperty);
        }
        resourceConfig.setParameter("type", (type = DomUtils.getAttributeValue((Element)bindingConfig, (String)"type")) != null ? type : "String");
        return resourceConfig;
    }

    private String getSelectorProperty(String selector) {
        String[] selectorTokens;
        StringBuffer selectorProp = new StringBuffer();
        for (String selectorToken : selectorTokens = selector.split(" ")) {
            if (selectorToken.trim().startsWith("@")) continue;
            selectorProp.append(selectorToken).append(" ");
        }
        return selectorProp.toString();
    }

    private String getAttributeNameProperty(String selector) {
        String[] selectorTokens;
        StringBuffer selectorProp = new StringBuffer();
        for (String selectorToken : selectorTokens = selector.split(" ")) {
            if (!selectorToken.trim().startsWith("@")) continue;
            selectorProp.append(selectorToken.substring(1));
        }
        return selectorProp.toString();
    }

    private String toSetterName(String property) {
        StringBuffer setterName = new StringBuffer();
        setterName.append(property);
        setterName.setCharAt(0, Character.toUpperCase(property.charAt(0)));
        setterName.insert(0, "set");
        return setterName.toString();
    }

    private String toPropertyName(String setterName) {
        StringBuffer propertyName = new StringBuffer(setterName);
        if (setterName.startsWith("set")) {
            propertyName.delete(0, 3);
            propertyName.setCharAt(0, Character.toLowerCase(propertyName.charAt(0)));
        }
        return propertyName.toString();
    }

    private String toBeanId(Class beanClass) {
        StringBuffer simpleClassName = new StringBuffer(beanClass.getSimpleName());
        simpleClassName.setCharAt(0, Character.toLowerCase(simpleClassName.charAt(0)));
        return simpleClassName.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Visiting bean populator for beanId [" + this.beanId + "] on element " + DomUtils.getXPath((Node)element)));
        }
        Object bean = this.getBean(executionContext);
        Object dataObject = this.getDataObject(element, executionContext);
        if (this.property == null && this.attributeName == null) {
            return;
        }
        if (this.beanSetterMethod == null) {
            this.beanSetterMethod = this.createBeanSetterMethod(bean, this.property, dataObject.getClass());
        }
        try {
            this.beanSetterMethod.invoke(bean, dataObject);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + this.toSetterName(this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + this.toSetterName(this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
    }

    private Object getDataObject(Element element, ExecutionContext executionContext) throws DataDecodeException {
        String dataString = this.isAttribute ? element.getAttribute(this.attributeName) : DomUtils.getAllText((Element)element, (boolean)false);
        if (this.decoder == null) {
            this.decoder = this.getDecoder(executionContext);
        }
        return this.decoder.decode(dataString);
    }

    private DataDecoder getDecoder(ExecutionContext executionContext) throws DataDecodeException {
        List decoders = executionContext.getDeliveryConfig().getObjects("decoder:" + this.typeAlias);
        if (decoders == null || decoders.isEmpty()) {
            this.decoder = DataDecoder.Factory.create(this.typeAlias);
        } else {
            if (!(decoders.get(0) instanceof DataDecoder)) {
                throw new DataDecodeException("Configured decoder '" + this.typeAlias + ":" + decoders.get(0).getClass().getName() + "' is not an instance of " + DataDecoder.class.getName());
            }
            this.decoder = (DataDecoder)decoders.get(0);
        }
        return this.decoder;
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
    }

    private Object getBean(ExecutionContext execContext) {
        Object bean = null;
        if (this.beanClass != null) {
            bean = this.createBeanInstance();
            BeanAccessor.addBean(this.beanId, bean, execContext, this.addToList);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bean [" + this.beanId + "] instance created."));
            }
            if (this.setOn != null) {
                Object setOnBean = BeanAccessor.getBean(this.setOn, execContext);
                if (setOnBean != null) {
                    try {
                        if (this.setOnBeanSetterMethod == null) {
                            this.setOnBeanSetterMethod = !this.addToList ? this.createBeanSetterMethod(setOnBean, this.setOnProperty, bean.getClass()) : this.createBeanSetterMethod(setOnBean, this.setOnProperty, List.class);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Setting bean '" + this.beanId + "' on parent bean '" + this.setOn + "'."));
                        }
                        if (!this.addToList) {
                            this.setOnBeanSetterMethod.invoke(setOnBean, bean);
                        }
                        Object beanList = BeanAccessor.getBean(this.beanId + "List", execContext);
                        this.setOnBeanSetterMethod.invoke(setOnBean, beanList);
                    }
                    catch (IllegalAccessException e) {
                        throw new SmooksConfigurationException("Error invoking bean setter method [" + this.toSetterName(this.setOnProperty) + "] on bean instance class type [" + setOnBean.getClass() + "].", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new SmooksConfigurationException("Error invoking bean setter method [" + this.toSetterName(this.setOnProperty) + "] on bean instance class type [" + setOnBean.getClass() + "].", (Throwable)e);
                    }
                } else {
                    logger.error((Object)("Failed to set bean '" + this.beanId + "' on parent bean '" + this.setOn + "'.  Failed to find bean '" + this.setOn + "'."));
                }
            }
        } else {
            bean = BeanAccessor.getBean(this.beanId, execContext);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not creating a new bean instance for beanId [" + this.beanId + "].  Using [" + bean + "]"));
            }
            if (bean == null) {
                throw new SmooksConfigurationException("Bean instance [id=" + this.beanId + "] not available and bean runtime class not set on configuration.");
            }
        }
        return bean;
    }

    private Object createBeanInstance() {
        Object bean;
        try {
            bean = this.beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanId + ":" + this.beanClass.getName() + "].", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanId + ":" + this.beanClass.getName() + "].", (Throwable)e);
        }
        return bean;
    }

    private Class createBeanRuntime(String beanClass) {
        Class clazz;
        try {
            clazz = ClassUtil.forName((String)beanClass, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + beanClass + " not in classpath.");
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + beanClass + " doesn't have a public default constructor.");
        }
        return clazz;
    }

    private synchronized Method createBeanSetterMethod(Object bean, String beanProperty, Class type) {
        if (this.beanSetterMethod == null) {
            String setterName = this.toSetterName(beanProperty);
            this.beanSetterMethod = this.getMethod(type, bean, setterName);
            if (this.beanSetterMethod == null && List.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(type, bean, setterName + "s");
            }
            if (this.beanSetterMethod == null && Integer.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(Integer.TYPE, bean, setterName);
            }
            if (this.beanSetterMethod == null && Long.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(Long.TYPE, bean, setterName);
            }
            if (this.beanSetterMethod == null && Float.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(Float.TYPE, bean, setterName);
            }
            if (this.beanSetterMethod == null && Double.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(Double.TYPE, bean, setterName);
            }
            if (this.beanSetterMethod == null && Double.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(Double.TYPE, bean, setterName);
            }
            if (this.beanSetterMethod == null && Character.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(Character.TYPE, bean, setterName);
            }
            if (this.beanSetterMethod == null && Byte.class.isAssignableFrom(type)) {
                this.beanSetterMethod = this.getMethod(Byte.TYPE, bean, setterName);
            }
            if (this.beanSetterMethod == null) {
                throw new SmooksConfigurationException("Bean [" + this.beanId + "] configuration invalid.  Bean setter method [" + setterName + "(" + type.getName() + ")] not found on type [" + bean.getClass().getName() + "].  You may need to set a 'decoder' on the binding config.");
            }
        }
        return this.beanSetterMethod;
    }

    private Method getMethod(Class type, Object bean, String setterName) {
        Method[] methods;
        for (Method method : methods = bean.getClass().getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals(setterName) || (params = method.getParameterTypes()) == null || params.length != 1 || !params[0].isAssignableFrom(type)) continue;
            this.beanSetterMethod = method;
            break;
        }
        return this.beanSetterMethod;
    }
}

