/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.Attribute;
import org.drools.asm.ClassReader;
import org.drools.asm.ClassVisitor;
import org.drools.asm.FieldVisitor;
import org.drools.asm.MethodVisitor;

public class ClassFieldInspector {
    private final List methods = new ArrayList();
    private final Map fieldNames = new HashMap();
    private final Map fieldTypes = new HashMap();
    private final Map methodNames = new HashMap();
    private final Set nonGetters = new HashSet();

    public ClassFieldInspector(Class clazz) throws IOException {
        this(clazz, true);
    }

    public ClassFieldInspector(Class clazz, boolean includeFinalMethods) throws IOException {
        String name = this.getResourcePath(clazz);
        InputStream stream = clazz.getResourceAsStream(name);
        if (stream != null) {
            this.processClassWithByteCode(clazz, stream, includeFinalMethods);
        } else {
            this.processClassWithoutByteCode(clazz, includeFinalMethods);
        }
    }

    private void processClassWithByteCode(Class clazz, InputStream stream, boolean includeFinalMethods) throws IOException {
        ClassReader reader = new ClassReader(stream);
        ClassFieldVisitor visitor = new ClassFieldVisitor(clazz, includeFinalMethods, this);
        reader.accept(visitor, false);
        if (clazz.getSuperclass() != null) {
            String name = this.getResourcePath(clazz.getSuperclass());
            InputStream parentStream = clazz.getResourceAsStream(name);
            if (parentStream != null) {
                this.processClassWithByteCode(clazz.getSuperclass(), parentStream, includeFinalMethods);
            } else {
                this.processClassWithoutByteCode(clazz.getSuperclass(), includeFinalMethods);
            }
        }
        if (clazz.isInterface()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String name = this.getResourcePath(interfaces[i]);
                InputStream parentStream = clazz.getResourceAsStream(name);
                if (parentStream != null) {
                    this.processClassWithByteCode(interfaces[i], parentStream, includeFinalMethods);
                    continue;
                }
                this.processClassWithoutByteCode(interfaces[i], includeFinalMethods);
            }
        }
    }

    private void processClassWithoutByteCode(Class clazz, boolean includeFinalMethods) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int mask;
            int n = mask = includeFinalMethods ? 1 : 17;
            if ((methods[i].getModifiers() & mask) != 1 || methods[i].getParameterTypes().length != 0 || methods[i].getName().equals("<init>") || methods[i].getName().equals("<clinit>") || methods[i].getReturnType() == Void.TYPE) continue;
            int fieldIndex = this.methods.size();
            this.addToMapping(methods[i], fieldIndex);
        }
    }

    private String getResourcePath(Class clazz) {
        return "/" + clazz.getName().replace('.', '/') + ".class";
    }

    public List getPropertyGetters() {
        return this.methods;
    }

    public Map getFieldNames() {
        return this.fieldNames;
    }

    public Map getFieldTypes() {
        return this.fieldTypes;
    }

    public Map getGetterMethods() {
        return this.methodNames;
    }

    private void addToMapping(Method method, int index) {
        String name;
        int offset = (name = method.getName()).startsWith("is") ? 2 : (name.startsWith("get") ? 3 : 0);
        String fieldName = this.calcFieldName(name, offset);
        if (this.fieldNames.containsKey(fieldName)) {
            if (offset != 0 && this.nonGetters.contains(fieldName)) {
                this.removeOldField(fieldName);
                this.storeField(method, index, fieldName);
                this.nonGetters.remove(fieldName);
            }
        } else {
            this.storeField(method, index, fieldName);
            if (offset == 0) {
                this.nonGetters.add(fieldName);
            }
        }
    }

    private void removeOldField(String fieldName) {
        this.fieldNames.remove(fieldName);
        this.fieldTypes.remove(fieldName);
        this.methods.remove(this.methodNames.get(fieldName));
        this.methodNames.remove(fieldName);
    }

    private void storeField(Method method, int index, String fieldName) {
        this.fieldNames.put(fieldName, new Integer(index));
        this.fieldTypes.put(fieldName, method.getReturnType());
        this.methodNames.put(fieldName, method);
        this.methods.add(method);
    }

    private String calcFieldName(String name, int offset) {
        name = name.substring(offset);
        return Introspector.decapitalize(name);
    }

    static class ClassFieldAnnotationVisitor
    implements AnnotationVisitor {
        ClassFieldAnnotationVisitor() {
        }

        public void visit(String arg0, Object arg1) {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String arg0) {
            return new ClassFieldAnnotationVisitor();
        }

        public void visitEnd() {
        }
    }

    static class ClassFieldVisitor
    implements ClassVisitor {
        private Class clazz;
        private ClassFieldInspector inspector;
        private boolean includeFinalMethods;

        ClassFieldVisitor(Class cls, boolean includeFinalMethods, ClassFieldInspector inspector) {
            this.clazz = cls;
            this.includeFinalMethods = includeFinalMethods;
            this.inspector = inspector;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            int mask;
            int n = mask = this.includeFinalMethods ? 1 : 17;
            if ((access & mask) == 1 && desc.startsWith("()") && !name.equals("<init>") && !name.equals("<clinit>")) {
                try {
                    Method method = this.clazz.getMethod(name, null);
                    if (method.getReturnType() != Void.TYPE) {
                        int fieldIndex = this.inspector.methods.size();
                        this.inspector.addToMapping(method, fieldIndex);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Error in getting field access method.");
                }
            }
            return null;
        }

        public void visit(int arg0, int arg1, String arg2, String arg3, String[] arg4, String arg5) {
        }

        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        public void visitField(int access, String arg1, String arg2, Object arg3, Attribute arg4) {
        }

        public void visitAttribute(Attribute arg0) {
        }

        public void visitEnd() {
        }

        public void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
        }

        public void visitSource(String arg0, String arg1) {
        }

        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }
    }
}

