/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jci.compilers.JavaCompiler;

public final class JavaCompilerFactory {
    private static final JavaCompilerFactory INSTANCE = new JavaCompilerFactory();
    private final Map classCache = new HashMap();

    public static JavaCompilerFactory getInstance() {
        return INSTANCE;
    }

    private JavaCompilerFactory() {
    }

    private String toJavaCasing(String pName) {
        char[] name = pName.toLowerCase().toCharArray();
        name[0] = Character.toUpperCase(name[0]);
        return new String(name);
    }

    public JavaCompiler createCompiler(String pHint) {
        String className = pHint.indexOf(46) < 0 ? "org.apache.commons.jci.compilers." + this.toJavaCasing(pHint) + "JavaCompiler" : pHint;
        Class<?> clazz = (Class<?>)this.classCache.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                this.classCache.put(className, clazz);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            return null;
        }
        try {
            return (JavaCompiler)clazz.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

