/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;

public class OutputMultiplexor {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$OutputMultiplexor == null ? (class$org$jboss$remoting$transport$multiplex$OutputMultiplexor = OutputMultiplexor.class$("org.jboss.remoting.transport.multiplex.OutputMultiplexor")) : class$org$jboss$remoting$transport$multiplex$OutputMultiplexor);
    protected static final int BRACKETS_ALL = -1;
    protected static final int BRACKETS_NONE = -2;
    protected static final int HEADER_SIZE = 7;
    private int messagePoolSize;
    private int messageSize;
    private int maxChunkSize;
    private int maxTimeSlice;
    private int maxDataSlice;
    private int maxErrors;
    private Map configuration = new HashMap();
    private Map writeQueues = Collections.synchronizedMap(new HashMap());
    private Map readyQueues = Collections.synchronizedMap(new HashMap());
    private Map previousDestinationIds = Collections.synchronizedMap(new HashMap());
    private Set unregisteredClients = Collections.synchronizedSet(new HashSet());
    private List messagePool;
    private ByteBuffer buffer;
    private byte[] header = new byte[7];
    private int errorCount;
    private boolean trace;
    private boolean debug;
    private boolean info;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$OutputMultiplexor;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread;

    protected OutputMultiplexor(Map configuration) throws IOException {
        this.configuration.putAll(configuration);
        this.messagePoolSize = Multiplex.getOneParameter(configuration, "messagePoolSize", "multiplex.outputMessagePoolSize", 1024);
        this.messageSize = Multiplex.getOneParameter(configuration, "messageSize", "multiplex.outputMessageSize", 256);
        this.maxChunkSize = Multiplex.getOneParameter(configuration, "maxChunkSize", "multiplex.outputMaxChunkSize", 2048);
        this.maxTimeSlice = Multiplex.getOneParameter(configuration, "maxTimeSlice", "multiplex.outputMaxTimeSlice", 500);
        this.maxDataSlice = Multiplex.getOneParameter(configuration, "maxDataSlice", "multiplex.outputMaxDataSlice", 16384);
        this.maxErrors = Multiplex.getOneParameter(configuration, "maxErrors", "multiplex.outputMaxErrors", 3);
        log.debug("messagePoolSize: " + this.messagePoolSize);
        log.debug("messageSize:     " + this.messageSize);
        log.debug("maxChunkSize:    " + this.maxChunkSize);
        log.debug("maxTimeSlice:    " + this.maxTimeSlice);
        log.debug("maxDataSlice:    " + this.maxDataSlice);
        log.debug("maxErrors:       " + this.maxErrors);
        this.messagePool = Collections.synchronizedList(new ArrayList(this.messagePoolSize));
        for (int i = 0; i < this.messagePoolSize; ++i) {
            this.messagePool.add(new Message(this.messageSize));
        }
        this.buffer = ByteBuffer.allocate(this.maxChunkSize + 7);
        this.trace = log.isTraceEnabled();
        this.debug = log.isDebugEnabled();
        this.info = log.isInfoEnabled();
    }

    public OutputThread getAnOutputThread() {
        return new OutputThread();
    }

    public void write(MultiplexingManager manager, SocketId socketId, byte[] content) throws IOException {
        this.write(manager, socketId, content, -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MultiplexingManager manager, SocketId socketId, byte[] content, int brackets) throws IOException {
        log.debug("entering write()");
        if (this.trace) {
            String messageEnd = "";
            if (content.length > 0) {
                messageEnd = ": [" + (0xFF & content[0]) + "]";
            }
            log.trace("OutputMultiplexor.write(): queueing " + content.length + " bytes for \n  manager: " + manager + "\n  socket: " + socketId.getPort() + messageEnd);
        }
        if (content.length == 0) {
            return;
        }
        Map map = this.readyQueues;
        synchronized (map) {
            List writeQueue = (List)this.writeQueues.get(manager);
            if (writeQueue == null) {
                log.error("unregistered client: " + manager);
                return;
            }
            List list = writeQueue;
            synchronized (list) {
                if (!writeQueue.isEmpty()) {
                    Message message = (Message)writeQueue.get(writeQueue.size() - 1);
                    if (message.getDestination().equals(socketId) && message.hasCompatibleBrackets(brackets)) {
                        message.addContent(content);
                    } else {
                        writeQueue.add(this.getaMessage(socketId, content, brackets));
                    }
                } else {
                    writeQueue.add(this.getaMessage(socketId, content, brackets));
                }
            }
            this.readyQueues.put(manager, writeQueue);
            this.readyQueues.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(OutputMultiplexorClient client) {
        if (this.debug) {
            log.debug("registering: " + client);
        }
        Map map = this.writeQueues;
        synchronized (map) {
            List writeQueue = Collections.synchronizedList(new LinkedList());
            this.writeQueues.put(client, writeQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(OutputMultiplexorClient client) {
        if (this.debug) {
            log.debug("unregistering: " + client);
        }
        Map map = this.writeQueues;
        synchronized (map) {
            List writeQueue = (List)this.writeQueues.get(client);
            if (writeQueue == null) {
                log.debug("attempt to unregister unknown Listener: " + client);
                client.outputFlushed();
                return;
            }
            if (writeQueue.isEmpty()) {
                this.writeQueues.remove(client);
                this.previousDestinationIds.remove(client);
                client.outputFlushed();
            } else {
                this.unregisteredClients.add(client);
            }
        }
    }

    protected Message getaMessage(SocketId socketId, byte[] content, int brackets) throws IOException {
        Message m = null;
        m = this.messagePool.isEmpty() ? new Message(this.messageSize) : (Message)this.messagePool.remove(0);
        m.set(socketId, content, brackets);
        return m;
    }

    protected void releaseMessage(Message m) {
        if (this.messagePool.size() < this.messagePoolSize) {
            this.messagePool.add(m);
        }
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public int getMessagePoolSize() {
        return this.messagePoolSize;
    }

    public void setMessagePoolSize(int messagePoolSize) {
        this.messagePoolSize = messagePoolSize;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Message {
        private SocketId socketId;
        private ByteArrayOutputStream baos;
        private int start;
        private int length;
        private int brackets;

        public Message(int size) {
            this.baos = new ByteArrayOutputStream(size);
        }

        public void set(SocketId socketId, byte[] content, int brackets) throws IOException {
            this.socketId = socketId;
            this.baos.reset();
            this.baos.write(content);
            this.start = 0;
            this.length = content.length;
            this.brackets = brackets;
        }

        public SocketId getDestination() {
            return this.socketId;
        }

        public byte[] getContent() {
            return this.baos.toByteArray();
        }

        public void addContent(byte[] bytes) throws IOException {
            this.baos.write(bytes);
            this.length += bytes.length;
        }

        public void addContent(byte[] bytes, int start, int length) {
            this.baos.write(bytes, start, length);
            this.length += length;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public int getBrackets() {
            return this.brackets;
        }

        public void markUsed(int used) {
            this.length -= used;
            if (this.length <= 0) {
                this.start = 0;
                this.length = 0;
                this.baos.reset();
            } else {
                this.start += used;
            }
        }

        public boolean brackets(int b) {
            if (this.brackets == -1) {
                return true;
            }
            if (this.brackets == -2) {
                return false;
            }
            return this.brackets == b;
        }

        public boolean hasCompatibleBrackets(int b) {
            if (this.brackets == -1 || b == -2) {
                return true;
            }
            return this.brackets == b;
        }
    }

    class OutputThread
    extends StoppableThread {
        private final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread == null ? (class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread = OutputMultiplexor.class$("org.jboss.remoting.transport.multiplex.OutputMultiplexor$OutputThread")) : class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread);
        private boolean socketIsOpen = true;
        private Map localWriteQueues = new HashMap();
        private Message pendingMessage;

        public void shutdown() {
            super.shutdown();
            this.interrupt();
        }

        protected void doInit() {
            this.log.debug("output thread starting");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            while (this.isRunning()) {
                this.log.debug("STARTING new output round");
                this.localWriteQueues.clear();
                Map map = OutputMultiplexor.this.readyQueues;
                synchronized (map) {
                    while (OutputMultiplexor.this.readyQueues.isEmpty()) {
                        try {
                            this.log.debug("waiting");
                            OutputMultiplexor.this.readyQueues.wait();
                        }
                        catch (InterruptedException e) {
                            if (this.isRunning()) continue;
                            return;
                        }
                    }
                    this.localWriteQueues.putAll(OutputMultiplexor.this.readyQueues);
                    OutputMultiplexor.this.readyQueues.clear();
                }
                Iterator it = this.localWriteQueues.keySet().iterator();
                while (it.hasNext()) {
                    try {
                        MultiplexingManager manager = (MultiplexingManager)it.next();
                        List writeQueue = (List)this.localWriteQueues.get(manager);
                        OutputStream os = manager.getOutputStream();
                        SocketId destination = null;
                        int dataOutCount = 0;
                        long startTime = System.currentTimeMillis();
                        while (!writeQueue.isEmpty()) {
                            long timeSpent = System.currentTimeMillis() - startTime;
                            if (timeSpent > (long)OutputMultiplexor.this.maxTimeSlice || dataOutCount > OutputMultiplexor.this.maxDataSlice) {
                                if (OutputMultiplexor.this.debug) {
                                    this.log.debug("returning queue: data out: " + dataOutCount + ", time spent: " + timeSpent);
                                }
                                Map map2 = OutputMultiplexor.this.readyQueues;
                                synchronized (map2) {
                                    OutputMultiplexor.this.readyQueues.put(manager, writeQueue);
                                    break;
                                }
                            }
                            this.pendingMessage = (Message)writeQueue.remove(0);
                            destination = this.pendingMessage.getDestination();
                            int start = this.pendingMessage.getStart();
                            int length = Math.min(this.pendingMessage.getLength(), OutputMultiplexor.this.maxChunkSize);
                            try {
                                this.encode(destination, this.pendingMessage.getContent(), start, length, os, manager.getSocket().getChannel());
                            }
                            catch (ClosedChannelException e) {
                                this.log.info(e);
                                writeQueue.clear();
                                manager.setWriteException(e);
                                break;
                            }
                            catch (IOException e) {
                                String message = e.getMessage();
                                if ("An existing connection was forcibly closed by the remote host".equals(message) || "An established connection was aborted by the software in your host machine".equals(message) || "Broken pipe".equals(message)) {
                                    this.log.debug(e);
                                    writeQueue.clear();
                                    manager.setWriteException(e);
                                    break;
                                }
                                if (++OutputMultiplexor.this.errorCount > OutputMultiplexor.this.maxErrors) {
                                    this.log.error(e);
                                    manager.setWriteException(e);
                                    throw e;
                                }
                                throw e;
                            }
                            if (length < this.pendingMessage.getLength()) {
                                this.returnLongMessageToQueue(writeQueue, this.pendingMessage);
                            } else {
                                OutputMultiplexor.this.releaseMessage(this.pendingMessage);
                            }
                            dataOutCount += length;
                            this.pendingMessage = null;
                            if (!OutputMultiplexor.this.trace) continue;
                            this.log.trace("output thread wrote: " + length + " bytes to socket " + destination.getPort());
                        }
                        if (writeQueue.isEmpty() && OutputMultiplexor.this.unregisteredClients.contains(manager)) {
                            OutputMultiplexor.this.writeQueues.remove(writeQueue);
                            OutputMultiplexor.this.previousDestinationIds.remove(manager);
                            OutputMultiplexor.this.unregisteredClients.remove(manager);
                            manager.outputFlushed();
                            continue;
                        }
                        OutputMultiplexor.this.previousDestinationIds.put(manager, destination);
                        if (!OutputThread.interrupted()) continue;
                        throw new InterruptedException();
                    }
                    catch (InterruptedException e) {
                        this.handleError("output thread: interrupted", e);
                    }
                    catch (SocketException e) {
                        this.handleError("output thread: socket exception", e);
                    }
                    catch (IOException e) {
                        this.handleError("output thread: i/o error", e);
                    }
                    finally {
                        it.remove();
                    }
                }
            }
            this.log.debug("output thread: socketIsConnected: " + this.socketIsOpen);
            this.log.debug("output thread: running: " + this.running);
            this.log.debug("output thread: pendingMessage ==  " + this.pendingMessage);
        }

        protected void doShutDown() {
            this.log.debug("output thread shutting down");
        }

        protected void encode(SocketId destination, byte[] bytes, int start, int length, OutputStream os, SocketChannel channel) throws IOException {
            int port = destination.getPort();
            ((OutputMultiplexor)OutputMultiplexor.this).header[0] = 0;
            ((OutputMultiplexor)OutputMultiplexor.this).header[1] = (byte)(port >>> 24 & 0xFF);
            ((OutputMultiplexor)OutputMultiplexor.this).header[2] = (byte)(port >>> 16 & 0xFF);
            ((OutputMultiplexor)OutputMultiplexor.this).header[3] = (byte)(port >>> 8 & 0xFF);
            ((OutputMultiplexor)OutputMultiplexor.this).header[4] = (byte)(port & 0xFF);
            ((OutputMultiplexor)OutputMultiplexor.this).header[5] = (byte)(length >> 8 & 0xFF);
            ((OutputMultiplexor)OutputMultiplexor.this).header[6] = (byte)(length & 0xFF);
            if (channel == null) {
                os.write(OutputMultiplexor.this.header);
                os.write(bytes, start, length);
                os.flush();
            } else {
                OutputMultiplexor.this.buffer.clear();
                OutputMultiplexor.this.buffer.put(OutputMultiplexor.this.header);
                OutputMultiplexor.this.buffer.put(bytes, start, length);
                OutputMultiplexor.this.buffer.flip();
                while (OutputMultiplexor.this.buffer.hasRemaining()) {
                    channel.write(OutputMultiplexor.this.buffer);
                }
            }
            if (OutputMultiplexor.this.trace) {
                this.log.trace("encode(): wrote " + length + " bytes to: " + destination);
                this.log.trace("header: " + OutputMultiplexor.this.header[0] + " " + OutputMultiplexor.this.header[1] + " " + OutputMultiplexor.this.header[2] + " " + OutputMultiplexor.this.header[3] + " " + OutputMultiplexor.this.header[4] + " " + OutputMultiplexor.this.header[5] + " " + OutputMultiplexor.this.header[6]);
                for (int i = 0; i < length; ++i) {
                    this.log.trace("" + (0xFF & bytes[i]));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void returnLongMessageToQueue(List writeQueue, Message pendingMessage) {
            SocketId destination = pendingMessage.getDestination();
            pendingMessage.markUsed(OutputMultiplexor.this.maxChunkSize);
            List list = writeQueue;
            synchronized (list) {
                if (!writeQueue.isEmpty()) {
                    ListIterator<Message> lit = writeQueue.listIterator();
                    boolean processed = false;
                    int remotePort = destination.getPort();
                    int brackets = pendingMessage.getBrackets();
                    while (lit.hasNext()) {
                        Message message = (Message)lit.next();
                        if (message.brackets(remotePort)) {
                            lit.previous();
                            lit.add(pendingMessage);
                            processed = true;
                            break;
                        }
                        if (!message.getDestination().equals(destination) || -2 != message.getBrackets() && brackets != message.getBrackets()) continue;
                        pendingMessage.addContent(message.getContent(), message.getStart(), message.getLength());
                        lit.set(pendingMessage);
                        processed = true;
                        break;
                    }
                    if (!processed) {
                        writeQueue.add(pendingMessage);
                    }
                } else {
                    writeQueue.add(pendingMessage);
                }
            }
        }

        protected void handleError(String message, Throwable e) {
            if (this.log != null) {
                if (e instanceof InterruptedException) {
                    if (OutputMultiplexor.this.trace) {
                        this.log.trace(message, e);
                    }
                } else {
                    this.log.error(message, e);
                }
            }
        }
    }

    public static interface OutputMultiplexorClient {
        public void outputFlushed();
    }
}

