/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.injection.lang.reflect.AbstractAccessibleObjectBeanProperty;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBeanProperty
extends AbstractAccessibleObjectBeanProperty<Method> {
    private final Logger log = Logger.getLogger(MethodBeanProperty.class);
    private String name = null;

    public MethodBeanProperty(Method method) {
        super(method);
        assert (method.getReturnType() == Void.TYPE);
        assert (method.getParameterTypes().length == 1);
        assert (method.getName().startsWith("set"));
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getMethod().getDeclaringClass();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            String name = this.getMethod().getName().substring(3);
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
            this.name = name;
        }
        return this.name;
    }

    protected Method getMethod() {
        return (Method)this.getAccessibleObject();
    }

    @Override
    public Class<?> getType() {
        return this.getMethod().getParameterTypes()[0];
    }

    @Override
    public void set(Object instance, Object value) {
        Method method = this.getMethod();
        Object[] args = new Object[]{value};
        try {
            method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            this.log.fatal("illegal access on method " + method, e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            String msg = "failed to set value " + value + " with setter " + method;
            this.log.error(msg, e);
            throw new IllegalArgumentException(msg);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

