/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;

public class SOAPMessageDispatcher {
    private static Logger log = Logger.getLogger(SOAPMessageDispatcher.class);

    public OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, SOAPMessage soapMessage) throws SOAPException {
        OperationMetaData opMetaData = null;
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        AddressingProperties inProps = (AddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
        if (inProps != null && inProps.getAction() != null) {
            String wsaAction = inProps.getAction().getURI().toASCIIString();
            for (OperationMetaData opAux : epMetaData.getOperations()) {
                if (!wsaAction.equals(opAux.getSOAPAction())) continue;
                opMetaData = opAux;
                log.debug((Object)("Use wsa:Action dispatch: " + wsaAction));
                break;
            }
        }
        if (opMetaData == null) {
            SOAPBody soapBody = soapMessage.getSOAPBody();
            Iterator bodyChildren = soapBody.getChildElements();
            if (!bodyChildren.hasNext()) {
                throw new SOAPException("SOAPBody has no child element");
            }
            SOAPBodyElement soapBodyElement = (SOAPBodyElement)bodyChildren.next();
            if (bodyChildren.hasNext()) {
                throw new SOAPException("SOAPBody has more than on child element");
            }
            Name soapName = soapBodyElement.getElementName();
            QName xmlElementName = new QName(soapName.getURI(), soapName.getLocalName());
            opMetaData = epMetaData.getOperation(xmlElementName);
        }
        if (opMetaData == null) {
            for (OperationMetaData opAux : epMetaData.getOperations()) {
                if (!opAux.isMessageEndpoint()) continue;
                opMetaData = opAux;
                log.debug((Object)"Use generic message style dispatch");
                break;
            }
        }
        log.debug((Object)("getDispatchDestination: " + (opMetaData != null ? opMetaData.getXmlName() : null)));
        return opMetaData;
    }
}

