/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.binding;

import java.util.HashMap;
import javax.xml.rpc.JAXRPCException;
import org.jboss.ws.binding.BindingProvider;
import org.jboss.ws.binding.soap.SOAP11BindingProvider;

public class BindingProviderRegistry {
    private static Class defaultProvider = SOAP11BindingProvider.class;
    private static HashMap providers = new HashMap();

    public static BindingProvider getProvider(String bindingURI) {
        if (bindingURI == null) {
            return BindingProviderRegistry.getDefaultProvider();
        }
        try {
            Class provClass = (Class)providers.get(bindingURI);
            BindingProvider prov = (BindingProvider)provClass.newInstance();
            return prov;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXRPCException((Throwable)e);
        }
    }

    public static BindingProvider getDefaultProvider() {
        try {
            BindingProvider prov = (BindingProvider)defaultProvider.newInstance();
            return prov;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXRPCException((Throwable)e);
        }
    }

    static {
        providers.put("http://schemas.xmlsoap.org/soap/envelope/", defaultProvider);
    }
}

