/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.sql.SQLException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.toplink.LocalSessionFactory;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;

public class LocalSessionFactoryBean
extends LocalSessionFactory
implements FactoryBean,
BeanClassLoaderAware,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    private SessionFactory sessionFactory;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    static /* synthetic */ Class class$org$springframework$orm$toplink$SessionFactory;

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.setSessionClassLoader(classLoader);
    }

    public void afterPropertiesSet() throws TopLinkException {
        this.sessionFactory = this.createSessionFactory();
    }

    public Object getObject() {
        return this.sessionFactory;
    }

    public Class getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : (class$org$springframework$orm$toplink$SessionFactory == null ? (class$org$springframework$orm$toplink$SessionFactory = LocalSessionFactoryBean.class$("org.springframework.orm.toplink.SessionFactory")) : class$org$springframework$orm$toplink$SessionFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof TopLinkException) {
            return this.convertTopLinkAccessException((TopLinkException)ex);
        }
        return null;
    }

    public DataAccessException convertTopLinkAccessException(TopLinkException ex) {
        Throwable internalEx;
        if (this.getJdbcExceptionTranslator() != null && ex instanceof DatabaseException && (internalEx = ex.getInternalException()) instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("TopLink operation: " + ex.getMessage(), null, (SQLException)internalEx);
        }
        return SessionFactoryUtils.convertTopLinkAccessException(ex);
    }

    public void destroy() {
        this.logger.info((Object)"Closing TopLink SessionFactory");
        this.sessionFactory.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

