/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class TModelHandler
extends AbstractHandler {
    public static final String TAG_NAME = "tModel";
    private HandlerMaker maker = null;

    protected TModelHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Name name;
        TModel obj = new TModel();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setTModelKey(element.getAttribute("tModelKey"));
        obj.setOperator(element.getAttribute("operator"));
        obj.setAuthorizedName(element.getAttribute("authorizedName"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "name");
        if (nodeList.size() > 0 && (name = (Name)(handler = this.maker.lookup("name")).unmarshal((Element)nodeList.elementAt(0))) != null) {
            obj.setName(name);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            Description descr = (Description)handler.unmarshal((Element)nodeList.elementAt(i));
            if (descr == null) continue;
            obj.addDescription(descr);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "overviewDoc");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("overviewDoc");
            obj.setOverviewDoc((OverviewDoc)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "identifierBag")).size() > 0) {
            handler = this.maker.lookup("identifierBag");
            obj.setIdentifierBag((IdentifierBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "categoryBag")).size() > 0) {
            handler = this.maker.lookup("categoryBag");
            obj.setCategoryBag((CategoryBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        CategoryBag categoryBag;
        IdentifierBag identifierBag;
        OverviewDoc overDoc;
        Vector descrVector;
        Name name;
        String authName;
        TModel tModel = (TModel)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        String tModelKey = tModel.getTModelKey();
        if (tModelKey != null) {
            element.setAttribute("tModelKey", tModelKey);
        } else {
            element.setAttribute("tModelKey", "");
        }
        String operator = tModel.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        }
        if ((authName = tModel.getAuthorizedName()) != null) {
            element.setAttribute("authorizedName", authName);
        }
        if ((name = tModel.getName()) != null) {
            handler = this.maker.lookup("name");
            handler.marshal(name, element);
        }
        if ((descrVector = tModel.getDescriptionVector()) != null && descrVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descrVector.size(); ++i) {
                handler.marshal((Description)descrVector.elementAt(i), element);
            }
        }
        if ((overDoc = tModel.getOverviewDoc()) != null) {
            handler = this.maker.lookup("overviewDoc");
            handler.marshal(overDoc, element);
        }
        if ((identifierBag = tModel.getIdentifierBag()) != null && identifierBag.getKeyedReferenceVector() != null && !identifierBag.getKeyedReferenceVector().isEmpty()) {
            handler = this.maker.lookup("identifierBag");
            handler.marshal(identifierBag, element);
        }
        if ((categoryBag = tModel.getCategoryBag()) != null && categoryBag.getKeyedReferenceVector() != null && !categoryBag.getKeyedReferenceVector().isEmpty()) {
            handler = this.maker.lookup("categoryBag");
            handler.marshal(categoryBag, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        OverviewDoc overDoc = new OverviewDoc();
        overDoc.setOverviewURL("http://www.sviens.com/service.html");
        overDoc.addDescription(new Description("over-doc Descr"));
        overDoc.addDescription(new Description("over-doc Descr Two", "en"));
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(new KeyedReference("catBagKeyName", "catBagKeyValue"));
        catBag.addKeyedReference(new KeyedReference("uuid:dfddb58c-4853-4a71-865c-f84509017cc7", "catBagKeyName2", "catBagKeyValue2"));
        IdentifierBag idBag = new IdentifierBag();
        idBag.addKeyedReference(new KeyedReference("idBagKeyName", "idBagkeyValue"));
        idBag.addKeyedReference(new KeyedReference("uuid:f78a135a-4769-4e79-8604-54d440314bc0", "idBagKeyName2", "idBagkeyValue2"));
        TModel tModel = new TModel();
        tModel.setTModelKey("uuid:269855db-62eb-4862-8e5a-1b06f2753038");
        tModel.setOperator("jUDDI");
        tModel.setAuthorizedName("Steve Viens");
        tModel.setName("jUDDI TModel");
        tModel.addDescription(new Description("tModel whatever"));
        tModel.addDescription(new Description("tModel whatever too", "fr"));
        tModel.setCategoryBag(catBag);
        tModel.setIdentifierBag(idBag);
        tModel.setOverviewDoc(overDoc);
        System.out.println();
        RegistryObject regObject = tModel;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

