/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.BusinessInfos;
import org.apache.juddi.datatype.response.RegisteredInfo;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class RegisteredInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "registeredInfo";
    private HandlerMaker maker = null;

    protected RegisteredInfoHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        RegisteredInfo obj = new RegisteredInfo();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "businessInfos");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("businessInfos");
            obj.setBusinessInfos((BusinessInfos)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "tModelInfos")).size() > 0) {
            handler = this.maker.lookup("tModelInfos");
            obj.setTModelInfos((TModelInfos)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        TModelInfos tInfos;
        RegisteredInfo info = (RegisteredInfo)object;
        String generic = info.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        String operator = info.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        BusinessInfos bInfos = info.getBusinessInfos();
        if (bInfos != null) {
            handler = this.maker.lookup("businessInfos");
            handler.marshal(bInfos, element);
        }
        if ((tInfos = info.getTModelInfos()) != null) {
            handler = this.maker.lookup("tModelInfos");
            handler.marshal(tInfos, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        ServiceInfo sInfo = new ServiceInfo();
        sInfo.addName(new Name("regInfoServNm"));
        sInfo.addName(new Name("regInfoServNm2", "en"));
        sInfo.setServiceKey("826e6443-e3c5-442b-9bf8-943071ca83f4");
        sInfo.setBusinessKey("56644a68-8779-46c7-93ce-90eeb7569f3f");
        BusinessInfo bInfo = new BusinessInfo();
        bInfo.setBusinessKey("56644a68-8779-46c7-93ce-90eeb7569f3f");
        bInfo.addName(new Name("regInfoBizNm"));
        bInfo.addName(new Name("regInfoBizNm2", "en"));
        bInfo.addDescription(new Description("regInfoBiz whatever"));
        bInfo.addDescription(new Description("regInfoBiz whatever too", "fr"));
        bInfo.addServiceInfo(sInfo);
        BusinessInfos bInfos = new BusinessInfos();
        bInfos.addBusinessInfo(bInfo);
        bInfos.addBusinessInfo(bInfo);
        TModelInfo tInfo = new TModelInfo();
        tInfo.setTModelKey("uuid:e86bd2a9-03f6-44c4-b619-400ef2cd7e47");
        tInfo.setName(new Name("RegInfoTestDriver"));
        TModelInfos tInfos = new TModelInfos();
        tInfos.addTModelInfo(tInfo);
        tInfos.addTModelInfo(tInfo);
        RegisteredInfo info = new RegisteredInfo();
        info.setGeneric("2.0");
        info.setOperator("jUDDI.org");
        info.setBusinessInfos(bInfos);
        info.setTModelInfos(tInfos);
        System.out.println();
        RegistryObject regObject = info;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

