/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.request.ValidateValues;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class ValidateValuesFunction
extends AbstractFunction {
    public ValidateValuesFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject obj) throws RegistryException {
        Vector tModelVector;
        Vector serviceVector;
        ValidateValues request = (ValidateValues)obj;
        String generic = request.getGeneric();
        Vector businessVector = request.getBusinessEntityVector();
        if (businessVector != null && businessVector.size() > 0) {
            this.validateBusinessVector(businessVector);
        }
        if ((serviceVector = request.getBusinessServiceVector()) != null && serviceVector.size() > 0) {
            this.validateServiceVector(serviceVector);
        }
        if ((tModelVector = request.getTModelVector()) != null && tModelVector.size() > 0) {
            this.validateTModelVector(tModelVector);
        }
        Result result = new Result(0);
        result.setErrCode(Result.lookupErrCode(0));
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(result);
        return dispRpt;
    }

    private RegistryObject validateBusinessVector(Vector businessVector) {
        if (businessVector == null) {
            return null;
        }
        for (int i = 0; i < businessVector.size(); ++i) {
            Vector serviceVector;
            BusinessServices services;
            Vector refs;
            IdentifierBag idBag;
            Vector refs2;
            BusinessEntity business = (BusinessEntity)businessVector.elementAt(i);
            CategoryBag catBag = business.getCategoryBag();
            if (catBag != null && (refs2 = catBag.getKeyedReferenceVector()) != null && refs2.size() > 0) {
                this.validate(refs2);
            }
            if ((idBag = business.getIdentifierBag()) != null && (refs = idBag.getKeyedReferenceVector()) != null && refs.size() > 0) {
                this.validate(refs);
            }
            if ((services = business.getBusinessServices()) == null || (serviceVector = services.getBusinessServiceVector()) == null) continue;
            this.validateServiceVector(serviceVector);
        }
        return null;
    }

    private RegistryObject validateServiceVector(Vector serviceVector) {
        if (serviceVector == null) {
            return null;
        }
        for (int i = 0; i < serviceVector.size(); ++i) {
            Vector bindings;
            BindingTemplates templates;
            Vector refs;
            BusinessService service = (BusinessService)serviceVector.elementAt(i);
            CategoryBag catBag = service.getCategoryBag();
            if (catBag != null && (refs = catBag.getKeyedReferenceVector()) != null && refs.size() > 0) {
                this.validate(refs);
            }
            if ((templates = service.getBindingTemplates()) == null || (bindings = templates.getBindingTemplateVector()) == null) continue;
            this.validateBindingVector(bindings);
        }
        return null;
    }

    private RegistryObject validateBindingVector(Vector bindingVector) {
        if (bindingVector == null) {
            return null;
        }
        for (int i = 0; i < bindingVector.size(); ++i) {
            Vector refs;
            BindingTemplate binding = (BindingTemplate)bindingVector.elementAt(i);
            CategoryBag catBag = binding.getCategoryBag();
            if (catBag == null || (refs = catBag.getKeyedReferenceVector()) == null || refs.size() <= 0) continue;
            this.validate(refs);
        }
        return null;
    }

    private RegistryObject validateTModelVector(Vector tModelVector) {
        if (tModelVector == null) {
            return null;
        }
        for (int i = 0; i < tModelVector.size(); ++i) {
            Vector refs;
            IdentifierBag idBag;
            Vector refs2;
            TModel tModel = (TModel)tModelVector.elementAt(i);
            CategoryBag catBag = tModel.getCategoryBag();
            if (catBag != null && (refs2 = catBag.getKeyedReferenceVector()) != null && refs2.size() > 0) {
                this.validate(refs2);
            }
            if ((idBag = tModel.getIdentifierBag()) == null || (refs = idBag.getKeyedReferenceVector()) == null || refs.size() <= 0) continue;
            this.validate(refs);
        }
        return null;
    }

    private RegistryObject validate(Vector refs) {
        if (refs == null) {
            return null;
        }
        for (int i = 0; i < refs.size(); ++i) {
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }
}

