/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.request.FindTModel;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.datatype.response.TModelList;
import org.apache.juddi.error.NameTooLongException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class FindTModelFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$FindTModelFunction == null ? (class$org$apache$juddi$function$FindTModelFunction = FindTModelFunction.class$("org.apache.juddi.function.FindTModelFunction")) : class$org$apache$juddi$function$FindTModelFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$FindTModelFunction;

    public FindTModelFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        int i;
        int vectorSize;
        Vector keyedRefVector;
        FindTModel request = (FindTModel)regObject;
        String generic = request.getGeneric();
        String tModelName = request.getNameString();
        CategoryBag categoryBag = request.getCategoryBag();
        IdentifierBag identifierBag = request.getIdentifierBag();
        FindQualifiers qualifiers = request.getFindQualifiers();
        int maxRows = request.getMaxRows();
        if (!(tModelName != null && tModelName.length() != 0 || identifierBag != null && identifierBag.size() != 0 || categoryBag != null && categoryBag.size() != 0)) {
            TModelList list = new TModelList();
            list.setGeneric(generic);
            list.setTModelInfos(new TModelInfos());
            list.setOperator(Config.getOperator());
            list.setTruncated(false);
            return list;
        }
        if (categoryBag != null && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null && (vectorSize = keyedRefVector.size()) > 0) {
            for (i = 0; i < vectorSize; ++i) {
                KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                String key = keyedRef.getTModelKey();
                if (key != null && key.trim().length() != 0) continue;
                keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
            }
        }
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            Vector qVector;
            dataStore.beginTrans();
            if (tModelName != null) {
                int maxNameLength = Config.getMaxNameLengthAllowed();
                if (tModelName.length() > maxNameLength) {
                    throw new NameTooLongException("find_tModel: name=" + tModelName + ", " + "length=" + tModelName.length() + ", " + "maxNameLength=" + maxNameLength);
                }
            }
            if (qualifiers != null && (qVector = qualifiers.getFindQualifierVector()) != null && qVector.size() > 0) {
                for (i = 0; i < qVector.size(); ++i) {
                    FindQualifier qualifier = (FindQualifier)qVector.elementAt(i);
                    String qValue = qualifier.getValue();
                    if (qValue.equals("exactNameMatch") || qValue.equals("caseSensitiveMatch") || qValue.equals("orAllKeys") || qValue.equals("orLikeKeys") || qValue.equals("andAllKeys") || qValue.equals("sortByNameAsc") || qValue.equals("sortByNameDesc") || qValue.equals("sortByDateAsc") || qValue.equals("sortByDateDesc") || qValue.equals("serviceSubset") || qValue.equals("combineCategoryBags")) continue;
                    throw new UnsupportedException("find_tModel: findQualifier=" + qValue);
                }
            }
            Vector<TModelInfo> infoVector = null;
            boolean truncatedResults = false;
            Vector keyVector = dataStore.findTModel(tModelName, categoryBag, identifierBag, qualifiers);
            if (keyVector != null && keyVector.size() > 0) {
                int rowCount = keyVector.size();
                if (maxRows > 0 && maxRows < rowCount) {
                    rowCount = maxRows;
                    truncatedResults = true;
                }
                infoVector = new Vector<TModelInfo>(rowCount);
                for (int i2 = 0; i2 < rowCount; ++i2) {
                    infoVector.addElement(dataStore.fetchTModelInfo((String)keyVector.elementAt(i2)));
                }
            }
            dataStore.commit();
            TModelInfos infos = new TModelInfos();
            infos.setTModelInfoVector(infoVector);
            TModelList list = new TModelList();
            list.setGeneric(generic);
            list.setTModelInfos(infos);
            list.setOperator(Config.getOperator());
            list.setTruncated(truncatedResults);
            TModelList tModelList = list;
            return tModelList;
        }
        catch (NameTooLongException ntlex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ntlex.getMessage());
            throw ntlex;
        }
        catch (UnsupportedException suppex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)suppex.getMessage());
            throw suppex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

