/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.bytecode.javassist.AccessOptimizerAdapter;
import org.hibernate.bytecode.javassist.BulkAccessor;
import org.hibernate.bytecode.javassist.BulkAccessorException;
import org.hibernate.bytecode.javassist.FastClass;
import org.hibernate.bytecode.javassist.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.javassist.JavassistClassTransformer;
import org.hibernate.bytecode.javassist.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.javassist.ReflectionOptimizerImpl;
import org.hibernate.bytecode.javassist.TransformingClassLoader;
import org.hibernate.util.StringHelper;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final Log log = LogFactory.getLog((Class)BytecodeProviderImpl.class);

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        BulkAccessor bulkAccessor;
        FastClass fastClass;
        try {
            fastClass = FastClass.create(clazz);
            bulkAccessor = BulkAccessor.create(clazz, getterNames, setterNames, types);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                if (fastClass == null) {
                    bulkAccessor = null;
                } else {
                    Object instance = fastClass.newInstance();
                    bulkAccessor.setPropertyValues(instance, bulkAccessor.getPropertyValues(instance));
                }
            }
        }
        catch (Throwable t) {
            int index;
            fastClass = null;
            bulkAccessor = null;
            String message = "reflection optimizer disabled for: " + clazz.getName() + " [" + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage();
            if (t instanceof BulkAccessorException && (index = ((BulkAccessorException)t).getIndex()) >= 0) {
                message = message + " (property " + setterNames[index] + ")";
            }
            log.debug((Object)message);
        }
        if (fastClass != null && bulkAccessor != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkAccessor, clazz));
        }
        return null;
    }

    public ClassLoader generateDynamicFieldInterceptionClassLoader(ClassLoader parent, String[] classpath, String[] packages) {
        return new TransformingClassLoader(parent, classpath);
    }

    public ClassTransformer getEntityClassTransformer(String[] packages, String[] classes) {
        return new JavassistClassTransformer(packages, classes);
    }

    public void releaseDynamicFieldInterceptionClassLoader(ClassLoader classLoader) {
        if (!TransformingClassLoader.class.isAssignableFrom(classLoader.getClass())) {
            return;
        }
        ((TransformingClassLoader)classLoader).release();
    }
}

