/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.SimpleConnectionHandle;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class OpenJpaDialect
extends DefaultJpaDialect {
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        Connection connection = (Connection)this.getOpenJPAEntityManager(entityManager).getConnection();
        return new SimpleConnectionHandle(connection);
    }

    public void releaseJdbcConnection(ConnectionHandle conHandle, EntityManager em) throws PersistenceException, SQLException {
        if (conHandle != null && conHandle.getConnection() != null) {
            conHandle.getConnection().close();
        }
    }

    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        super.beginTransaction(entityManager, definition);
        if (!definition.isReadOnly()) {
            this.getOpenJPAEntityManager(entityManager).beginStore();
        }
        return null;
    }

    protected OpenJPAEntityManager getOpenJPAEntityManager(EntityManager em) {
        return (OpenJPAEntityManager)em;
    }
}

