/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

public class ArrayType
extends OpenType
implements Serializable {
    private int dimension = 0;
    private OpenType elementType = null;
    private transient int cachedHashCode = 0;
    private transient String cachedToString = null;
    private static final long serialVersionUID = 720504429830309770L;

    public ArrayType(int dimension, OpenType elementType) throws OpenDataException {
        super(ArrayType.genName(dimension, elementType), ArrayType.genName(dimension, elementType), ArrayType.genDesc(dimension, elementType));
        this.dimension = dimension;
        this.elementType = elementType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementOpenType() {
        return this.elementType;
    }

    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (!clazz.isArray()) {
            return false;
        }
        if (this.elementType instanceof SimpleType) {
            return this.getClassName().equals(clazz.getName());
        }
        if (this.elementType instanceof TabularType || this.elementType instanceof CompositeType) {
            Class<?> thisClass = null;
            try {
                thisClass = Thread.currentThread().getContextClassLoader().loadClass(this.getClassName());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (!thisClass.isAssignableFrom(clazz)) {
                return false;
            }
            return this.recursiveCheck((Object[])obj, this.dimension);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)obj;
        return this.getDimension() == other.getDimension() && this.getElementOpenType().equals(other.getElementOpenType());
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getDimension() + this.getElementOpenType().hashCode();
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuffer buffer = new StringBuffer(ArrayType.class.getName());
        buffer.append("\n");
        buffer.append(this.getTypeName());
        buffer.append("\n");
        buffer.append(new Integer(this.dimension));
        buffer.append("-dimensional array of\n");
        buffer.append(this.elementType);
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }

    private static String genName(int dimension, OpenType elementType) throws OpenDataException {
        if (dimension < 1) {
            throw new IllegalArgumentException("negative dimension");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("null element type");
        }
        if (elementType instanceof ArrayType) {
            throw new OpenDataException("array type cannot be an element of an array type");
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < dimension; ++i) {
            buffer.append('[');
        }
        buffer.append('L');
        buffer.append(elementType.getClassName());
        buffer.append(';');
        return buffer.toString();
    }

    private static String genDesc(int dimension, OpenType elementType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new Integer(dimension));
        buffer.append("-dimension array of ");
        buffer.append(elementType.getClassName());
        return buffer.toString();
    }

    private boolean recursiveCheck(Object[] elements, int dimension) {
        if (dimension == 1) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null || this.elementType.isValue(elements[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                if (this.recursiveCheck((Object[])elements[i], dimension - 1)) continue;
                return false;
            }
        }
        return true;
    }
}

