/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testing.core.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.drools.testing.core.beans.Field;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;

public abstract class FactType
implements Serializable {
    private int _id;
    private boolean _has_id;
    private String _type;
    private List _fieldList = new ArrayList();

    public void addField(Field vField) throws IndexOutOfBoundsException {
        this._fieldList.add(vField);
    }

    public void addField(int index, Field vField) throws IndexOutOfBoundsException {
        this._fieldList.add(index, vField);
    }

    public void deleteId() {
        this._has_id = false;
    }

    public Enumeration enumerateField() {
        return Collections.enumeration(this._fieldList);
    }

    public Field getField(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._fieldList.size()) {
            throw new IndexOutOfBoundsException("getField: Index value '" + index + "' not in range [0.." + (this._fieldList.size() - 1) + "]");
        }
        return (Field)this._fieldList.get(index);
    }

    public Field[] getField() {
        int size = this._fieldList.size();
        Field[] array = new Field[size];
        for (int index = 0; index < size; ++index) {
            array[index] = (Field)this._fieldList.get(index);
        }
        return array;
    }

    public int getFieldCount() {
        return this._fieldList.size();
    }

    public int getId() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public boolean hasId() {
        return this._has_id;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateField() {
        return this._fieldList.iterator();
    }

    public void removeAllField() {
        this._fieldList.clear();
    }

    public boolean removeField(Field vField) {
        boolean removed = this._fieldList.remove(vField);
        return removed;
    }

    public Field removeFieldAt(int index) {
        Object obj = this._fieldList.remove(index);
        return (Field)obj;
    }

    public void setField(int index, Field vField) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._fieldList.size()) {
            throw new IndexOutOfBoundsException("setField: Index value '" + index + "' not in range [0.." + (this._fieldList.size() - 1) + "]");
        }
        this._fieldList.set(index, vField);
    }

    public void setField(Field[] vFieldArray) {
        this._fieldList.clear();
        for (int i = 0; i < vFieldArray.length; ++i) {
            this._fieldList.add(vFieldArray[i]);
        }
    }

    public void setId(int id) {
        this._id = id;
        this._has_id = true;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

