/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.seam.mail.ui.UIMessage;
import org.jboss.seam.ui.JSF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailComponent
extends UIComponentBase {
    private static final String FAMILY = "org.jboss.seam.mail";

    public String getFamily() {
        return FAMILY;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String encode(FacesContext facesContext) throws IOException {
        return this.encode(facesContext, (UIComponent)this);
    }

    protected String encode(FacesContext facesContext, UIComponent cmp) throws IOException {
        ResponseWriter response = facesContext.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        ResponseWriter cachingResponseWriter = response.cloneWithWriter((Writer)stringWriter);
        facesContext.setResponseWriter(cachingResponseWriter);
        JSF.renderChildren((FacesContext)facesContext, (UIComponent)cmp);
        facesContext.setResponseWriter(response);
        String output = stringWriter.getBuffer().toString();
        return output;
    }

    public MimeMessage findMimeMessage() throws MessagingException {
        UIMessage parent = (UIMessage)this.findParent((UIComponent)this, UIMessage.class);
        if (parent != null) {
            return parent.getMimeMessage();
        }
        return null;
    }

    public MimeMultipart getRootMultipart() throws IOException, MessagingException {
        return (MimeMultipart)this.findMimeMessage().getContent();
    }

    public MailComponent findParent(UIComponent parent) {
        return this.findParent(parent, null);
    }

    public MailComponent findParent(UIComponent parent, Class<?> c) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof MailComponent && (c == null || c.isAssignableFrom(parent.getClass()))) {
            return (MailComponent)parent;
        }
        return this.findParent(parent.getParent(), c);
    }

    protected String getString(String localName) {
        if (this.getValue(localName) != null) {
            return this.getValue(localName).toString();
        }
        return null;
    }

    protected Object getValue(String localName) {
        if (this.getValueBinding(localName) == null) {
            return null;
        }
        return this.getValueBinding(localName).getValue(this.getFacesContext());
    }

    protected Boolean getBoolean(String localName) {
        Object o = this.getValue(localName);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.valueOf(o.toString());
        }
        return null;
    }
}

