/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PredicateHandler
extends BaseAbstractHandler
implements Handler {
    PredicateHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(PatternDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(FieldConstraintDescr.class);
            this.validPeers.add(PredicateDescr.class);
            this.validPeers.add(FieldBindingDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        PredicateDescr predicateDescr = new PredicateDescr();
        return predicateDescr;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        PredicateDescr predicateDescr = (PredicateDescr)this.xmlPackageReader.getCurrent();
        String expression = config.getText();
        if (expression == null || expression.trim().equals("")) {
            throw new SAXParseException("<predicate> must have some content", this.xmlPackageReader.getLocator());
        }
        predicateDescr.setContent(expression);
        LinkedList parents = this.xmlPackageReader.getParents();
        ListIterator it = parents.listIterator(parents.size());
        it.previous();
        PatternDescr patternDescr = (PatternDescr)it.previous();
        patternDescr.addConstraint(predicateDescr);
        return null;
    }

    public Class generateNodeFor() {
        return PredicateDescr.class;
    }
}

