/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.mvel.ExpressionCompiler;
import org.mvel.ParserContext;

public class MVELExprAnalyzer {
    public MVELAnalysisResult analyzeExpression(RuleBuildContext context, String expr, Set[] availableIdentifiers, Map localTypes) throws RecognitionException {
        MVELAnalysisResult result = null;
        if (expr.trim().length() > 0) {
            ExpressionCompiler compiler = new ExpressionCompiler(expr);
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            ParserContext parserContext = new ParserContext(dialect.getImports(), null, context.getPkg().getName() + "." + context.getRuleDescr().getClassName());
            if (dialect.getPackgeImports() != null && !dialect.getPackgeImports().isEmpty()) {
                Iterator it = dialect.getPackgeImports().values().iterator();
                while (it.hasNext()) {
                    String packageImport = (String)it.next();
                    parserContext.addPackageImport(packageImport);
                }
            }
            parserContext.setStrictTypeEnforcement(false);
            parserContext.setInterceptors(dialect.getInterceptors());
            compiler.compile(parserContext);
            result = this.analyze(compiler.getParserContextState().getInputs().keySet(), availableIdentifiers);
            result.setMvelVariables(compiler.getParserContextState().getVariables());
        } else {
            result = this.analyze(Collections.EMPTY_SET, availableIdentifiers);
            result.setMvelVariables(new HashMap());
        }
        return result;
    }

    private MVELAnalysisResult analyze(Set identifiers, Set[] availableIdentifiers) throws RecognitionException {
        int i;
        MVELAnalysisResult result = new MVELAnalysisResult();
        result.setIdentifiers(new ArrayList(identifiers));
        HashSet notBound = new HashSet(identifiers);
        List[] used = new List[availableIdentifiers.length];
        int length = used.length;
        for (i = 0; i < length; ++i) {
            used[i] = new ArrayList();
        }
        length = availableIdentifiers.length;
        for (i = 0; i < length; ++i) {
            Set set = availableIdentifiers[i];
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String eachDecl = (String)it.next();
                if (!identifiers.contains(eachDecl)) continue;
                used[i].add(eachDecl);
                notBound.remove(eachDecl);
            }
        }
        result.setBoundIdentifiers(used);
        result.setNotBoundedIdentifiers(new ArrayList(notBound));
        return result;
    }
}

