/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ModifyInterceptor;
import org.drools.base.TypeResolver;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.commons.jci.readers.MemoryResourceReader;
import org.drools.compiler.Dialect;
import org.drools.compiler.ImportError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.CollectBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.ForallBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAccumulateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialectConfiguration;
import org.drools.rule.builder.dialect.mvel.MVELEvalBuilder;
import org.drools.rule.builder.dialect.mvel.MVELExprAnalyzer;
import org.drools.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.rule.builder.dialect.mvel.MVELPredicateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueBuilder;
import org.drools.rule.builder.dialect.mvel.MVELRuleClassBuilder;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.spi.KnowledgeHelper;
import org.drools.util.StringUtils;
import org.mvel.AbstractParser;
import org.mvel.CompiledExpression;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.ParserContext;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ParseTools;

public class MVELDialect
implements Dialect {
    public static final String ID = "mvel";
    private static final String EXPRESSION_DIALECT_NAME = "MVEL";
    private final MVELRuleClassBuilder rule = new MVELRuleClassBuilder();
    private final PatternBuilder pattern = new PatternBuilder();
    private final QueryBuilder query = new QueryBuilder();
    private final MVELAccumulateBuilder accumulate = new MVELAccumulateBuilder();
    private final SalienceBuilder salience = new MVELSalienceBuilder();
    private final MVELEvalBuilder eval = new MVELEvalBuilder();
    private final MVELPredicateBuilder predicate = new MVELPredicateBuilder();
    private final MVELReturnValueBuilder returnValue = new MVELReturnValueBuilder();
    private final MVELConsequenceBuilder consequence = new MVELConsequenceBuilder();
    private final MVELFromBuilder from = new MVELFromBuilder();
    private final JavaFunctionBuilder function = new JavaFunctionBuilder();
    private final CollectBuilder collect = new CollectBuilder();
    private final ForallBuilder forall = new ForallBuilder();
    private Map interceptors;
    private List results;
    private MemoryResourceReader src;
    private Package pkg;
    private MVELDialectConfiguration configuration;
    private TypeResolver typeResolver;
    private ClassFieldExtractorCache classFieldExtractorCache;
    private MVELExprAnalyzer analyzer;
    private Map imports;
    private Map packageImports;
    private boolean strictMode;
    private static Boolean languageSet = new Boolean(false);
    private Map builders;

    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        throw new UnsupportedOperationException("MVEL does not support functions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLanguageLevel(int level) {
        Boolean bl = languageSet;
        synchronized (bl) {
            if (!languageSet.booleanValue()) {
                languageSet = new Boolean(true);
                AbstractParser.setLanguageLevel((int)level);
            }
        }
    }

    public void init(PackageBuilder builder) {
        MVELDialect.setLanguageLevel(4);
        this.pkg = builder.getPackage();
        this.configuration = (MVELDialectConfiguration)builder.getPackageBuilderConfiguration().getDialectConfiguration(ID);
        this.typeResolver = builder.getTypeResolver();
        this.classFieldExtractorCache = builder.getClassFieldExtractorCache();
        this.strictMode = this.configuration.isStrict();
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        MVEL.setThreadSafe((boolean)true);
        this.analyzer = new MVELExprAnalyzer();
        this.imports = new HashMap();
        this.packageImports = new HashMap();
        this.interceptors = new HashMap(1);
        this.interceptors.put("Modify", new ModifyInterceptor());
        this.results = new ArrayList();
        if (this.pkg != null) {
            this.init(this.pkg);
        }
        this.initBuilder();
    }

    public void initBuilder() {
        this.builders = new HashMap();
        GroupElementBuilder gebuilder = new GroupElementBuilder();
        this.builders.put(AndDescr.class, gebuilder);
        this.builders.put(OrDescr.class, gebuilder);
        this.builders.put(NotDescr.class, gebuilder);
        this.builders.put(ExistsDescr.class, gebuilder);
        this.builders.put(PatternDescr.class, this.getPatternBuilder());
        this.builders.put(FromDescr.class, this.getFromBuilder());
        this.builders.put(QueryDescr.class, this.getQueryBuilder());
        this.builders.put(AccumulateDescr.class, this.getAccumulateBuilder());
        this.builders.put(EvalDescr.class, this.getEvalBuilder());
        this.builders.put(CollectDescr.class, this.collect);
        this.builders.put(ForallDescr.class, this.forall);
        this.builders.put(FunctionDescr.class, this.function);
    }

    public void init(Package pkg) {
        this.pkg = pkg;
        this.results = new ArrayList();
        this.src = new MemoryResourceReader();
        if (this.pkg != null) {
            this.addImport(this.pkg.getName() + ".*");
        }
    }

    public void init(RuleDescr ruleDescr) {
        String pkgName = this.pkg == null ? "" : this.pkg.getName();
        String ruleClassName = JavaDialect.getUniqueLegalName(pkgName, ruleDescr.getName(), ID, this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
        ruleDescr.setDialect(this);
    }

    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    public void addRule(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        String name = this.pkg.getName() + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        context.getPkg().getPackageCompilationData().getLineMappings().put(name, mapping);
    }

    public void addImport(String importEntry) {
        if (importEntry.endsWith(".*")) {
            importEntry = importEntry.substring(0, importEntry.length() - 2);
            this.packageImports.put(importEntry, importEntry);
        } else {
            try {
                Class cls = this.typeResolver.resolveType(importEntry);
                this.imports.put(ParseTools.getSimpleClassName((Class)cls), cls);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new ImportError(importEntry, 1));
            }
        }
    }

    public Map getImports() {
        return this.imports;
    }

    public Map getPackgeImports() {
        return this.packageImports;
    }

    public void addStaticImport(String staticImportEntry) {
        if (staticImportEntry.endsWith("*")) {
            return;
        }
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        String methodName = staticImportEntry.substring(index + 1);
        try {
            Class<?> cls = this.pkg.getPackageCompilationData().getClassLoader().loadClass(className);
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                this.imports.put(methodName, methods[i]);
                break;
            }
        }
        catch (ClassNotFoundException e) {
            this.results.add(new ImportError(staticImportEntry, -1));
        }
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public void compileAll() {
    }

    public Dialect.AnalysisResult analyzeExpression(RuleBuildContext context, BaseDescr descr, Object content) {
        return this.analyzeExpression(context, descr, content, null);
    }

    public Dialect.AnalysisResult analyzeExpression(RuleBuildContext context, BaseDescr descr, Object content, Map localTypes) {
        MVELAnalysisResult result = null;
        try {
            result = this.analyzer.analyzeExpression(context, (String)content, new Set[]{context.getDeclarationResolver().getDeclarations().keySet(), context.getPkg().getGlobals().keySet()}, localTypes);
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), descr, null, "Unable to determine the used declarations.\n" + e.getMessage()));
        }
        return result;
    }

    public Dialect.AnalysisResult analyzeBlock(RuleBuildContext context, BaseDescr descr, String text) {
        return this.analyzeBlock(context, descr, null, text, null);
    }

    public Dialect.AnalysisResult analyzeBlock(RuleBuildContext context, BaseDescr descr, Map interceptors, String text, Map localTypes) {
        MVELAnalysisResult result = null;
        try {
            result = this.analyzer.analyzeExpression(context, text, new Set[]{context.getDeclarationResolver().getDeclarations().keySet(), context.getPkg().getGlobals().keySet()}, localTypes);
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), descr, e, "Unable to determine the used declarations.\n" + e.getMessage()));
        }
        return result;
    }

    public Serializable compile(String text, Dialect.AnalysisResult analysis, Map interceptors, Map outerDeclarations, RuleBuildContext context) {
        ParserContext parserContext = this.getParserContext(analysis, outerDeclarations, context);
        ExpressionCompiler compiler = new ExpressionCompiler(text.trim());
        if (MVELDebugHandler.isDebugMode()) {
            System.out.println("Source before MVEL Compilation:\n" + text.trim());
            compiler.setDebugSymbols(true);
        }
        CompiledExpression expr = compiler.compile(parserContext);
        return expr;
    }

    public ParserContext getParserContext(Dialect.AnalysisResult analysis, Map outerDeclarations, RuleBuildContext context) {
        Map.Entry entry;
        Iterator it;
        ParserContext parserContext = new ParserContext(this.imports, null, context.getPkg().getName() + "." + context.getRuleDescr().getClassName());
        Iterator it2 = this.packageImports.values().iterator();
        while (it2.hasNext()) {
            String packageImport = (String)it2.next();
            parserContext.addPackageImport(packageImport);
        }
        parserContext.setStrictTypeEnforcement(this.strictMode);
        if (this.interceptors != null) {
            parserContext.setInterceptors(this.interceptors);
        }
        List[] list = analysis.getBoundIdentifiers();
        DeclarationScopeResolver resolver = context.getDeclarationResolver();
        Iterator it3 = list[0].iterator();
        while (it3.hasNext()) {
            String identifier = (String)it3.next();
            Class cls = resolver.getDeclaration(identifier).getExtractor().getExtractToClass();
            parserContext.addInput(identifier, cls);
        }
        Map globalTypes = context.getPkg().getGlobals();
        Iterator it4 = list[1].iterator();
        while (it4.hasNext()) {
            String identifier = (String)it4.next();
            parserContext.addInput(identifier, (Class)globalTypes.get(identifier));
        }
        Map mvelVars = ((MVELAnalysisResult)analysis).getMvelVariables();
        if (mvelVars != null) {
            it = mvelVars.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                parserContext.addInput((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        if (outerDeclarations != null) {
            it = outerDeclarations.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                parserContext.addInput((String)entry.getKey(), ((Declaration)entry.getValue()).getExtractor().getExtractToClass());
            }
        }
        parserContext.addInput("drools", KnowledgeHelper.class);
        return parserContext;
    }

    public RuleConditionBuilder getBuilder(Class clazz) {
        return (RuleConditionBuilder)this.builders.get(clazz);
    }

    public Map getBuilders() {
        return this.builders;
    }

    public ClassFieldExtractorCache getClassFieldExtractorCache() {
        return this.classFieldExtractorCache;
    }

    public PatternBuilder getPatternBuilder() {
        return this.pattern;
    }

    public QueryBuilder getQueryBuilder() {
        return this.query;
    }

    public AccumulateBuilder getAccumulateBuilder() {
        return this.accumulate;
    }

    public ConsequenceBuilder getConsequenceBuilder() {
        return this.consequence;
    }

    public RuleConditionBuilder getEvalBuilder() {
        return this.eval;
    }

    public FromBuilder getFromBuilder() {
        return this.from;
    }

    public PredicateBuilder getPredicateBuilder() {
        return this.predicate;
    }

    public PredicateBuilder getExpressionPredicateBuilder() {
        return this.predicate;
    }

    public SalienceBuilder getSalienceBuilder() {
        return this.salience;
    }

    public List getResults() {
        return this.results;
    }

    public ReturnValueBuilder getReturnValueBuilder() {
        return this.returnValue;
    }

    public RuleClassBuilder getRuleClassBuilder() {
        return this.rule;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public Map getInterceptors() {
        return this.interceptors;
    }

    public String getId() {
        return ID;
    }
}

