/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DroolsError;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Rule;

public class RuleError
extends DroolsError {
    private Rule rule;
    private BaseDescr descr;
    private Object object;
    private String message;
    private int[] errorLines = new int[0];

    public RuleError(Rule rule, BaseDescr descr, Object object, String message) {
        this.rule = rule;
        this.descr = descr;
        this.object = object;
        this.message = message;
    }

    public Rule getRule() {
        return this.rule;
    }

    public BaseDescr getDescr() {
        return this.descr;
    }

    public Object getObject() {
        return this.object;
    }

    public int[] getErrorLines() {
        return this.errorLines;
    }

    public int getLine() {
        return this.descr != null ? this.descr.getLine() : -1;
    }

    public String getMessage() {
        String summary = this.message;
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] problem = (CompilationProblem[])this.object;
            for (int i = 0; i < problem.length; ++i) {
                summary = i != 0 ? summary + "\n" + problem[i].getMessage() : summary + " " + problem[i].getMessage();
            }
        }
        return summary;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.message);
        buf.append(" : ");
        buf.append(this.rule);
        buf.append("\n");
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] problem = (CompilationProblem[])this.object;
            for (int i = 0; i < problem.length; ++i) {
                buf.append("\t");
                buf.append(problem[i]);
                buf.append("\n");
            }
        } else if (this.object != null) {
            buf.append(this.object);
        }
        return buf.toString();
    }
}

