/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.struts;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.samples.jpetstore.domain.Account;
import org.springframework.samples.jpetstore.web.struts.BaseActionForm;

public class AccountActionForm
extends BaseActionForm {
    public static final String VALIDATE_EDIT_ACCOUNT = "editAccount";
    public static final String VALIDATE_NEW_ACCOUNT = "newAccount";
    private static final ArrayList LANGUAGE_LIST = new ArrayList();
    private String username;
    private String password;
    private String repeatedPassword;
    private List languages = LANGUAGE_LIST;
    private List categories;
    private String validate;
    private String forwardAction;
    private Account account;
    private PagedListHolder myList;

    public PagedListHolder getMyList() {
        return this.myList;
    }

    public void setMyList(PagedListHolder myList) {
        this.myList = myList;
    }

    public String getForwardAction() {
        return this.forwardAction;
    }

    public void setForwardAction(String forwardAction) {
        this.forwardAction = forwardAction;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRepeatedPassword() {
        return this.repeatedPassword;
    }

    public void setRepeatedPassword(String repeatedPassword) {
        this.repeatedPassword = repeatedPassword;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public List getLanguages() {
        return this.languages;
    }

    public void setLanguages(List languages) {
        this.languages = languages;
    }

    public List getCategories() {
        return this.categories;
    }

    public void setCategories(List categories) {
        this.categories = categories;
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public void doValidate(ActionMapping mapping, HttpServletRequest request, List errors) {
        if (this.validate != null && (VALIDATE_EDIT_ACCOUNT.equals(this.validate) || VALIDATE_NEW_ACCOUNT.equals(this.validate))) {
            if (VALIDATE_NEW_ACCOUNT.equals(this.validate)) {
                this.account.setStatus("OK");
                this.addErrorIfStringEmpty(errors, "User ID is required.", this.account.getUsername());
                if (this.account.getPassword() == null || this.account.getPassword().length() < 1 || !this.account.getPassword().equals(this.repeatedPassword)) {
                    errors.add("Passwords did not match or were not provided.  Matching passwords are required.");
                }
            }
            if (this.account.getPassword() != null && this.account.getPassword().length() > 0 && !this.account.getPassword().equals(this.repeatedPassword)) {
                errors.add("Passwords did not match.");
            }
            this.addErrorIfStringEmpty(errors, "First name is required.", this.account.getFirstName());
            this.addErrorIfStringEmpty(errors, "Last name is required.", this.account.getLastName());
            this.addErrorIfStringEmpty(errors, "Email address is required.", this.account.getEmail());
            this.addErrorIfStringEmpty(errors, "Phone number is required.", this.account.getPhone());
            this.addErrorIfStringEmpty(errors, "Address (1) is required.", this.account.getAddress1());
            this.addErrorIfStringEmpty(errors, "City is required.", this.account.getCity());
            this.addErrorIfStringEmpty(errors, "State is required.", this.account.getState());
            this.addErrorIfStringEmpty(errors, "ZIP is required.", this.account.getZip());
            this.addErrorIfStringEmpty(errors, "Country is required.", this.account.getCountry());
        }
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.setUsername(null);
        this.setPassword(null);
        this.setRepeatedPassword(null);
    }

    static {
        LANGUAGE_LIST.add("english");
        LANGUAGE_LIST.add("japanese");
    }
}

