/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.samples.jpetstore.domain.CartItem;
import org.springframework.samples.jpetstore.domain.Item;

public class Cart
implements Serializable {
    private final Map itemMap = Collections.synchronizedMap(new HashMap());
    private final PagedListHolder itemList = new PagedListHolder();

    public Cart() {
        this.itemList.setPageSize(4);
    }

    public Iterator getAllCartItems() {
        return this.itemList.getSource().iterator();
    }

    public PagedListHolder getCartItemList() {
        return this.itemList;
    }

    public int getNumberOfItems() {
        return this.itemList.getSource().size();
    }

    public boolean containsItemId(String itemId) {
        return this.itemMap.containsKey(itemId);
    }

    public void addItem(Item item, boolean isInStock) {
        CartItem cartItem = (CartItem)this.itemMap.get(item.getItemId());
        if (cartItem == null) {
            cartItem = new CartItem();
            cartItem.setItem(item);
            cartItem.setQuantity(0);
            cartItem.setInStock(isInStock);
            this.itemMap.put(item.getItemId(), cartItem);
            this.itemList.getSource().add(cartItem);
        }
        cartItem.incrementQuantity();
    }

    public Item removeItemById(String itemId) {
        CartItem cartItem = (CartItem)this.itemMap.remove(itemId);
        if (cartItem == null) {
            return null;
        }
        this.itemList.getSource().remove(cartItem);
        return cartItem.getItem();
    }

    public void incrementQuantityByItemId(String itemId) {
        CartItem cartItem = (CartItem)this.itemMap.get(itemId);
        cartItem.incrementQuantity();
    }

    public void setQuantityByItemId(String itemId, int quantity) {
        CartItem cartItem = (CartItem)this.itemMap.get(itemId);
        cartItem.setQuantity(quantity);
    }

    public double getSubTotal() {
        double subTotal = 0.0;
        Iterator items = this.getAllCartItems();
        while (items.hasNext()) {
            CartItem cartItem = (CartItem)items.next();
            Item item = cartItem.getItem();
            double listPrice = item.getListPrice();
            int quantity = cartItem.getQuantity();
            subTotal += listPrice * (double)quantity;
        }
        return subTotal;
    }
}

