/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jboss.invocation.MarshalledValueInputStream;

class StateTransferIntegrator_1241
implements StateTransferIntegrator {
    private static final int HEADER_LENGTH = 20;
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private TreeCache cache;
    private Fqn targetFqn;
    private byte[] state;
    private int transientSize;
    private int associatedSize;
    private int persistentSize;
    private boolean transientSet;
    private NodeFactory factory;
    private byte nodeType;

    StateTransferIntegrator_1241(byte[] state, Fqn targetFqn, TreeCache cache) throws Exception {
        this.targetFqn = targetFqn;
        this.cache = cache;
        this.state = state;
        this.factory = NodeFactory.getInstance();
        this.nodeType = (byte)(cache.isNodeLockingOptimistic() ? 3 : 1);
        ByteArrayInputStream bais = new ByteArrayInputStream(state);
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)bais);
        in.readShort();
        this.transientSize = in.readInt();
        this.associatedSize = in.readInt();
        this.persistentSize = in.readInt();
        in.close();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("transient state: " + this.transientSize + " bytes"));
            this.log.trace((Object)("associated state: " + this.associatedSize + " bytes"));
            this.log.trace((Object)("persistent state: " + this.persistentSize + " bytes"));
        }
    }

    private byte[] readState(ObjectInputStream state) throws IOException {
        byte[] result = null;
        int size = state.readInt();
        if (size > 0) {
            result = new byte[size];
            state.readFully(result, 0, size);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrateTransientState(DataNode target, ClassLoader cl) throws Exception {
        if (this.transientSize > 0) {
            ClassLoader oldCL = null;
            try {
                if (cl != null) {
                    oldCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("integrating transient state for " + target));
                }
                this.integrateTransientState(target);
                this.transientSet = true;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("transient state successfully integrated for " + this.targetFqn));
                }
                this.integrateAssociatedState();
            }
            finally {
                if (!this.transientSet) {
                    target.clear();
                    target.removeAllChildren();
                }
                if (oldCL != null) {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void integrateAssociatedState() throws Exception {
        if (this.associatedSize > 0 && this.cache instanceof TreeCacheAop) {
            Node refMapNode = this.cache.get(InternalDelegate.JBOSS_INTERNAL_MAP);
            ByteArrayInputStream in_stream = new ByteArrayInputStream(this.state, 20 + this.transientSize, this.associatedSize);
            MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
            try {
                Object[] nameValue;
                while ((nameValue = (Object[])in.readObject()) != null) {
                    void var4_4;
                    TreeNode target = refMapNode.getChild(var4_4[0]);
                    if (target == null) {
                        Fqn fqn = new Fqn(InternalDelegate.JBOSS_INTERNAL_MAP, var4_4[0]);
                        target = this.factory.createDataNode(this.nodeType, var4_4[0], fqn, refMapNode, null, true, this.cache);
                        refMapNode.addChild(var4_4[0], target);
                    }
                    target.put(var4_4[0], var4_4[1]);
                }
            }
            catch (EOFException eof) {
                // empty catch block
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("associated state successfully integrated for " + this.targetFqn));
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("No need to integrate associated state for " + this.targetFqn));
        }
    }

    public void integratePersistentState() throws Exception {
        if (this.persistentSize > 0) {
            CacheLoader loader = this.cache.getCacheLoader();
            if (loader == null) {
                this.log.error((Object)"cache loader is null, cannot set persistent state");
            } else if (this.targetFqn.size() == 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state");
                }
                byte[] persistentState = this.getPersistentState();
                loader.storeEntireState(persistentState);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state was successful");
                }
            } else if (loader instanceof ExtendedCacheLoader) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state");
                }
                byte[] persistentState = this.getPersistentState();
                ((ExtendedCacheLoader)loader).storeState(persistentState, this.targetFqn);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state was successful");
                }
            } else {
                this.log.error((Object)"cache loader does not implement ExtendedCacheLoader, cannot set persistent state");
            }
        }
    }

    private void integrateTransientState(DataNode target) throws IOException, ClassNotFoundException {
        target.removeAllChildren();
        ByteArrayInputStream in_stream = new ByteArrayInputStream(this.state, 20, this.transientSize);
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
        NodeData nd = (NodeData)in.readObject();
        Map attrs = nd.getAttributes();
        if (attrs != null) {
            target.put(attrs, true);
        } else {
            target.clear();
        }
        this.integrateStateTransferChildren(target, (ObjectInputStream)in);
        in.close();
    }

    private NodeData integrateStateTransferChildren(DataNode parent, ObjectInputStream in) throws IOException, ClassNotFoundException {
        int parent_level = parent.getFqn().size();
        int target_level = parent_level + 1;
        try {
            NodeData nd = (NodeData)in.readObject();
            while (nd != null) {
                Fqn fqn = nd.getFqn();
                int size = fqn.size();
                if (size <= parent_level) {
                    return nd;
                }
                if (size > target_level) {
                    throw new IllegalStateException("NodeData " + fqn + " is not a direct child of " + parent.getFqn());
                }
                Object name = fqn.get(size - 1);
                DataNode target = this.factory.createDataNode(this.nodeType, name, fqn, parent, nd.getAttributes(), true, this.cache);
                parent.addChild(name, target);
                nd = this.integrateStateTransferChildren(target, in);
            }
        }
        catch (EOFException eof) {}
        return null;
    }

    private byte[] getPersistentState() {
        byte[] result = new byte[this.persistentSize];
        System.arraycopy(this.state, 20 + this.transientSize + this.associatedSize, result, 0, this.persistentSize);
        return result;
    }
}

