/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.OptimisticMap;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.logging.Logger;

public class WorkspaceNodeImpl
implements WorkspaceNode {
    private static transient Logger log = Logger.getLogger((Class)(class$org$jboss$cache$optimistic$WorkspaceNodeImpl == null ? (class$org$jboss$cache$optimistic$WorkspaceNodeImpl = WorkspaceNodeImpl.class$("org.jboss.cache.optimistic.WorkspaceNodeImpl")) : class$org$jboss$cache$optimistic$WorkspaceNodeImpl));
    private DataNode node;
    private TransactionWorkspace workspace;
    private boolean dirty = false;
    private long version = 0L;
    private boolean deleted;
    private List childrenInWorkspace = new ArrayList();
    private Fqn fqn;
    private boolean created;
    private Map optimisticChildNodeMap = new OptimisticMap();
    private Map optimisticDataMap = new OptimisticMap();
    static /* synthetic */ Class class$org$jboss$cache$optimistic$WorkspaceNodeImpl;

    public boolean isDirty() {
        return this.dirty;
    }

    public WorkspaceNodeImpl() {
    }

    public WorkspaceNodeImpl(TreeNode node, TransactionWorkspace workspace) {
        this.node = (DataNode)node;
        this.workspace = workspace;
        this.optimisticDataMap = new OptimisticMap(node.getData());
        this.optimisticChildNodeMap = node.getChildren() == null ? new OptimisticMap() : new OptimisticMap(node.getChildren());
        this.version = ((OptimisticTreeNode)node).getVersion() + 1L;
        this.fqn = node.getFqn();
    }

    public WorkspaceNodeImpl(DataNode node, TransactionWorkspace workspace) {
        this.node = node;
        this.workspace = workspace;
        this.optimisticDataMap = new OptimisticMap(node.getData());
        this.optimisticChildNodeMap = node.getChildren() == null ? new OptimisticMap() : new OptimisticMap(node.getChildren());
        this.version = ((OptimisticTreeNode)node).getVersion() + 1L;
        this.fqn = node.getFqn();
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void put(Map data, boolean eraseData) {
        this.realPut(data, eraseData);
        this.dirty = true;
    }

    public void put(Map data) {
        this.realPut(data, false);
        this.dirty = true;
    }

    public Object put(Object key, Object value) {
        this.dirty = true;
        return this.optimisticDataMap.put(key, value);
    }

    public Object remove(Object key) {
        this.dirty = true;
        return this.optimisticDataMap.remove(key);
    }

    public void clear() {
        this.optimisticDataMap.clear();
        this.dirty = true;
    }

    public Object get(Object key) {
        return this.optimisticDataMap.get(key);
    }

    public Set getKeys() {
        return this.optimisticDataMap.keySet();
    }

    public Set getChildrenNames() {
        HashSet set = new HashSet();
        set.addAll(this.optimisticChildNodeMap.keySet());
        return set;
    }

    private void realPut(Map data, boolean eraseData) {
        this.realPut(data, eraseData, true);
    }

    private void realPut(Map data, boolean eraseData, boolean forceDirtyFlag) {
        if (forceDirtyFlag) {
            this.dirty = true;
        }
        if (eraseData) {
            this.optimisticDataMap.clear();
        }
        this.optimisticDataMap.putAll(data);
    }

    public void removeChild(Object childName) {
        this.dirty = true;
        this.optimisticChildNodeMap.remove(childName);
    }

    public TreeNode getParent() {
        return this.node.getParent();
    }

    public TreeNode getWrappedParent() {
        WorkspaceNode workspaceNode = this.workspace.getNode(this.node.getParent().getFqn());
        if (workspaceNode == null) {
            workspaceNode = NodeFactory.getInstance().createWorkspaceNode(this.node.getParent(), this.workspace);
            this.workspace.addNode(workspaceNode);
        }
        return workspaceNode;
    }

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent) {
        if (child_name == null) {
            return null;
        }
        TreeNode child = (TreeNode)this.optimisticChildNodeMap.get(child_name);
        if (child == null) {
            child = NodeFactory.getInstance().createNodeOfType(parent, child_name, fqn, parent, null, null);
            this.optimisticChildNodeMap.put(child_name, child);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("createChild: fqn=").append(fqn).append(", child_name=").append(child_name));
        }
        this.dirty = true;
        return child;
    }

    public TreeNode getChild(Object childName) {
        return (TreeNode)this.optimisticChildNodeMap.get(childName);
    }

    public TreeNode getWrappedChild(Object fqn) {
        DataNode temp;
        WorkspaceNode wrapper = this.workspace.getNode((Fqn)fqn);
        if (wrapper == null && (temp = (DataNode)this.optimisticChildNodeMap.get(fqn)) != null) {
            wrapper = new WorkspaceNodeImpl(temp, this.workspace);
            this.workspace.addNode(wrapper);
            this.childrenInWorkspace.add(wrapper);
        }
        return wrapper;
    }

    public DataNode getNode() {
        return this.node;
    }

    public long getVersion() {
        return this.version;
    }

    public Map getMergedChildren() {
        return this.mergeMaps((OptimisticMap)this.optimisticChildNodeMap);
    }

    private Map mergeMaps(OptimisticMap opMap) {
        HashMap temp = new HashMap();
        temp.putAll(opMap.getOriginalMap());
        Iterator it = opMap.getRemovedMap().keySet().iterator();
        while (it.hasNext()) {
            temp.remove(it.next());
        }
        Iterator it2 = opMap.getLocalMap().entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            temp.put(entry.getKey(), entry.getValue());
        }
        return temp;
    }

    public Map getMergedData() {
        return this.mergeMaps((OptimisticMap)this.optimisticDataMap);
    }

    public void markAsDeleted() {
        this.deleted = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Object getName() {
        return this.node.getName();
    }

    public TransactionWorkspace getTransactionWorkspace() {
        return this.workspace;
    }

    public boolean isDeepDirty() {
        boolean deepDirty = this.dirty;
        Iterator it = this.childrenInWorkspace.iterator();
        while (!deepDirty && it.hasNext()) {
            WorkspaceNode child = (WorkspaceNode)it.next();
            deepDirty = child.isDirty();
        }
        return deepDirty;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void markAsCreated() {
        this.created = true;
        this.dirty = true;
    }

    public Map getData() {
        return null;
    }

    public Map getChildren() {
        return null;
    }

    public boolean containsKey(Object key) {
        return false;
    }

    public Set getDataKeys() {
        return null;
    }

    public boolean childExists(Object child_name) {
        return false;
    }

    public IdentityLock getImmutableLock() {
        return null;
    }

    public IdentityLock getLock() {
        return null;
    }

    public int numAttributes() {
        return 0;
    }

    public boolean hasChildren() {
        return false;
    }

    public TreeNode getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists) {
        return null;
    }

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent, Object key, Object value) {
        return null;
    }

    public void removeAllChildren() {
    }

    public void print(StringBuffer sb, int indent) {
    }

    public void printDetails(StringBuffer sb, int indent) {
    }

    public void printIndent(StringBuffer sb, int indent) {
    }

    public void addChild(Object child_name, TreeNode n) {
    }

    public void printLockInfo(StringBuffer sb, int indent) {
    }

    public boolean isLocked() {
        return false;
    }

    public void releaseAll(Object owner) {
    }

    public void releaseAllForce() {
    }

    public Set acquireAll(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        return null;
    }

    public void setRecursiveTreeCacheInstance(TreeCache cache) {
    }

    public boolean getChildrenLoaded() {
        return false;
    }

    public void setChildrenLoaded(boolean b) {
    }

    public void setChildren(Map children) {
    }

    public void release(Object caller) {
    }

    public void releaseForce() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.fqn != null) {
            sb.append(" Fqn=" + this.fqn);
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

