/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionNameConflictException;

public class RegionManager {
    private Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$RegionManager == null ? (class$org$jboss$cache$eviction$RegionManager = RegionManager.class$("org.jboss.cache.eviction.RegionManager")) : class$org$jboss$cache$eviction$RegionManager));
    public static final int CAPACITY = 200000;
    private Map regionMap_ = new HashMap();
    private Region[] regions_;
    private EvictionPolicy policy_;
    static final String DEFAULT_REGION = "/_default_/";
    static /* synthetic */ Class class$org$jboss$cache$eviction$RegionManager;

    public RegionManager(EvictionPolicy policy) {
        this.policy_ = policy;
        this.regions_ = null;
    }

    public Region createRegion(String fqn, EvictionAlgorithm algorithm) throws RegionNameConflictException {
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("createRegion(): creating region for fqn- " + fqn));
        }
        String newFqn = this.appendFqn(fqn);
        this.checkConflict(newFqn);
        Region region = new Region(newFqn, this.policy_, algorithm);
        this.regionMap_.put(newFqn, region);
        return region;
    }

    public void removeRegion(String fqn) {
        this.regionMap_.remove(fqn);
    }

    private String appendFqn(String fqn) {
        if (!fqn.endsWith("/")) {
            return fqn + "/";
        }
        return fqn;
    }

    public boolean hasRegion(String myFqn) {
        String newFqn = this.appendFqn(myFqn);
        return this.regionMap_.containsKey(newFqn);
    }

    public Region getRegion(String myFqn) {
        Region region;
        Region[] regions = this.getRegions();
        String myRFqn = this.appendFqn(myFqn);
        int i = regions.length - 1;
        while (i >= 0) {
            String fqn = regions[i].getFqn();
            if (myRFqn.startsWith(fqn)) {
                return regions[i];
            }
            --i;
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("getRegion(): not user-specified region found for this fqn- " + myFqn + " will use the global default region"));
        }
        if ((region = (Region)this.regionMap_.get(DEFAULT_REGION)) == null) {
            throw new RuntimeException("RegionManager.getRegion(): Default region (_default_) is not configured! You will need to define it in your EvictionPolicyConfig.");
        }
        return region;
    }

    public Region[] getRegions() {
        if (this.regions_ != null && this.regions_.length == this.regionMap_.size()) {
            return this.regions_;
        }
        Object[] objs = this.regionMap_.values().toArray();
        Region[] regions = new Region[objs.length];
        int i = 0;
        while (i < objs.length) {
            regions[i] = (Region)objs[i];
            ++i;
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("getRegions(): size of region " + regions.length));
        }
        this.regions_ = regions;
        return regions;
    }

    public void checkConflict(String myFqn) throws RegionNameConflictException {
        Region[] regions = this.getRegions();
        int i = 0;
        while (i < regions.length) {
            String fqn = regions[i].getFqn();
            if (myFqn.equals(fqn) || myFqn.startsWith(fqn)) {
                throw new RegionNameConflictException("RegionManager.checkConflict(): new region fqn " + myFqn + " is in conflict with current region fqn- " + fqn);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

