/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jgroups.View;

class TreeCacheGui
extends JFrame
implements WindowListener,
TreeCacheListener,
TreeSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 8576324868563647538L;
    TreeCacheMBean cache;
    DefaultTreeModel tree_model = null;
    Log log = LogFactory.getLog(this.getClass());
    JTree jtree = null;
    DefaultTableModel table_model = new DefaultTableModel();
    JTable table = new JTable(this.table_model);
    MyNode root = new MyNode("/");
    String selected_node = null;
    JPanel tablePanel = null;
    JMenu operationsMenu = null;
    JPopupMenu operationsPopup = null;
    JMenuBar menubar = null;
    static final String SEP = "/";
    private static final int KEY_COL_WIDTH = 20;
    private static final int VAL_COL_WIDTH = 300;

    public TreeCacheGui(TreeCacheMBean cache) throws Exception {
        this.cache = cache;
        cache.addTreeCacheListener(this);
        this.addNotify();
        this.setTitle("TreeCacheGui: mbr=" + this.getLocalAddress());
        this.tree_model = new DefaultTreeModel(this.root);
        this.jtree = new JTree(this.tree_model);
        this.jtree.setDoubleBuffered(true);
        this.jtree.getSelectionModel().setSelectionMode(1);
        JScrollPane scroll_pane = new JScrollPane(this.jtree);
        this.populateTree();
        this.getContentPane().add((Component)scroll_pane, "Center");
        this.addWindowListener(this);
        this.table_model.setColumnIdentifiers(new String[]{"Name", "Value"});
        this.table_model.addTableModelListener(this);
        this.setTableColumnWidths();
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.table.getTableHeader(), "North");
        this.tablePanel.add((Component)this.table, "Center");
        this.getContentPane().add((Component)this.tablePanel, "South");
        this.jtree.addTreeSelectionListener(this);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selRow = TreeCacheGui.this.jtree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = TreeCacheGui.this.jtree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    TreeCacheGui.this.selected_node = TreeCacheGui.this.makeFQN(selPath.getPath());
                    TreeCacheGui.this.jtree.setSelectionPath(selPath);
                    if (e.getModifiers() == 4) {
                        TreeCacheGui.this.operationsPopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.jtree.addMouseListener(ml);
        this.createMenus();
        this.setLocation(50, 50);
        this.setSize(this.getInsets().left + this.getInsets().right + 485, this.getInsets().top + this.getInsets().bottom + 367);
        this.init();
        this.setVisible(true);
    }

    void setSystemExit(boolean flag) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public void tableChanged(TableModelEvent evt) {
        if (evt.getType() == 0) {
            int row = evt.getFirstRow();
            int col = evt.getColumn();
            if (col == 0) {
                String key = (String)this.table_model.getValueAt(row, col);
                String val = (String)this.table_model.getValueAt(row, col + 1);
                if (key != null && val != null) {
                    try {
                        this.cache.put(this.selected_node, (Object)key, (Object)val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String key = (String)this.table_model.getValueAt(row, col - 1);
                String val = (String)this.table.getValueAt(row, col);
                if (key != null && val != null) {
                    this.put(this.selected_node, key, val);
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        String fqn = SEP;
        Map data = null;
        int i = 0;
        while (i < path.getPathCount()) {
            String component_name = ((MyNode)path.getPathComponent((int)i)).name;
            if (!component_name.equals(SEP)) {
                fqn = fqn.equals(SEP) ? fqn + component_name : fqn + SEP + component_name;
            }
            ++i;
        }
        data = this.getData(fqn);
        if (data != null) {
            this.getContentPane().add((Component)this.tablePanel, "South");
            this.populateTable(data);
            this.validate();
        } else {
            this.clearTable();
            this.getContentPane().remove(this.tablePanel);
            this.validate();
        }
    }

    public void nodeCreated(Fqn fqn) {
        MyNode n = this.root.add(fqn.toString());
        if (n != null) {
            MyNode p = (MyNode)n.getParent();
            this.tree_model.reload(p);
            this.jtree.scrollPathToVisible(new TreePath(n.getPath()));
        }
    }

    public void nodeRemoved(Fqn fqn) {
        MyNode n = this.root.findNode(fqn.toString());
        if (n != null) {
            n.removeAllChildren();
            TreeNode par = n.getParent();
            n.removeFromParent();
            this.tree_model.reload(par);
        }
    }

    public void nodeLoaded(Fqn fqn) {
        this.nodeCreated(fqn);
    }

    public void nodeEvicted(Fqn fqn) {
        this.nodeRemoved(fqn);
    }

    public void nodeModified(Fqn fqn) {
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    public void viewChange(final View new_view) {
        new Thread(){

            public void run() {
                Vector mbrship;
                if (new_view != null && (mbrship = new_view.getMembers()) != null) {
                    TreeCacheGui.this._put(TreeCacheGui.SEP, "members", mbrship);
                    TreeCacheGui.this._put(TreeCacheGui.SEP, "coordinator", mbrship.firstElement());
                }
            }
        }.start();
    }

    public void run() {
    }

    void init() {
        Vector mbrship = null;
        this.addGuiNode(SEP);
        Vector vector = mbrship = this.getMembers() != null ? (Vector)this.getMembers().clone() : null;
        if (mbrship != null && mbrship.size() > 0) {
            this._put(SEP, "members", mbrship);
            this._put(SEP, "coordinator", mbrship.firstElement());
        }
    }

    private void populateTree() {
        this.addGuiNode(SEP);
    }

    void addGuiNode(String fqn) {
        if (fqn == null) {
            return;
        }
        this.root.add(fqn);
        Set children = this.getChildrenNames(fqn);
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                String child_name = it.next().toString();
                this.addGuiNode(fqn + SEP + child_name);
            }
        }
    }

    String makeFQN(Object[] path) {
        String tmp_name;
        StringBuffer sb = new StringBuffer("");
        if (path == null) {
            return null;
        }
        int i = 0;
        while (i < path.length) {
            tmp_name = ((MyNode)path[i]).name;
            if (!tmp_name.equals(SEP)) {
                sb.append(SEP + tmp_name);
            }
            ++i;
        }
        tmp_name = sb.toString();
        if (tmp_name.length() == 0) {
            return SEP;
        }
        return tmp_name;
    }

    void clearTable() {
        int num_rows = this.table.getRowCount();
        if (num_rows > 0) {
            int i = 0;
            while (i < num_rows) {
                this.table_model.removeRow(0);
                ++i;
            }
            this.table_model.fireTableRowsDeleted(0, num_rows - 1);
            this.repaint();
        }
    }

    void populateTable(Map data) {
        String strval = "<null>";
        int num_rows = 0;
        if (data == null) {
            return;
        }
        num_rows = data.size();
        this.clearTable();
        if (num_rows > 0) {
            Iterator it = data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val != null) {
                    strval = val.toString();
                }
                this.table_model.addRow(new Object[]{key, strval});
            }
            this.table_model.fireTableRowsInserted(0, num_rows - 1);
            this.validate();
        }
    }

    private void setTableColumnWidths() {
        this.table.sizeColumnsToFit(1);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setMinWidth(20);
        column.setPreferredWidth(20);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
    }

    private void createMenus() {
        this.menubar = new JMenuBar();
        this.operationsMenu = new JMenu("Operations");
        AddNodeAction addNode = new AddNodeAction();
        addNode.putValue("Name", "Add to this node");
        RemoveNodeAction removeNode = new RemoveNodeAction();
        removeNode.putValue("Name", "Remove this node");
        AddModifyDataForNodeAction addModAction = new AddModifyDataForNodeAction();
        addModAction.putValue("Name", "Add/Modify data");
        PrintLockInfoAction print_locks = new PrintLockInfoAction();
        print_locks.putValue("Name", "Print lock information (stdout)");
        ReleaseAllLocksAction release_locks = new ReleaseAllLocksAction();
        release_locks.putValue("Name", "Release all locks");
        ExitAction exitAction = new ExitAction();
        exitAction.putValue("Name", "Exit");
        this.operationsMenu.add(addNode);
        this.operationsMenu.add(removeNode);
        this.operationsMenu.add(addModAction);
        this.operationsMenu.add(print_locks);
        this.operationsMenu.add(release_locks);
        this.operationsMenu.add(exitAction);
        this.menubar.add(this.operationsMenu);
        this.setJMenuBar(this.menubar);
        this.operationsPopup = new JPopupMenu();
        this.operationsPopup.add(addNode);
        this.operationsPopup.add(removeNode);
        this.operationsPopup.add(addModAction);
    }

    Object getLocalAddress() {
        try {
            return this.cache.getLocalAddress();
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.getLocalAddress(): " + t));
            return null;
        }
    }

    Map getData(String fqn) {
        if (fqn == null) {
            return null;
        }
        Set keys = this.getKeys(fqn);
        if (keys == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this.get(fqn, key);
            if (value == null) continue;
            data.put(key, value);
        }
        return data;
    }

    void put(String fqn, Map m) {
        try {
            this.cache.put(fqn, m);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.put(): " + t));
        }
    }

    void put(String fqn, String key, Object value) {
        try {
            this.cache.put(fqn, (Object)key, value);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.put(): " + t));
        }
    }

    void _put(String fqn, String key, Object value) {
        try {
            this.cache._put(null, fqn, (Object)key, value, false);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui._put(): " + t));
        }
    }

    Set getKeys(String fqn) {
        try {
            return this.cache.getKeys(fqn);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.getKeys(): " + t));
            return null;
        }
    }

    Object get(String fqn, String key) {
        try {
            return this.cache.get(fqn, (Object)key);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.get(): " + t));
            return null;
        }
    }

    Set getChildrenNames(String fqn) {
        try {
            return this.cache.getChildrenNames(fqn);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.getChildrenNames(): " + t));
            return null;
        }
    }

    Vector getMembers() {
        try {
            return this.cache.getMembers();
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.getMembers(): " + t));
            return null;
        }
    }

    class MyNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1578599138419577069L;
        String name = "<unnamed>";

        MyNode(String name) {
            this.name = name;
        }

        public MyNode add(String fqn) {
            MyNode ret = null;
            if (fqn == null) {
                return null;
            }
            MyNode curr = this;
            StringTokenizer tok = new StringTokenizer(fqn, TreeCacheGui.SEP);
            while (tok.hasMoreTokens()) {
                String child_name = tok.nextToken();
                MyNode n = curr.findChild(child_name);
                if (n == null) {
                    n = new MyNode(child_name);
                    if (ret == null) {
                        ret = n;
                    }
                    curr.add(n);
                }
                curr = n;
            }
            return ret;
        }

        public void remove(String fqn) {
            this.removeFromParent();
        }

        MyNode findNode(String fqn) {
            if (fqn == null) {
                return null;
            }
            MyNode curr = this;
            StringTokenizer tok = new StringTokenizer(fqn, TreeCacheGui.SEP);
            while (tok.hasMoreTokens()) {
                String child_name = tok.nextToken();
                MyNode n = curr.findChild(child_name);
                if (n == null) {
                    return null;
                }
                curr = n;
            }
            return curr;
        }

        MyNode findChild(String relative_name) {
            if (relative_name == null || this.getChildCount() == 0) {
                return null;
            }
            int i = 0;
            while (i < this.getChildCount()) {
                MyNode child = (MyNode)this.getChildAt(i);
                if (child.name != null && child.name.equals(relative_name)) {
                    return child;
                }
                ++i;
            }
            return null;
        }

        String print(int indent) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < indent) {
                sb.append(" ");
                ++i;
            }
            if (!this.isRoot()) {
                if (this.name == null) {
                    sb.append("/<unnamed>");
                } else {
                    sb.append(TreeCacheGui.SEP + this.name);
                }
            }
            sb.append("\n");
            if (this.getChildCount() > 0) {
                indent = this.isRoot() ? 0 : (indent += 4);
                int i2 = 0;
                while (i2 < this.getChildCount()) {
                    sb.append(((MyNode)this.getChildAt(i2)).print(indent));
                    ++i2;
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.name;
        }
    }

    class AddModifyDataForNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3593129982953807846L;

        AddModifyDataForNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HashMap<String, String> data = TreeCacheGui.this.getData(TreeCacheGui.this.selected_node);
            if (data == null) {
                TreeCacheGui.this.clearTable();
                data = new HashMap<String, String>();
                data.put("Add Key", "Add Value");
            }
            TreeCacheGui.this.populateTable(data);
            TreeCacheGui.this.getContentPane().add((Component)TreeCacheGui.this.tablePanel, "South");
            TreeCacheGui.this.validate();
        }
    }

    class RemoveNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 8985697625953238855L;

        RemoveNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TreeCacheGui.this.cache.remove(TreeCacheGui.this.selected_node);
            }
            catch (Throwable t) {
                TreeCacheGui.this.log.error((Object)("RemoveNodeAction.actionPerformed(): " + t));
            }
        }
    }

    class ReleaseAllLocksAction
    extends AbstractAction {
        private static final long serialVersionUID = 3796901116451916116L;

        ReleaseAllLocksAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TreeCacheGui.this.cache.releaseAllLocks(TreeCacheGui.SEP);
        }
    }

    class PrintLockInfoAction
    extends AbstractAction {
        private static final long serialVersionUID = 5577441016277949170L;

        PrintLockInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("\n*** lock information ****\n" + TreeCacheGui.this.cache.printLockInfo());
        }
    }

    class AddNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 5568518714172267901L;

        AddNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (TreeCacheGui.this.selected_node != null) {
                fqnTextField.setText(TreeCacheGui.this.selected_node);
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Add DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                TreeCacheGui.this.put(userInput, null);
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 8895044368299888998L;

        ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TreeCacheGui.this.dispose();
        }
    }
}

