/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.oracle.aq;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.xa.client.OracleXADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.soa.esb.oracle.aq.DestinationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AQUtil {
    public static Log log = LogFactory.getLog(AQUtil.class);
    private static final String NORMAL_QUEUE_TYPE = "NORMAL_QUEUE";
    private static final String EXCEPTION_QUEUE_TYPE = "EXCEPTION_QUEUE";
    private static final String QUEUE_RECIPIENTS_STRING = "SINGLE";
    private static final String TOPIC_RECIPIENTS_STRING = "MULTIPLE";
    private static final String GET_QUEUES_SQL = "SELECT allq.OWNER as owner, allq.NAME as name, allq.QUEUE_TYPE as queue_type, allqt.RECIPIENTS as recipients from SYS.ALL_QUEUES allq, SYS.ALL_QUEUE_TABLES allqt  where allq.QUEUE_TABLE = allqt.QUEUE_TABLE order by name asc";
    private static final String GET_QUEUES_PSQL = "SELECT allq.OWNER as owner, allq.NAME as name, allq.QUEUE_TYPE as queue_type, allqt.RECIPIENTS as recipients from SYS.ALL_QUEUES allq, SYS.ALL_QUEUE_TABLES allqt  where allq.QUEUE_TABLE = allqt.QUEUE_TABLE and upper(allq.OWNER) in (?) order by name asc";

    public static DataSource getSQLDataSource(String serverName, String dbInstance, int portNo, String driverName) throws SQLException {
        OracleDataSource ds = new OracleDataSource();
        ds.setDatabaseName(dbInstance);
        ds.setDriverType(driverName);
        ds.setServerName(serverName);
        ds.setPortNumber(portNo);
        ds.setNetworkProtocol("tcp");
        return ds;
    }

    public static XADataSource getXADataSource(String serverName, String dbInstance, int portNo, String driverName) throws SQLException {
        OracleXADataSource ds = new OracleXADataSource();
        ds.setDatabaseName(dbInstance);
        ds.setDriverType(driverName);
        ds.setServerName(serverName);
        ds.setPortNumber(portNo);
        ds.setNetworkProtocol("tcp");
        return ds;
    }

    public static DataSource getSQLDataSource(String serverName, String dbInstance, int portNo, String driverName, String username, String password) throws SQLException {
        OracleDataSource ds = new OracleDataSource();
        ds.setDatabaseName(dbInstance);
        ds.setDriverType(driverName);
        ds.setServerName(serverName);
        ds.setPortNumber(portNo);
        ds.setNetworkProtocol("tcp");
        ds.setUser(username);
        ds.setPassword(password);
        return ds;
    }

    public static XADataSource getXASQLDataSource(String serverName, String dbInstance, int portNo, String driverName, String username, String password) throws SQLException {
        OracleXADataSource ds = new OracleXADataSource();
        ds.setDatabaseName(dbInstance);
        ds.setDriverType(driverName);
        ds.setServerName(serverName);
        ds.setPortNumber(portNo);
        ds.setNetworkProtocol("tcp");
        ds.setUser(username);
        ds.setPassword(password);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DestinationInfo> getDestinationInfoList(DataSource ds, String commaSeperatedQueueOwnerList) {
        ArrayList<DestinationInfo> list = new ArrayList<DestinationInfo>();
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            connection = ds.getConnection();
            rs = null;
            if (commaSeperatedQueueOwnerList != null) {
                statement = connection.prepareStatement(GET_QUEUES_PSQL);
                statement.setString(1, commaSeperatedQueueOwnerList.toUpperCase());
            } else {
                statement = connection.prepareStatement(GET_QUEUES_SQL);
            }
            rs = statement.executeQuery();
            while (rs.next()) {
                DestinationInfo info = AQUtil.createDestInfo(rs);
                if (info == null) continue;
                list.add(info);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught sqlexception", (Throwable)e);
        }
        finally {
            block24: {
                block23: {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e) {
                            if (!log.isDebugEnabled()) break block23;
                            log.debug((Object)"sqlexception while closing prepared statement", (Throwable)e);
                        }
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        if (!log.isDebugEnabled()) break block24;
                        log.debug((Object)"sqlexception while closing connection", (Throwable)e);
                    }
                }
            }
        }
        return list;
    }

    private static DestinationInfo createDestInfo(ResultSet rs) throws SQLException {
        DestinationInfo info = null;
        boolean exceptionDestination = false;
        boolean topic = false;
        String queueType = rs.getString("queue_type");
        String recipients = rs.getString("recipients");
        if (queueType.equalsIgnoreCase(NORMAL_QUEUE_TYPE)) {
            exceptionDestination = false;
        } else if (queueType.equalsIgnoreCase(EXCEPTION_QUEUE_TYPE)) {
            exceptionDestination = true;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ignoring unknown queue type:" + queueType));
            }
            return null;
        }
        if (recipients.equalsIgnoreCase(QUEUE_RECIPIENTS_STRING)) {
            topic = false;
        } else if (recipients.equalsIgnoreCase(TOPIC_RECIPIENTS_STRING)) {
            topic = true;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ignoring unknown recipients type:" + recipients));
            }
            return null;
        }
        info = new DestinationInfo(rs.getString("owner"), rs.getString("name"), exceptionDestination, topic);
        return info;
    }
}

