/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageNumberGenerator;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.pagination.Title;
import org.xml.sax.Locator;

public class PageSequence
extends FObj {
    private String country;
    private String format;
    private String language;
    private int letterValue;
    private char groupingSeparator;
    private int groupingSize;
    private String id;
    private Numeric initialPageNumber;
    private int forcePageCount;
    private String masterReference;
    private Root root;
    private Map flowMap;
    private int startingPageNumber = 0;
    private PageNumberGenerator pageNumberGenerator;
    private SimplePageMaster simplePageMaster;
    private PageSequenceMaster pageSequenceMaster;
    private Title titleFO;
    private Flow mainFlow = null;

    public PageSequence(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.country = pList.get(75).getString();
        this.format = pList.get(101).getString();
        this.language = pList.get(121).getString();
        this.letterValue = pList.get(129).getEnum();
        this.groupingSeparator = pList.get(104).getCharacter();
        this.groupingSize = pList.get(105).getNumber().intValue();
        this.id = pList.get(113).getString();
        this.initialPageNumber = pList.get(115).getNumeric();
        this.forcePageCount = pList.get(100).getEnum();
        this.masterReference = pList.get(141).getString();
        if (this.masterReference == null || this.masterReference.equals("")) {
            this.missingPropertyError("master-reference");
        }
    }

    protected void startOfNode() throws FOPException {
        this.root = (Root)this.parent;
        this.flowMap = new HashMap();
        this.simplePageMaster = this.root.getLayoutMasterSet().getSimplePageMaster(this.masterReference);
        if (this.simplePageMaster == null) {
            this.pageSequenceMaster = this.root.getLayoutMasterSet().getPageSequenceMaster(this.masterReference);
            if (this.pageSequenceMaster == null) {
                throw new ValidationException("master-reference '" + this.masterReference + "' for fo:page-sequence matches no" + " simple-page-master or page-sequence-master", this.locator);
            }
            this.pageSequenceMaster.reset();
        }
        this.pageNumberGenerator = new PageNumberGenerator(this.format, this.groupingSeparator, this.groupingSize, this.letterValue);
        this.checkId(this.id);
        this.getFOEventHandler().startPageSequence(this);
    }

    protected void endOfNode() throws FOPException {
        if (this.mainFlow == null) {
            this.missingChildElementError("(title?,static-content*,flow)");
        }
        this.getFOEventHandler().endPageSequence(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if (localName.equals("title")) {
                if (this.titleFO != null) {
                    this.tooManyNodesError(loc, "fo:title");
                } else if (this.flowMap.size() > 0) {
                    this.nodesOutOfOrderError(loc, "fo:title", "fo:static-content");
                } else if (this.mainFlow != null) {
                    this.nodesOutOfOrderError(loc, "fo:title", "fo:flow");
                }
            } else if (localName.equals("static-content")) {
                if (this.mainFlow != null) {
                    this.nodesOutOfOrderError(loc, "fo:static-content", "fo:flow");
                }
            } else if (localName.equals("flow")) {
                if (this.mainFlow != null) {
                    this.tooManyNodesError(loc, "fo:flow");
                }
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public void addChildNode(FONode child) throws FOPException {
        int childId = child.getNameId();
        if (childId == 55) {
            this.titleFO = (Title)child;
        } else if (childId == 11) {
            this.mainFlow = (Flow)child;
            this.addFlow(this.mainFlow);
        } else if (childId == 45) {
            this.addFlow((StaticContent)child);
            String flowName = ((StaticContent)child).getFlowName();
            this.flowMap.put(flowName, child);
        }
    }

    private void addFlow(Flow flow) throws ValidationException {
        String flowName = flow.getFlowName();
        if (this.hasFlowName(flowName)) {
            throw new ValidationException("duplicate flow-name \"" + flowName + "\" found within fo:page-sequence", flow.getLocator());
        }
        if (!(this.root.getLayoutMasterSet().regionNameExists(flowName) || flowName.equals("xsl-before-float-separator") || flowName.equals("xsl-footnote-separator"))) {
            throw new ValidationException("flow-name \"" + flowName + "\" could not be mapped to a region-name in the" + " layout-master-set", flow.getLocator());
        }
    }

    public void initPageNumber() {
        int pageNumberType = 0;
        if (this.initialPageNumber.getEnum() != 0) {
            this.startingPageNumber = this.root.getEndingPageNumberOfPreviousSequence() + 1;
            pageNumberType = this.initialPageNumber.getEnum();
            if (pageNumberType == 11) {
                if (this.startingPageNumber % 2 == 0) {
                    ++this.startingPageNumber;
                }
            } else if (pageNumberType == 10 && this.startingPageNumber % 2 == 1) {
                ++this.startingPageNumber;
            }
        } else {
            int pageStart = this.initialPageNumber.getValue();
            this.startingPageNumber = pageStart > 0 ? pageStart : 1;
        }
    }

    public int getStartingPageNumber() {
        return this.startingPageNumber;
    }

    public StaticContent getStaticContent(String name) {
        return (StaticContent)this.flowMap.get(name);
    }

    public String getId() {
        return this.id;
    }

    public Title getTitleFO() {
        return this.titleFO;
    }

    public Flow getMainFlow() {
        return this.mainFlow;
    }

    public boolean hasFlowName(String flowName) {
        return this.flowMap.containsKey(flowName);
    }

    public Map getFlowMap() {
        return this.flowMap;
    }

    public SimplePageMaster getNextSimplePageMaster(int page, boolean isFirstPage, boolean isLastPage, boolean isBlank) throws FOPException {
        boolean isOddPage;
        if (this.pageSequenceMaster == null) {
            return this.simplePageMaster;
        }
        boolean bl = isOddPage = page % 2 == 1;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("getNextSimplePageMaster(page=" + page + " isOdd=" + isOddPage + " isFirst=" + isFirstPage + " isLast=" + isLastPage + " isBlank=" + isBlank + ")"));
        }
        return this.pageSequenceMaster.getNextSimplePageMaster(isOddPage, isFirstPage, isLastPage, isBlank);
    }

    public boolean goToPreviousSimplePageMaster() {
        if (this.pageSequenceMaster == null) {
            return true;
        }
        return this.pageSequenceMaster.goToPreviousSimplePageMaster();
    }

    public boolean hasPagePositionLast() {
        if (this.pageSequenceMaster == null) {
            return false;
        }
        return this.pageSequenceMaster.hasPagePositionLast();
    }

    public String makeFormattedPageNumber(int pageNumber) {
        return this.pageNumberGenerator.makeFormattedPageNumber(pageNumber);
    }

    public Root getRoot() {
        return this.root;
    }

    public String getMasterReference() {
        return this.masterReference;
    }

    public String getLocalName() {
        return "page-sequence";
    }

    public int getNameId() {
        return 32;
    }

    public int getForcePageCount() {
        return this.forcePageCount;
    }

    public Numeric getInitialPageNumber() {
        return this.initialPageNumber;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }
}

