/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.mina;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.AbstractListener;
import org.apache.ftpserver.listener.FtpProtocolHandler;
import org.apache.ftpserver.listener.mina.FtpServerProtocolCodecFactory;
import org.apache.ftpserver.listener.mina.MinaFtpProtocolHandler;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaListener
extends AbstractListener {
    private final Logger LOG = LoggerFactory.getLogger((Class)MinaListener.class);
    private IoAcceptor acceptor;
    private InetSocketAddress address;
    private MinaFtpProtocolHandler protocolHandler;
    private SocketAcceptorConfig cfg;
    boolean suspended = false;
    private int numberOfIoProcessingThread = Runtime.getRuntime().availableProcessors() + 1;
    private ExecutorService ioProcessingExecutor = Executors.newCachedThreadPool();
    private ExecutorService filterExecutor = Executors.newCachedThreadPool();

    public void start(FtpServerContext serverContext) throws Exception {
        this.acceptor = new SocketAcceptor(this.numberOfIoProcessingThread, (Executor)this.ioProcessingExecutor);
        this.address = this.getServerAddress() != null ? new InetSocketAddress(this.getServerAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.cfg = new SocketAcceptorConfig();
        this.cfg.setReuseAddress(true);
        this.cfg.getFilterChain().addLast("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new FtpServerProtocolCodecFactory()));
        this.cfg.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.cfg.setThreadModel(ThreadModel.MANUAL);
        DefaultIoFilterChainBuilder filterChainBuilder = this.cfg.getFilterChain();
        filterChainBuilder.addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.filterExecutor));
        ((SocketSessionConfig)this.cfg.getSessionConfig()).setReceiveBufferSize(512);
        if (this.isImplicitSsl()) {
            SSLFilter sslFilter = new SSLFilter(this.getSsl().getSSLContext());
            this.cfg.getFilterChain().addFirst("sslFilter", (IoFilter)sslFilter);
        }
        this.protocolHandler = new MinaFtpProtocolHandler(serverContext, new FtpProtocolHandler(serverContext), this);
        this.acceptor.bind((SocketAddress)this.address, (IoHandler)this.protocolHandler, (IoServiceConfig)this.cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.acceptor != null) {
            this.acceptor.unbindAll();
            this.acceptor = null;
        }
        if (this.ioProcessingExecutor != null) {
            this.ioProcessingExecutor.shutdown();
            try {
                this.ioProcessingExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.filterExecutor != null) {
            this.filterExecutor.shutdown();
            try {
                this.filterExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isStopped() {
        return this.acceptor == null;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() {
        if (this.acceptor != null && this.suspended) {
            try {
                this.acceptor.bind((SocketAddress)this.address, (IoHandler)this.protocolHandler, (IoServiceConfig)this.cfg);
            }
            catch (IOException e) {
                this.LOG.error("Failed to resume listener", (Throwable)e);
            }
        }
    }

    public void suspend() {
        if (this.acceptor != null && !this.suspended) {
            this.acceptor.unbind((SocketAddress)this.address);
        }
    }

    public ExecutorService getFilterExecutor() {
        return this.filterExecutor;
    }

    public void setFilterExecutor(ExecutorService filterExecutor) {
        this.filterExecutor = filterExecutor;
    }

    public ExecutorService getIoProcessingExecutor() {
        return this.ioProcessingExecutor;
    }

    public void setIoProcessingExecutor(ExecutorService ioProcessingExecutor) {
        this.ioProcessingExecutor = ioProcessingExecutor;
    }

    public int getNumberOfIoProcessingThread() {
        return this.numberOfIoProcessingThread;
    }

    public void setNumberOfIoProcessingThread(int numberOfIoProcessingThread) {
        this.numberOfIoProcessingThread = numberOfIoProcessingThread;
    }
}

