/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.listener.ConnectionManagerObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerImpl
implements ConnectionManager,
Component {
    private final Logger LOG = LoggerFactory.getLogger((Class)ConnectionManagerImpl.class);
    private ConnectionManagerObserver observer;
    private Timer timer;
    private Vector conList = new Vector();
    private int maxConnections;
    private int maxLogins;
    private boolean anonEnabled;
    private int maxAnonLogins;
    private int defaultIdleSec;
    private int pollIntervalSec;

    public void configure(Configuration config) throws FtpException {
        this.maxConnections = config.getInt("max-connection", 20);
        this.maxLogins = config.getInt("max-login", 10);
        this.anonEnabled = config.getBoolean("anonymous-login-enabled", true);
        this.maxAnonLogins = config.getInt("max-anonymous-login", 10);
        this.defaultIdleSec = config.getInt("default-idle-time", 60);
        this.pollIntervalSec = config.getInt("timeout-poll-interval", 60);
        this.timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            public void run() {
                ConnectionManagerImpl.this.timerTask();
            }
        };
        this.timer.schedule(timerTask, 0L, (long)this.pollIntervalSec * 1000L);
    }

    public void setObserver(ConnectionManagerObserver observer) {
        this.observer = observer;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxLogins() {
        return this.maxLogins;
    }

    public boolean isAnonymousLoginEnabled() {
        return this.anonEnabled;
    }

    public int getDefaultIdleSec() {
        return this.defaultIdleSec;
    }

    public int getMaxAnonymousLogins() {
        return this.maxAnonLogins;
    }

    public List getAllConnections() {
        Vector cons = this.conList;
        if (cons == null) {
            return new Vector();
        }
        return new Vector(cons);
    }

    public void newConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        Vector cons = this.conList;
        if (cons == null) {
            return;
        }
        cons.add(connection);
        ConnectionManagerObserver observer = this.observer;
        if (observer != null) {
            observer.openedConnection(connection);
            observer.updatedConnection(connection);
        }
        connection.getSession().setMaxIdleTime(this.defaultIdleSec);
        if (connection instanceof Runnable) {
            new Thread((Runnable)((Object)connection)).start();
        }
    }

    public void updateConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        ConnectionManagerObserver observer = this.observer;
        if (observer != null) {
            observer.updatedConnection(connection);
        }
    }

    public void closeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        Vector cons = this.conList;
        if (cons != null) {
            cons.remove(connection);
        }
        connection.close();
        ConnectionManagerObserver observer = this.observer;
        if (observer != null) {
            observer.closedConnection(connection);
        }
    }

    public void closeAllConnections() {
        List allCons = this.getAllConnections();
        Iterator it = allCons.iterator();
        while (it.hasNext()) {
            Connection connection = (Connection)it.next();
            this.closeConnection(connection);
        }
        allCons.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerTask() {
        ArrayList<Connection> inactiveCons = new ArrayList<Connection>();
        long currTime = System.currentTimeMillis();
        Vector conList = this.conList;
        if (conList == null) {
            return;
        }
        Vector vector = conList;
        synchronized (vector) {
            int i = conList.size();
            while (--i >= 0) {
                FtpSessionImpl session;
                Connection con = (Connection)conList.get(i);
                if (con == null || (session = (FtpSessionImpl)con.getSession()) == null) continue;
                if (session.isTimeout(currTime)) {
                    inactiveCons.add(con);
                    continue;
                }
                ServerDataConnectionFactory dataCon = session.getServerDataConnection();
                if (dataCon == null) continue;
                ServerDataConnectionFactory serverDataConnectionFactory = dataCon;
                synchronized (serverDataConnectionFactory) {
                    if (dataCon.isTimeout(currTime)) {
                        this.LOG.info("Removing idle data connection for " + session.getUser());
                        dataCon.closeDataConnection();
                    }
                }
            }
        }
        Iterator conIt = inactiveCons.iterator();
        while (conIt.hasNext()) {
            FtpSession session;
            Connection connection = (Connection)conIt.next();
            if (connection == null || (session = connection.getSession()) == null) continue;
            this.LOG.info("Removing idle user " + session.getUser());
            this.closeConnection(connection);
        }
    }

    public void dispose() {
        Vector cons;
        Timer timer = this.timer;
        if (timer != null) {
            timer.cancel();
            this.timer = null;
        }
        if ((cons = this.conList) != null) {
            this.closeAllConnections();
            this.conList = null;
        }
    }
}

