/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.iprestrictor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.IpRestrictor;
import org.apache.ftpserver.util.IoUtils;
import org.apache.ftpserver.util.RegularExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIpRestrictor
implements IpRestrictor,
Component {
    private final Logger LOG = LoggerFactory.getLogger((Class)FileIpRestrictor.class);
    private static final String LINE_SEP = System.getProperty("line.separator", "\n");
    private String file;
    private Object[][] permissions;

    public void configure(Configuration config) throws FtpException {
        this.file = config.getString("file", "./res/ip.gen");
        File dir = new File(this.file).getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            String dirName = dir.getAbsolutePath();
            this.LOG.error("Cannot create directory - " + dirName);
            throw new FtpException("Cannot create directory : " + dirName);
        }
        this.permissions = this.getPermissions();
    }

    public boolean hasPermission(InetAddress address) throws FtpException {
        String addressStr = address.getHostAddress();
        boolean retVal = true;
        for (int i = 0; i < this.permissions.length; ++i) {
            String ipPattern = (String)this.permissions[i][0];
            RegularExpr regexp = new RegularExpr(ipPattern);
            if (!regexp.isMatch(addressStr)) continue;
            retVal = (Boolean)this.permissions[i][1];
            break;
        }
        return retVal;
    }

    public Object[][] getPermissions() throws FtpException {
        ArrayList<Object[]> permList = new ArrayList<Object[]>();
        if (new File(this.file).exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(this.file));
                String line = null;
                while ((line = br.readLine()) != null) {
                    int spaceIndex;
                    if ((line = line.trim()).equals("") || (spaceIndex = line.indexOf(32)) == -1) continue;
                    String boolStr = line.substring(0, spaceIndex);
                    String regexpStr = line.substring(spaceIndex + 1);
                    Object[] entry = new Object[]{regexpStr, new Boolean(boolStr.equals("true"))};
                    permList.add(entry);
                }
            }
            catch (IOException ex) {
                try {
                    this.LOG.error("FileIpRestrictor.getPermissions()", (Throwable)ex);
                    throw new FtpException("FileIpRestrictor.getPermissions()", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IoUtils.close(br);
                    throw throwable;
                }
            }
            IoUtils.close(br);
        }
        Object[][] permissions = new Object[permList.size()][2];
        for (int i = 0; i < permissions.length; ++i) {
            permissions[i] = (Object[])permList.get(i);
        }
        return permissions;
    }

    public void setPermissions(Object[][] permissions) throws FtpException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.file);
            for (int i = 0; i < permissions.length; ++i) {
                fw.write(String.valueOf(permissions[i][1]));
                fw.write(32);
                fw.write(String.valueOf(permissions[i][0]));
                fw.write(LINE_SEP);
            }
            this.permissions = permissions;
        }
        catch (IOException ex) {
            try {
                this.LOG.error("FileIpRestrictor.setPermissions()", (Throwable)ex);
                throw new FtpException("FileIpRestrictor.setPermissions()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(fw);
                throw throwable;
            }
        }
        IoUtils.close(fw);
    }

    public void dispose() {
    }
}

