/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ftplet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletContext;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.ftplet.IsolatingFtpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFtpletContainer
implements Component,
FtpletContainer {
    private final Logger LOG = LoggerFactory.getLogger((Class)DefaultFtpletContainer.class);
    private List ftplets = new ArrayList();

    public void configure(Configuration config) throws FtpException {
    }

    public void dispose() {
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            try {
                ftpletEnt.ftplet.destroy();
                continue;
            }
            catch (Exception ex) {
                this.LOG.error(ftpletEnt.name + " :: FtpletHandler.destroy()", (Throwable)ex);
            }
        }
        this.ftplets.clear();
    }

    public void addFtplet(String name, Ftplet ftplet) {
        if (this.getFtplet(name) != null) {
            throw new IllegalArgumentException("Ftplet with name \"" + name + "\" already registred with container");
        }
        this.ftplets.add(new FtpletEntry(name, ftplet));
    }

    public Ftplet removeFtplet(String name) {
        int sz = this.ftplets.size();
        Ftplet removedFtplet = null;
        for (int i = 0; i < sz; ++i) {
            FtpletEntry entry = (FtpletEntry)this.ftplets.get(i);
            if (!name.equals(entry.name)) continue;
            this.ftplets.remove(i);
            removedFtplet = entry.ftplet;
            break;
        }
        return removedFtplet;
    }

    public Ftplet getFtplet(String name) {
        if (name == null) {
            return null;
        }
        Ftplet ftplet = null;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            if (!ftpletEnt.name.equals(name)) continue;
            ftplet = ftpletEnt.ftplet;
            break;
        }
        return ftplet;
    }

    public void destroy() {
        this.dispose();
    }

    public FtpletEnum onConnect(FtpSession session, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onConnect((FtpSession)isolatedSession, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onDisconnect(FtpSession session, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onDisconnect((FtpSession)isolatedSession, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onLogin(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onLogin((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onDeleteStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onDeleteStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onDeleteEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onDeleteEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onUploadStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onUploadStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onUploadEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onUploadEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onDownloadStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onDownloadStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onDownloadEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onDownloadEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onRmdirStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onRmdirStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onRmdirEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onRmdirEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onMkdirStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onMkdirStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onMkdirEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onMkdirEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onAppendStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onAppendStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onAppendEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onAppendEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onUploadUniqueStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onUploadUniqueStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onUploadUniqueEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onUploadUniqueEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onRenameStart(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onRenameStart((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onRenameEnd(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onRenameEnd((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public FtpletEnum onSite(FtpSession session, FtpRequest request, FtpReplyOutput response) throws FtpException, IOException {
        IsolatingFtpSession isolatedSession = new IsolatingFtpSession(session);
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        int sz = this.ftplets.size();
        for (int i = 0; i < sz; ++i) {
            FtpletEntry ftpletEnt = (FtpletEntry)this.ftplets.get(i);
            retVal = ftpletEnt.ftplet.onSite((FtpSession)isolatedSession, request, response);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal != FtpletEnum.RET_DEFAULT) break;
        }
        return retVal;
    }

    public void init(FtpletContext ftpletContext, Configuration config) throws FtpException {
    }

    private static class FtpletEntry {
        final String name;
        final Ftplet ftplet;

        public FtpletEntry(String name, Ftplet ftplet) {
            this.name = name;
            this.ftplet = ftplet;
        }
    }
}

