/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem;

import java.io.File;
import org.apache.ftpserver.filesystem.NativeFileSystemView;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FileSystemManager;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileSystemManager
implements FileSystemManager,
Component {
    private final Logger LOG = LoggerFactory.getLogger((Class)NativeFileSystemManager.class);
    private boolean createHome;
    private boolean caseInsensitive;

    public void configure(Configuration conf) throws FtpException {
        this.createHome = conf.getBoolean("create-home", false);
        this.caseInsensitive = conf.getBoolean("case-insensitive", false);
    }

    public void dispose() {
    }

    public FileSystemView createFileSystemView(User user) throws FtpException {
        if (this.createHome) {
            String homeDirStr = user.getHomeDirectory();
            File homeDir = new File(homeDirStr);
            if (homeDir.isFile()) {
                this.LOG.warn("Not a directory :: " + homeDirStr);
                throw new FtpException("Not a directory :: " + homeDirStr);
            }
            if (!homeDir.exists() && !homeDir.mkdirs()) {
                this.LOG.warn("Cannot create user home :: " + homeDirStr);
                throw new FtpException("Cannot create user home :: " + homeDirStr);
            }
        }
        NativeFileSystemView fsView = new NativeFileSystemView(user, this.caseInsensitive);
        return fsView;
    }
}

