/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.EmptyConfiguration;
import org.apache.ftpserver.ftplet.FtpException;

public class XmlConfiguration
implements Configuration {
    private String name;
    private String value;
    private ArrayList children;

    public XmlConfiguration(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    int getChildCount() {
        if (null == this.children) {
            return 0;
        }
        return this.children.size();
    }

    void setValue(String value) {
        this.value = value;
    }

    void addChild(XmlConfiguration elem) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(elem);
    }

    XmlConfiguration getChild(String param) {
        XmlConfiguration child = null;
        if (this.children != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                XmlConfiguration thisChild = (XmlConfiguration)it.next();
                if (!thisChild.name.equals(param)) continue;
                child = thisChild;
                break;
            }
        }
        return child;
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    public String getString(String param) throws FtpException {
        XmlConfiguration child = this.getChild(param);
        if (child == null) {
            throw new FtpException("Not found : " + param);
        }
        String val = child.value;
        if (val == null) {
            throw new FtpException("Not found : " + param);
        }
        return val;
    }

    public String getString(String param, String defaultVal) {
        try {
            return this.getString(param);
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    public int getInt(String param) throws FtpException {
        String val = this.getString(param);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new FtpException("XmlConfiguration.getInt()", (Throwable)ex);
        }
    }

    public int getInt(String param, int defaultVal) {
        int retVal = defaultVal;
        try {
            retVal = this.getInt(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public long getLong(String param) throws FtpException {
        String val = this.getString(param);
        try {
            return Long.parseLong(val);
        }
        catch (Exception ex) {
            throw new FtpException("XmlConfiguration.getLong()", (Throwable)ex);
        }
    }

    public long getLong(String param, long defaultVal) {
        long retVal = defaultVal;
        try {
            retVal = this.getLong(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public boolean getBoolean(String param) throws FtpException {
        String val = this.getString(param);
        return val.equalsIgnoreCase("true");
    }

    public boolean getBoolean(String param, boolean defaultVal) {
        boolean retVal = defaultVal;
        try {
            retVal = this.getBoolean(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public double getDouble(String param) throws FtpException {
        String val = this.getString(param);
        try {
            return Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new FtpException("XmlConfiguration.getDouble()", (Throwable)ex);
        }
    }

    public double getDouble(String param, double defaultVal) {
        double retVal = defaultVal;
        try {
            retVal = this.getDouble(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public Configuration subset(String param) {
        Object child = this.getChild(param);
        if (child == null) {
            child = EmptyConfiguration.INSTANCE;
        }
        return child;
    }

    public Iterator getKeys() {
        ArrayList<String> arr = new ArrayList<String>(this.children == null ? 1 : this.children.size());
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                XmlConfiguration conf = (XmlConfiguration)this.children.get(i);
                arr.add(conf.name);
            }
        }
        return arr.iterator();
    }
}

