/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.DateUtils;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.StringUtils;

public class SITE_WHO
extends AbstractCommand {
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        session.resetState();
        UserManager userManager = connection.getServerContext().getUserManager();
        boolean isAdmin = userManager.isAdmin(session.getUser().getName());
        if (!isAdmin) {
            out.write(FtpReplyUtil.translate(session, 530, "SITE", null));
            return;
        }
        StringBuffer sb = new StringBuffer();
        List allCons = connection.getServerContext().getConnectionManager().getAllConnections();
        sb.append('\n');
        Iterator conIt = allCons.iterator();
        while (conIt.hasNext()) {
            Connection tmpCon = (Connection)conIt.next();
            FtpSession tmpReq = tmpCon.getSession();
            if (!tmpReq.isLoggedIn()) continue;
            User tmpUsr = tmpReq.getUser();
            sb.append(StringUtils.pad(tmpUsr.getName(), ' ', true, 16));
            sb.append(StringUtils.pad(tmpReq.getClientAddress().getHostAddress(), ' ', true, 16));
            sb.append(StringUtils.pad(DateUtils.getISO8601Date(tmpReq.getLoginTime().getTime()), ' ', true, 20));
            sb.append(StringUtils.pad(DateUtils.getISO8601Date(tmpReq.getLastAccessTime().getTime()), ' ', true, 20));
            sb.append('\n');
        }
        sb.append('\n');
        out.write((FtpReply)new DefaultFtpReply(200, sb.toString()));
    }
}

