/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.usermanager.TransferRateRequest;
import org.apache.ftpserver.usermanager.WriteRequest;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SITE_DESCUSER
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)SITE_DESCUSER.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        session.resetState();
        UserManager userManager = connection.getServerContext().getUserManager();
        boolean isAdmin = userManager.isAdmin(session.getUser().getName());
        if (!isAdmin) {
            out.write(FtpReplyUtil.translate(session, 530, "SITE", null));
            return;
        }
        String argument = request.getArgument();
        int spIndex = argument.indexOf(32);
        if (spIndex == -1) {
            out.write(FtpReplyUtil.translate(session, 503, "SITE.DESCUSER", null));
            return;
        }
        String userName = argument.substring(spIndex + 1);
        FtpServerContext serverContext = connection.getServerContext();
        UserManager usrManager = serverContext.getUserManager();
        User user = null;
        try {
            if (usrManager.doesExist(userName)) {
                user = usrManager.getUserByName(userName);
            }
        }
        catch (FtpException ex) {
            this.LOG.debug("Exception trying to get user from user manager", (Throwable)ex);
            user = null;
        }
        if (user == null) {
            out.write(FtpReplyUtil.translate(session, 501, "SITE.DESCUSER", userName));
            return;
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("\n");
        sb.append("uid             : ").append(user.getName()).append("\n");
        sb.append("userpassword    : ********\n");
        sb.append("homedirectory   : ").append(user.getHomeDirectory()).append("\n");
        sb.append("writepermission : ").append(user.authorize((AuthorizationRequest)new WriteRequest())).append("\n");
        sb.append("enableflag      : ").append(user.getEnabled()).append("\n");
        sb.append("idletime        : ").append(user.getMaxIdleTime()).append("\n");
        TransferRateRequest transferRateRequest = new TransferRateRequest();
        transferRateRequest = (TransferRateRequest)session.getUser().authorize((AuthorizationRequest)transferRateRequest);
        if (transferRateRequest != null) {
            sb.append("uploadrate      : ").append(transferRateRequest.getMaxUploadRate()).append("\n");
            sb.append("downloadrate    : ").append(transferRateRequest.getMaxDownloadRate()).append("\n");
        } else {
            sb.append("uploadrate      : 0\n");
            sb.append("downloadrate    : 0\n");
        }
        sb.append('\n');
        out.write((FtpReply)new DefaultFtpReply(200, sb.toString()));
    }
}

