/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RNTO
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)RNTO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        block26: {
            try {
                FtpletEnum ftpletRet;
                String toFileStr = request.getArgument();
                if (toFileStr == null) {
                    out.write(FtpReplyUtil.translate(session, 501, "RNTO", null));
                    return;
                }
                FtpServerContext serverContext = connection.getServerContext();
                Ftplet ftpletContainer = serverContext.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onRenameStart((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
                FileObject frFile = session.getRenameFrom();
                if (frFile == null) {
                    out.write(FtpReplyUtil.translate(session, 503, "RNTO", null));
                    return;
                }
                FileObject toFile = null;
                try {
                    toFile = session.getFileSystemView().getFileObject(toFileStr);
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", (Throwable)ex);
                }
                if (toFile == null) {
                    out.write(FtpReplyUtil.translate(session, 553, "RNTO.invalid", null));
                    return;
                }
                toFileStr = toFile.getFullName();
                if (!toFile.hasWritePermission()) {
                    out.write(FtpReplyUtil.translate(session, 553, "RNTO.permission", null));
                    return;
                }
                if (!frFile.doesExist()) {
                    out.write(FtpReplyUtil.translate(session, 553, "RNTO.missing", null));
                    return;
                }
                if (frFile.move(toFile)) {
                    out.write(FtpReplyUtil.translate(session, 250, "RNTO", toFileStr));
                    this.LOG.info("File rename (" + session.getUser().getName() + ") " + frFile.getFullName() + " -> " + toFile.getFullName());
                    try {
                        ftpletRet = ftpletContainer.onRenameEnd((FtpSession)session, request, out);
                    }
                    catch (Exception e) {
                        this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                        ftpletRet = FtpletEnum.RET_DISCONNECT;
                    }
                    if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                        serverContext.getConnectionManager().closeConnection(connection);
                        return;
                    }
                    break block26;
                }
                out.write(FtpReplyUtil.translate(session, 553, "RNTO", toFileStr));
            }
            finally {
                session.resetState();
            }
        }
    }
}

