/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.HashMap;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.ftplet.DataConnectionFactory;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.Structure;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.FtpServerSession;
import org.apache.ftpserver.listener.Listener;

public class FtpSessionImpl
implements FtpServerSession {
    private String userArgument;
    private User user;
    private HashMap attributeMap;
    private InetAddress remoteAddr;
    private InetAddress serverAddr;
    private int serverPort;
    private String language;
    private Certificate[] clientCertificates;
    private int maxIdleTime = 0;
    private long connectionTime = 0L;
    private long loginTime = 0L;
    private long lastAccessTime = 0L;
    private IODataConnectionFactory dataConnection;
    private FileSystemView fileSystemView;
    private FileObject renameFrom;
    private long fileOffset;
    private FtpRequest request;
    private DataType dataType = DataType.ASCII;
    private Structure structure = Structure.FILE;
    private FtpServerContext serverContext;
    private Listener listener;

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public FtpSessionImpl(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        this.attributeMap = new HashMap();
        this.userArgument = null;
        this.user = null;
        this.connectionTime = System.currentTimeMillis();
    }

    public void setClientAddress(InetAddress addr) {
        this.remoteAddr = addr;
    }

    public void setFtpDataConnection(IODataConnectionFactory dataCon) {
        this.dataConnection = dataCon;
    }

    public void resetState() {
        this.renameFrom = null;
        this.fileOffset = 0L;
    }

    public void reinitialize() {
        this.userArgument = null;
        this.user = null;
        this.loginTime = 0L;
        this.fileSystemView = null;
        this.renameFrom = null;
        this.fileOffset = 0L;
    }

    public void setLogin(FileSystemView userFsView) {
        this.loginTime = System.currentTimeMillis();
        this.fileSystemView = userFsView;
    }

    public void setLogout() {
        this.loginTime = 0L;
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isLoggedIn() {
        return this.loginTime != 0L;
    }

    public DataConnectionFactory getDataConnection() {
        return this.dataConnection;
    }

    public ServerDataConnectionFactory getServerDataConnection() {
        return this.dataConnection;
    }

    public FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    public Date getConnectionTime() {
        return new Date(this.connectionTime);
    }

    public Date getLoginTime() {
        return new Date(this.loginTime);
    }

    public Date getLastAccessTime() {
        return new Date(this.lastAccessTime);
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long offset) {
        this.fileOffset = offset;
    }

    public FileObject getRenameFrom() {
        return this.renameFrom;
    }

    public void setRenameFrom(FileObject file) {
        this.renameFrom = file;
    }

    public String getUserArgument() {
        return this.userArgument;
    }

    public void setUserArgument(String tmpUserName) {
        this.userArgument = tmpUserName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public InetAddress getClientAddress() {
        return this.remoteAddr;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public void clear() {
        this.attributeMap.clear();
    }

    public boolean isTimeout(long currTime) {
        boolean bActive = true;
        int maxIdleTime = this.getMaxIdleTime();
        if (maxIdleTime > 0) {
            long currIdleTimeMillis = currTime - this.lastAccessTime;
            long maxIdleTimeMillis = (long)maxIdleTime * 1000L;
            bActive = currIdleTimeMillis <= maxIdleTimeMillis;
        }
        return !bActive;
    }

    public boolean isTimeout() {
        return this.isTimeout(System.currentTimeMillis());
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTimeSec) {
        this.maxIdleTime = maxIdleTimeSec;
    }

    public FtpRequest getCurrentRequest() {
        return this.request;
    }

    public void setCurrentRequest(FtpRequest request) {
        this.request = request;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType type) {
        this.dataType = type;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure stru) {
        this.structure = stru;
    }

    public Certificate[] getClientCertificates() {
        return this.clientCertificates;
    }

    public void setClientCertificates(Certificate[] certificates) {
        this.clientCertificates = certificates;
    }

    public InetAddress getServerAddress() {
        return this.serverAddr;
    }

    public void setServerAddress(InetAddress adress) {
        this.serverAddr = adress;
    }

    public FtpServerContext getServerContext() {
        return this.serverContext;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }
}

