/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.PassivePorts;
import org.apache.ftpserver.interfaces.DataConnectionConfig;
import org.apache.ftpserver.interfaces.Ssl;

public class DefaultDataConnectionConfig
implements DataConnectionConfig {
    private int maxIdleTimeMillis = 10000;
    private Ssl ssl;
    private Active active = new Active();
    private Passive passive = new Passive();

    public void setIdleTime(int idleTime) {
        this.maxIdleTimeMillis = idleTime * 1000;
    }

    public void setActive(Active active) {
        this.active = active;
    }

    public void setPassive(Passive passive) {
        this.passive = passive;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public int getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    public boolean isActiveEnabled() {
        return this.active.isEnable();
    }

    public boolean isActiveIpCheck() {
        return this.active.isIpCheck();
    }

    public InetAddress getActiveLocalAddress() {
        return this.active.getLocalAddress();
    }

    public int getActiveLocalPort() {
        return this.active.getLocalPort();
    }

    public InetAddress getPassiveAddress() {
        return this.passive.getAddress();
    }

    public synchronized int getPassivePort() {
        int dataPort = -1;
        int loopTimes = 2;
        Thread currThread = Thread.currentThread();
        while (dataPort == -1 && --loopTimes >= 0 && !currThread.isInterrupted()) {
            dataPort = this.passive.getPassivePorts().reserveNextPort();
            if (dataPort != -1) continue;
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        return dataPort;
    }

    public synchronized void releasePassivePort(int port) {
        this.passive.getPassivePorts().releasePort(port);
        this.notify();
    }

    public Ssl getSSL() {
        return this.ssl;
    }

    public static class Passive {
        private InetAddress address;
        private PassivePorts passivePorts = PassivePorts.parse("0");

        public InetAddress getAddress() {
            return this.address;
        }

        public void setAddress(InetAddress address) {
            this.address = address;
        }

        public PassivePorts getPassivePorts() {
            return this.passivePorts;
        }

        public void setPorts(String ports) {
            this.passivePorts = PassivePorts.parse(ports);
        }
    }

    public static class Active {
        private boolean enable = true;
        private InetAddress localAddress;
        private int localPort = 0;
        private boolean ipCheck = false;

        public Active() {
            try {
                this.localAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new FtpServerConfigurationException("Failed to resolve localhost", e);
            }
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean isIpCheck() {
            return this.ipCheck;
        }

        public void setIpCheck(boolean ipCheck) {
            this.ipCheck = ipCheck;
        }

        public InetAddress getLocalAddress() {
            return this.localAddress;
        }

        public void setLocalAddress(InetAddress localAddress) {
            this.localAddress = localAddress;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public void setLocalPort(int localPort) {
            this.localPort = localPort;
        }
    }
}

