/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class CharArrayCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV;

    static {
        Class<?> clazz;
        CNV = new HashMap<Class, Converter>();
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz, new Converter(){

            public Object convert(Object o) {
                return String.valueOf(o);
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + clazz.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

