/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.SheetListener;

public class ExcelParser
implements DecisionTableParser {
    public static final String DEFAULT_RULESHEET_NAME = "Decision Tables";
    private Map _listners = new HashMap();
    private boolean _useFirstSheet;

    public ExcelParser(Map sheetListners) {
        this._listners = sheetListners;
    }

    public ExcelParser(List sheetListners) {
        this._listners.put(DEFAULT_RULESHEET_NAME, sheetListners);
        this._useFirstSheet = true;
    }

    public ExcelParser(SheetListener listener) {
        ArrayList<SheetListener> listeners = new ArrayList<SheetListener>();
        listeners.add(listener);
        this._listners.put(DEFAULT_RULESHEET_NAME, listeners);
        this._useFirstSheet = true;
    }

    public void parseFile(InputStream inStream) {
        try {
            Workbook workbook = Workbook.getWorkbook((InputStream)inStream);
            if (this._useFirstSheet) {
                Sheet sheet = workbook.getSheet(0);
                this.processSheet(sheet, (List)this._listners.get(DEFAULT_RULESHEET_NAME));
            } else {
                Set sheetNames = this._listners.keySet();
                Iterator iter = sheetNames.iterator();
                while (iter.hasNext()) {
                    String sheetName = (String)iter.next();
                    Sheet sheet = workbook.getSheet(sheetName);
                    this.processSheet(sheet, (List)this._listners.get(sheetName));
                }
            }
        }
        catch (BiffException e) {
            throw new DecisionTableParseException("An error occured opening the workbook. ", e);
        }
        catch (IOException e) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", e);
        }
    }

    private void processSheet(Sheet sheet, List listeners) {
        int maxRows = sheet.getRows();
        Range[] mergedRanges = sheet.getMergedCells();
        for (int i = 0; i < maxRows; ++i) {
            Cell[] row = sheet.getRow(i);
            this.newRow(listeners, i, row.length);
            for (int cellNum = 0; cellNum < row.length; ++cellNum) {
                Cell cell = row[cellNum];
                Range merged = this.getRangeIfMerged(cell, mergedRanges);
                if (merged != null) {
                    Cell topLeft = merged.getTopLeft();
                    this.newCell(listeners, i, cellNum, topLeft.getContents(), topLeft.getColumn());
                    continue;
                }
                this.newCell(listeners, i, cellNum, cell.getContents(), -1);
            }
        }
        this.finishSheet(listeners);
    }

    Range getRangeIfMerged(Cell cell, Range[] mergedRanges) {
        for (int i = 0; i < mergedRanges.length; ++i) {
            Range r = mergedRanges[i];
            Cell topLeft = r.getTopLeft();
            Cell bottomRight = r.getBottomRight();
            if (cell.getRow() < topLeft.getRow() || cell.getRow() > bottomRight.getRow() || cell.getColumn() < topLeft.getColumn() || cell.getColumn() > bottomRight.getColumn()) continue;
            return r;
        }
        return null;
    }

    static String removeTrailingZero(String stringVal) {
        if (stringVal.endsWith(".0")) {
            stringVal = stringVal.substring(0, stringVal.length() - 2);
        }
        return stringVal;
    }

    private void finishSheet(List listeners) {
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            SheetListener listener = (SheetListener)it.next();
            listener.finishSheet();
        }
    }

    private void newRow(List listeners, int row, int cols) {
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            SheetListener listener = (SheetListener)it.next();
            listener.newRow(row, cols);
        }
    }

    public void newCell(List listeners, int row, int column, String value, int mergedColStart) {
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            SheetListener listener = (SheetListener)it.next();
            listener.newCell(row, column, value, mergedColStart);
        }
    }
}

