/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.drools.decisiontable.parser.AbstractColumn;
import org.drools.decisiontable.parser.ArrayCell;
import org.drools.decisiontable.parser.Cell;
import org.drools.decisiontable.parser.Column;
import org.drools.decisiontable.parser.Row;
import org.drools.util.StringUtils;

public class ArrayColumn
extends AbstractColumn {
    private Column type;

    public ArrayColumn(String n, Column typeColumn) {
        super(n);
        this.type = typeColumn;
    }

    public Cell createCell(Row row) {
        return new ArrayCell(row, this);
    }

    public String getCellType() {
        return this.type.getCellType();
    }

    public Column getType() {
        return this.type;
    }

    public String getCondition(String condition, int index) {
        if (index == -1) {
            StringBuffer conditionString = new StringBuffer("ArrayCell(row == r, column == $param");
            if (!StringUtils.isEmpty((String)condition)) {
                conditionString.append(", value ").append(condition);
            }
            conditionString.append(")");
            return conditionString.toString();
        }
        return this.type.getCondition(condition, index);
    }
}

