/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.drools.decisiontable.model.DRLJavaEmitter;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Functions;
import org.drools.decisiontable.model.Global;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.model.Rule;

public class Package
implements DRLJavaEmitter {
    private String _name;
    private List _imports;
    private List _variables;
    private List _rules;
    private Functions _functions;

    public Package(String name) {
        this._name = name;
        this._imports = new LinkedList();
        this._variables = new LinkedList();
        this._rules = new LinkedList();
        this._functions = new Functions();
    }

    public void addImport(Import imp) {
        this._imports.add(imp);
    }

    public void addVariable(Global varz) {
        this._variables.add(varz);
    }

    public void addRule(Rule rule) {
        this._rules.add(rule);
    }

    public void addFunctions(String listing) {
        this._functions.setFunctionsListing(listing);
    }

    public String getName() {
        return this._name;
    }

    public List getImports() {
        return this._imports;
    }

    public List getVariables() {
        return this._variables;
    }

    public List getRules() {
        return this._rules;
    }

    public void renderDRL(DRLOutput out) {
        out.writeLine("package " + this._name.replace(' ', '_') + ";");
        out.writeLine("#generated from Decision Table");
        this.renderDRL(this._imports, out);
        this.renderDRL(this._variables, out);
        this._functions.renderDRL(out);
        this.renderDRL(this._rules, out);
    }

    private void renderDRL(List list, DRLOutput out) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            DRLJavaEmitter emitter = (DRLJavaEmitter)it.next();
            emitter.renderDRL(out);
        }
    }
}

