/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Package;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.xls.ExcelParser;

public class SpreadsheetCompiler {
    public String compile(org.drools.rule.Package pkg, InputStream xlsStream, InputType type) {
        return this.compile(xlsStream, type, new DefaultRuleSheetListener(pkg));
    }

    public String compile(InputStream xlsStream, InputType type) {
        return this.compile(xlsStream, type, new DefaultRuleSheetListener());
    }

    public String compile(InputStream xlsStream, InputType type, RuleSheetListener listener) {
        DecisionTableParser parser = type.createParser(listener);
        parser.parseFile(xlsStream);
        Package rulePackage = listener.getRuleSet();
        DRLOutput out = new DRLOutput();
        rulePackage.renderDRL(out);
        return out.getDRL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String classPathResource, InputType inputType) {
        InputStream stream = this.getClass().getResourceAsStream(classPathResource);
        try {
            String drl;
            String string = drl = this.compile(stream, inputType);
            return string;
        }
        finally {
            this.closeStream(stream);
        }
    }

    public String compile(InputStream stream, String worksheetName) {
        RuleSheetListener listener = this.getRuleSheetListener(stream, worksheetName);
        Package rulePackage = listener.getRuleSet();
        DRLOutput out = new DRLOutput();
        rulePackage.renderDRL(out);
        return out.getDRL();
    }

    private RuleSheetListener getRuleSheetListener(InputStream stream, String worksheetName) {
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        HashMap sheetListeners = new HashMap();
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        listeners.add(listener);
        sheetListeners.put(worksheetName, listeners);
        ExcelParser parser = new ExcelParser(sheetListeners);
        parser.parseFile(stream);
        return listener;
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            System.err.print("WARNING: Wasn't able to correctly close stream for decision table. " + e.getMessage());
        }
    }
}

