/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.stack.GossipRouter;

public class MergeTest
extends TestCase {
    JChannel channel;
    final int TIMES = 10;
    final int router_port = 12000;
    final String bind_addr = "127.0.0.1";
    GossipRouter router;
    JChannel ch1;
    JChannel ch2;
    ViewChecker checker;
    String props = "TUNNEL(router_port=12000;router_host=127.0.0.1;loopback=true):PING(timeout=1000;num_initial_members=2;gossip_host=127.0.0.1;gossip_port=12000):MERGE2(min_interval=3000;max_interval=5000):FD(timeout=1000;max_tries=2;shun=false):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=false;shun=false)";

    public MergeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.startRouter();
        this.checker = new ViewChecker();
        this.ch1 = new JChannel(this.props);
        this.ch1.setReceiver(this.checker);
        this.ch1.connect("demo");
        this.ch2 = new JChannel(this.props);
        this.ch2.setReceiver(this.checker);
        this.ch2.connect("demo");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.ch2.close();
        this.ch1.close();
        this.stopRouter();
    }

    public void testPartitionAndSubsequentMerge() throws Exception {
        this.partitionAndMerge();
    }

    public void testTwoMerges() throws Exception {
        this.partitionAndMerge();
        this.partitionAndMerge();
    }

    private void partitionAndMerge() throws Exception {
        View v = this.ch2.getView();
        System.out.println("view is " + v);
        MergeTest.assertEquals((String)"channel is supposed to have 2 members", (int)2, (int)this.ch2.getView().size());
        System.out.println("++ simulating network partition by stopping the GossipRouter");
        this.stopRouter();
        System.out.println("sleeping for 10 secs");
        this.checker.waitForNViews(2, 10000L);
        v = this.ch1.getView();
        System.out.println("-- ch1.view: " + v);
        v = this.ch2.getView();
        System.out.println("-- ch2.view: " + v);
        MergeTest.assertEquals((String)"view should be 1 (channels should have excluded each other", (int)1, (int)v.size());
        System.out.println("++ simulating merge by starting the GossipRouter again");
        this.startRouter();
        System.out.println("sleeping for 30 secs");
        this.checker.waitForNViews(2, 30000L);
        v = this.ch1.getView();
        System.out.println("-- ch1.view: " + v);
        v = this.ch2.getView();
        System.out.println("-- ch2.view: " + v);
        MergeTest.assertEquals((String)"channel is supposed to have 2 members again after merge", (int)2, (int)this.ch2.getView().size());
    }

    private void startRouter() throws Exception {
        this.router = new GossipRouter(12000, "127.0.0.1");
        this.router.start();
    }

    private void stopRouter() {
        this.router.stop();
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{MergeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private class ViewChecker
    extends ReceiverAdapter {
        final Object mutex = new Object();
        int count = 0;

        private ViewChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View new_view) {
            Object object = this.mutex;
            synchronized (object) {
                ++this.count;
                System.out.println("-- view: " + new_view);
                this.mutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForNViews(int n, long timeout) {
            long sleep_time = timeout;
            Object object = this.mutex;
            synchronized (object) {
                this.count = 0;
                long start = System.currentTimeMillis();
                while (this.count < n) {
                    long curr;
                    try {
                        this.mutex.wait(sleep_time);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if ((sleep_time -= (curr = System.currentTimeMillis()) - start) > 0L) continue;
                }
            }
        }
    }
}

